/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.labels;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.UI;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nullable;

public class LinkLabel<T>
extends JLabel {
    protected boolean myUnderline;
    private LinkListener myLinkListener;
    private T myLinkData;
    private static final Set ourVisitedLinks = new HashSet();
    private boolean myIsLinkActive;
    private String myVisitedLinksKey;
    private int myIconWidth;
    private Icon myHoveringIcon;
    private Icon myInactiveIcon;
    private boolean myClickIsBeingProcessed;
    private boolean myPaintDefaultIcon;
    protected static final int DEFAULT_ICON_GAP = 2;
    protected boolean myPaintUnderline = true;

    public LinkLabel() {
        this("", AllIcons.Ide.Link);
    }

    public LinkLabel(String text, @Nullable Icon icon) {
        this(text, icon, null, null, null);
    }

    public LinkLabel(String text, @Nullable Icon icon, @Nullable LinkListener aListener) {
        this(text, icon, aListener, null, null);
    }

    public LinkLabel(String text, @Nullable Icon icon, @Nullable LinkListener aListener, @Nullable T aLinkData) {
        this(text, icon, aListener, aLinkData, null);
    }

    public LinkLabel(String text, @Nullable Icon icon, @Nullable LinkListener<T> aListener, @Nullable T aLinkData, @Nullable String aVisitedLinksKey) {
        super(text, icon, 2);
        this.setOpaque(false);
        this.setListener(aListener, aLinkData);
        this.myIconWidth = this.getIcon() == null ? 0 : this.getIcon().getIconWidth() + this.getIconTextGap();
        this.myInactiveIcon = this.getIcon();
        MyMouseHandler mouseHandler = new MyMouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
        this.myVisitedLinksKey = aVisitedLinksKey;
    }

    public void setHoveringIcon(Icon iconForHovering) {
        this.myHoveringIcon = iconForHovering;
    }

    public void setListener(LinkListener listener, @Nullable T linkData) {
        this.myLinkListener = listener;
        this.myLinkData = linkData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doClick() {
        if (this.myClickIsBeingProcessed) {
            return;
        }
        try {
            this.myClickIsBeingProcessed = true;
            if (this.myLinkListener != null) {
                this.myLinkListener.linkSelected(this, this.myLinkData);
            }
            ourVisitedLinks.add(this.myVisitedLinksKey);
            this.repaint();
        }
        finally {
            this.myClickIsBeingProcessed = false;
        }
    }

    public boolean isVisited() {
        return this.myVisitedLinksKey != null && ourVisitedLinks.contains(this.myVisitedLinksKey);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Border border = this.getBorder();
        int shiftX = 0;
        int shiftY = 0;
        if (border != null) {
            shiftX = border.getBorderInsets((Component)this).left;
            shiftY = border.getBorderInsets((Component)this).top;
        }
        this.setForeground(this.getTextColor());
        super.paintComponent(g);
        if (this.getText() != null) {
            g.setColor(this.getTextColor());
            int x = this.myIconWidth;
            int y = this.getTextBaseLine();
            if (this.myUnderline && this.myPaintUnderline) {
                int lineY;
                int k = 1;
                if (this.getFont().getSize() > 11) {
                    k += this.getFont().getSize() - 11;
                }
                if ((lineY = (y += k) + shiftY) >= this.getSize().height) {
                    lineY = this.getSize().height - 1;
                }
                if (this.getHorizontalAlignment() == 2) {
                    UIUtil.drawLine((Graphics)g, (int)(x + shiftX), (int)lineY, (int)(x + this.getFontMetrics(this.getFont()).stringWidth(this.getText()) + shiftX), (int)lineY);
                } else {
                    UIUtil.drawLine((Graphics)g, (int)(this.getWidth() - 1 - this.getFontMetrics(this.getFont()).stringWidth(this.getText()) + shiftX), (int)lineY, (int)(this.getWidth() - 1 + shiftX), (int)lineY);
                }
            }
            if (this.myPaintDefaultIcon) {
                int endX = this.myIconWidth + this.getFontMetrics(this.getFont()).stringWidth(this.getText());
                int endY = this.getHeight() / 2 - AllIcons.Ide.Link.getIconHeight() / 2 + 1;
                AllIcons.Ide.Link.paintIcon(this, g, endX + shiftX + 2, endY);
            }
        }
    }

    protected Color getTextColor() {
        return this.myIsLinkActive ? this.getActive() : (this.isVisited() ? this.getVisited() : this.getNormal());
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.width = size.width + (this.myPaintDefaultIcon ? AllIcons.Ide.Link.getIconWidth() + 2 : 0);
        return size;
    }

    public void setPaintUnderline(boolean paintUnderline) {
        this.myPaintUnderline = paintUnderline;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (ScreenUtil.isStandardAddRemoveNotify(this)) {
            this.disableUnderline();
        }
    }

    private void setActive(boolean isActive) {
        this.myIsLinkActive = isActive;
        this.onSetActive(this.myIsLinkActive);
        this.repaint();
    }

    protected void onSetActive(boolean active) {
    }

    private int getTextBaseLine() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        return this.getHeight() / 2 + (fm.getHeight() / 2 - fm.getDescent());
    }

    private boolean isInClickableArea(Point pt) {
        Insets insets = this.getInsets();
        pt.translate(-insets.left, -insets.top);
        if (this.getIcon() != null && pt.getX() < (double)this.getIcon().getIconWidth() && pt.getY() < (double)this.getIcon().getIconHeight()) {
            return true;
        }
        if (this.getText() != null) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int height = fm.getHeight() + 1;
            int y = this.getHeight() / 2 - fm.getHeight() / 2;
            int width = fm.stringWidth(this.getText());
            if (this.myPaintDefaultIcon) {
                width += AllIcons.Ide.Link.getIconWidth() + 2;
            }
            if (this.getHorizontalAlignment() == 2) {
                return new Rectangle(this.myIconWidth, y, width, height).contains(pt);
            }
            return new Rectangle(this.getWidth() - width - 1, y, this.getWidth() - 1, height).contains(pt);
        }
        return false;
    }

    private void enableUnderline() {
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.myUnderline = true;
        if (this.myHoveringIcon != null) {
            this.setIcon(this.myHoveringIcon);
        }
        LinkLabel.setStatusBarText(this.getStatusBarText());
        this.repaint();
    }

    protected String getStatusBarText() {
        return this.getToolTipText();
    }

    private void disableUnderline() {
        this.setCursor(Cursor.getDefaultCursor());
        this.myUnderline = false;
        this.setIcon(this.myInactiveIcon);
        LinkLabel.setStatusBarText(null);
        this.setActive(false);
    }

    private static void setStatusBarText(String statusBarText) {
        Project[] projects;
        if (ApplicationManager.getApplication() == null) {
            return;
        }
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            StatusBar.Info.set(statusBarText, project);
        }
    }

    public static void clearVisitedHistory() {
        ourVisitedLinks.clear();
    }

    protected Color getVisited() {
        return UI.getColor("link.visited.foreground");
    }

    protected Color getActive() {
        return UI.getColor("link.pressed.foreground");
    }

    protected Color getNormal() {
        return UI.getColor("link.foreground");
    }

    public void entered(MouseEvent e) {
        this.enableUnderline();
    }

    public void exited(MouseEvent e) {
        this.disableUnderline();
    }

    public void pressed(MouseEvent e) {
        this.doClick(e);
    }

    public void doClick(InputEvent e) {
        this.doClick();
    }

    public void setDefaultIconPainted(boolean paintDefaultIcon) {
        this.myPaintDefaultIcon = paintDefaultIcon;
    }

    private class MyMouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private MyMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (LinkLabel.this.isInClickableArea(e.getPoint())) {
                LinkLabel.this.setActive(true);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (LinkLabel.this.myIsLinkActive && LinkLabel.this.isInClickableArea(e.getPoint())) {
                LinkLabel.this.doClick(e);
            }
            LinkLabel.this.setActive(false);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (LinkLabel.this.isInClickableArea(e.getPoint())) {
                LinkLabel.this.enableUnderline();
            } else {
                LinkLabel.this.disableUnderline();
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            LinkLabel.this.disableUnderline();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }
    }
}

