/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.commandLine.InteractiveCommandListener;
import org.jetbrains.idea.svn.commandLine.SvnProcessHandler;

public class TerminalProcessHandler
extends SvnProcessHandler {
    private final List<InteractiveCommandListener> myInteractiveListeners;
    private final CapturingProcessAdapter terminalOutputCapturer;
    private final StringBuilder outputLine;
    private final StringBuilder errorLine;

    public TerminalProcessHandler(@NotNull Process process, boolean forceUtf8, boolean forceBinary) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "org/jetbrains/idea/svn/commandLine/TerminalProcessHandler", "<init>"));
        }
        super(process, forceUtf8, forceBinary);
        this.myInteractiveListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.terminalOutputCapturer = new CapturingProcessAdapter();
        this.outputLine = new StringBuilder();
        this.errorLine = new StringBuilder();
    }

    public void addInteractiveListener(@NotNull InteractiveCommandListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/idea/svn/commandLine/TerminalProcessHandler", "addInteractiveListener"));
        }
        this.myInteractiveListeners.add(listener);
    }

    protected boolean processHasSeparateErrorStream() {
        return false;
    }

    protected void destroyProcessImpl() {
        Process process = this.getProcess();
        process.destroy();
    }

    public void notifyTextAvailable(String text, Key outputType) {
        this.terminalOutputCapturer.onTextAvailable(new ProcessEvent((ProcessHandler)this, text), outputType);
        text = this.filterText(text);
        if (!StringUtil.isEmpty((String)text)) {
            StringBuilder lastLine = this.getLastLineFor(outputType);
            String currentLine = lastLine.append(text).toString();
            lastLine.setLength(0);
            currentLine = this.filterCombinedText(currentLine);
            boolean handled = this.handlePrompt(currentLine, outputType);
            if (!handled) {
                this.notify(currentLine, outputType, lastLine);
            }
        }
    }

    protected boolean handlePrompt(String text, Key outputType) {
        boolean shouldHandleWithListeners = !this.processHasSeparateErrorStream() || ProcessOutputTypes.STDERR.equals((Object)outputType);
        return shouldHandleWithListeners && this.handlePromptWithListeners(text, outputType);
    }

    private boolean handlePromptWithListeners(String text, Key outputType) {
        boolean result = false;
        for (InteractiveCommandListener listener : this.myInteractiveListeners) {
            result |= listener.handlePrompt(text, outputType);
        }
        return result;
    }

    @NotNull
    protected String filterCombinedText(@NotNull String currentLine) {
        if (currentLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentLine", "org/jetbrains/idea/svn/commandLine/TerminalProcessHandler", "filterCombinedText"));
        }
        String string = currentLine;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/TerminalProcessHandler", "filterCombinedText"));
        }
        return string;
    }

    @NotNull
    protected String filterText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/idea/svn/commandLine/TerminalProcessHandler", "filterText"));
        }
        String string = text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/TerminalProcessHandler", "filterText"));
        }
        return string;
    }

    private void notify(@NotNull String text, @NotNull Key outputType, @NotNull StringBuilder lastLine) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/idea/svn/commandLine/TerminalProcessHandler", "notify"));
        }
        if (outputType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputType", "org/jetbrains/idea/svn/commandLine/TerminalProcessHandler", "notify"));
        }
        if (lastLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastLine", "org/jetbrains/idea/svn/commandLine/TerminalProcessHandler", "notify"));
        }
        if (StringUtil.endsWith((CharSequence)text, (CharSequence)"\n")) {
            super.notifyTextAvailable(text, this.resolveOutputType(text, outputType));
        } else {
            lastLine.append(text);
        }
    }

    @NotNull
    protected Key resolveOutputType(@NotNull String line, @NotNull Key outputType) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/jetbrains/idea/svn/commandLine/TerminalProcessHandler", "resolveOutputType"));
        }
        if (outputType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputType", "org/jetbrains/idea/svn/commandLine/TerminalProcessHandler", "resolveOutputType"));
        }
        Key result = outputType;
        if (!ProcessOutputTypes.SYSTEM.equals((Object)outputType)) {
            Matcher errorMatcher = SvnUtil.ERROR_PATTERN.matcher(line);
            Matcher warningMatcher = SvnUtil.WARNING_PATTERN.matcher(line);
            result = errorMatcher.find() || warningMatcher.find() ? ProcessOutputTypes.STDERR : ProcessOutputTypes.STDOUT;
        }
        Key key = result;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/TerminalProcessHandler", "resolveOutputType"));
        }
        return key;
    }

    @NotNull
    private StringBuilder getLastLineFor(Key outputType) {
        if (ProcessOutputTypes.STDERR.equals((Object)outputType)) {
            StringBuilder stringBuilder = this.errorLine;
            if (stringBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/TerminalProcessHandler", "getLastLineFor"));
            }
            return stringBuilder;
        }
        if (ProcessOutputTypes.STDOUT.equals((Object)outputType)) {
            StringBuilder stringBuilder = this.outputLine;
            if (stringBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/TerminalProcessHandler", "getLastLineFor"));
            }
            return stringBuilder;
        }
        throw new IllegalArgumentException("Unknown process output type " + outputType);
    }

    public String getTerminalOutput() {
        return this.terminalOutputCapturer.getOutput().getStdout();
    }
}

