/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProcessEventListener;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.io.URLUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.IdeaWideProxySelector;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitVcs;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHttpAuthService;
import git4idea.commands.GitHttpAuthenticator;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerAdapter;
import git4idea.commands.GitRemoteProtocol;
import git4idea.commands.GitSSHGUIHandler;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersionSpecialty;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.git4idea.ssh.GitXmlRpcSshService;

public abstract class GitHandler {
    protected static final Logger LOG = Logger.getInstance(GitHandler.class);
    protected static final Logger OUTPUT_LOG = Logger.getInstance((String)("#output." + GitHandler.class.getName()));
    protected final Project myProject;
    protected final GitCommand myCommand;
    private final HashSet<Integer> myIgnoredErrorCodes;
    private final List<VcsException> myErrors;
    private final List<String> myLastOutput;
    private final int LAST_OUTPUT_SIZE = 5;
    final GeneralCommandLine myCommandLine;
    Process myProcess;
    private boolean myStdoutSuppressed;
    private boolean myStderrSuppressed;
    private final File myWorkingDirectory;
    private boolean myEnvironmentCleanedUp;
    private int myHandlerNo;
    private Processor<OutputStream> myInputProcessor;
    private boolean myIsCancellable;
    private Integer myExitCode;
    @NonNls
    @NotNull
    private Charset myCharset;
    private final EventDispatcher<ProcessEventListener> myListeners;
    protected boolean mySilent;
    protected final GitVcs myVcs;
    private final Map<String, String> myEnv;
    private GitVcsApplicationSettings myAppSettings;
    private GitVcsSettings myProjectSettings;
    private Runnable mySuspendAction;
    private Runnable myResumeAction;
    private long myStartTime;
    private static final long LONG_TIME = 10000L;
    @Nullable
    private String myUrl;
    private boolean myHttpAuthFailed;

    protected GitHandler(@NotNull Project project, @NotNull File directory, @NotNull GitCommand command) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/commands/GitHandler", "<init>"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "git4idea/commands/GitHandler", "<init>"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "git4idea/commands/GitHandler", "<init>"));
        }
        this.myIgnoredErrorCodes = new HashSet();
        this.myErrors = Collections.synchronizedList(new ArrayList());
        this.myLastOutput = Collections.synchronizedList(new ArrayList());
        this.LAST_OUTPUT_SIZE = 5;
        this.myEnvironmentCleanedUp = true;
        this.myIsCancellable = true;
        this.myCharset = CharsetToolkit.UTF8_CHARSET;
        this.myListeners = EventDispatcher.create(ProcessEventListener.class);
        this.myProject = project;
        this.myCommand = command;
        this.myAppSettings = GitVcsApplicationSettings.getInstance();
        this.myProjectSettings = GitVcsSettings.getInstance(this.myProject);
        this.myEnv = new HashMap<String, String>(System.getenv());
        this.myVcs = (GitVcs)((Object)ObjectUtils.assertNotNull((Object)((Object)GitVcs.getInstance(project))));
        this.myWorkingDirectory = directory;
        this.myCommandLine = new GeneralCommandLine();
        if (this.myAppSettings != null) {
            this.myCommandLine.setExePath(this.myAppSettings.getPathToGit());
        }
        this.myCommandLine.setWorkDirectory(this.myWorkingDirectory);
        if (GitVersionSpecialty.CAN_OVERRIDE_GIT_CONFIG_FOR_COMMAND.existsIn(this.myVcs.getVersion())) {
            this.myCommandLine.addParameters(new String[]{"-c", "core.quotepath=false"});
        }
        this.myCommandLine.addParameter(command.name());
        this.myStdoutSuppressed = true;
    }

    protected GitHandler(Project project, VirtualFile vcsRoot, GitCommand command) {
        this(project, VfsUtil.virtualToIoFile((VirtualFile)vcsRoot), command);
    }

    protected ProcessEventListener listeners() {
        return (ProcessEventListener)this.myListeners.getMulticaster();
    }

    public void ignoreErrorCode(int code) {
        this.myIgnoredErrorCodes.add(code);
    }

    public boolean isIgnoredErrorCode(int code) {
        return this.myIgnoredErrorCodes.contains(code);
    }

    public void addError(VcsException ex) {
        this.myErrors.add(ex);
    }

    public void addLastOutput(String line) {
        if (this.myLastOutput.size() < 5) {
            this.myLastOutput.add(line);
        } else {
            this.myLastOutput.add(0, line);
            Collections.rotate(this.myLastOutput, -1);
        }
    }

    public List<String> getLastOutput() {
        return this.myLastOutput;
    }

    public List<VcsException> errors() {
        return Collections.unmodifiableList(this.myErrors);
    }

    public Project project() {
        return this.myProject;
    }

    public File workingDirectory() {
        return this.myWorkingDirectory;
    }

    public VirtualFile workingDirectoryFile() {
        VirtualFile file = LocalFileSystem.getInstance().findFileByIoFile(this.workingDirectory());
        if (file == null) {
            throw new IllegalStateException("The working directly should be available: " + this.workingDirectory());
        }
        return file;
    }

    public void setUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "git4idea/commands/GitHandler", "setUrl"));
        }
        this.myUrl = url;
    }

    protected boolean isRemote() {
        return this.myUrl != null;
    }

    protected void addListener(ProcessEventListener listener) {
        this.myListeners.addListener((EventListener)listener);
    }

    public void endOptions() {
        this.myCommandLine.addParameter("--");
    }

    public void addParameters(String ... parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "git4idea/commands/GitHandler", "addParameters"));
        }
        this.addParameters(Arrays.asList(parameters));
    }

    public void addParameters(List<String> parameters) {
        this.checkNotStarted();
        for (String parameter : parameters) {
            this.myCommandLine.addParameter(this.escapeParameterIfNeeded(parameter));
        }
    }

    @NotNull
    private String escapeParameterIfNeeded(@NotNull String parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "git4idea/commands/GitHandler", "escapeParameterIfNeeded"));
        }
        if (this.escapeNeeded(parameter)) {
            String string = parameter.replaceAll("\\^", "^^^^");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitHandler", "escapeParameterIfNeeded"));
            }
            return string;
        }
        String string = parameter;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitHandler", "escapeParameterIfNeeded"));
        }
        return string;
    }

    private boolean escapeNeeded(@NotNull String parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "git4idea/commands/GitHandler", "escapeNeeded"));
        }
        return SystemInfo.isWindows && this.isCmd() && parameter.contains("^");
    }

    private boolean isCmd() {
        return this.myAppSettings.getPathToGit().toLowerCase().endsWith("cmd");
    }

    @NotNull
    private String unescapeCommandLine(@NotNull String commandLine) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "git4idea/commands/GitHandler", "unescapeCommandLine"));
        }
        if (this.escapeNeeded(commandLine)) {
            String string = commandLine.replaceAll("\\^\\^\\^\\^", "^");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitHandler", "unescapeCommandLine"));
            }
            return string;
        }
        String string = commandLine;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitHandler", "unescapeCommandLine"));
        }
        return string;
    }

    public void addRelativePaths(FilePath ... parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "git4idea/commands/GitHandler", "addRelativePaths"));
        }
        this.addRelativePaths(Arrays.asList(parameters));
    }

    public void addRelativePaths(@NotNull Collection<FilePath> filePaths) {
        if (filePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePaths", "git4idea/commands/GitHandler", "addRelativePaths"));
        }
        this.checkNotStarted();
        for (FilePath path : filePaths) {
            this.myCommandLine.addParameter(VcsFileUtil.relativePath((File)this.myWorkingDirectory, (FilePath)path));
        }
    }

    public void addRelativePathsForFiles(@NotNull Collection<File> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "git4idea/commands/GitHandler", "addRelativePathsForFiles"));
        }
        this.checkNotStarted();
        for (File file : files) {
            this.myCommandLine.addParameter(VcsFileUtil.relativePath((File)this.myWorkingDirectory, (File)file));
        }
    }

    public void addRelativeFiles(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "git4idea/commands/GitHandler", "addRelativeFiles"));
        }
        this.checkNotStarted();
        for (VirtualFile file : files) {
            this.myCommandLine.addParameter(VcsFileUtil.relativePath((File)this.myWorkingDirectory, (VirtualFile)file));
        }
    }

    public boolean addProgressParameter() {
        if (GitVersionSpecialty.ABLE_TO_USE_PROGRESS_IN_REMOTE_COMMANDS.existsIn(this.myVcs.getVersion())) {
            this.addParameters("--progress");
            return true;
        }
        return false;
    }

    private void checkNotStarted() {
        if (this.isStarted()) {
            throw new IllegalStateException("The process has been already started");
        }
    }

    protected final void checkStarted() {
        if (!this.isStarted()) {
            throw new IllegalStateException("The process is not started yet");
        }
    }

    public final synchronized boolean isStarted() {
        return this.myProcess != null;
    }

    public void setCancellable(boolean value) {
        this.checkNotStarted();
        this.myIsCancellable = value;
    }

    public boolean isCancellable() {
        return this.myIsCancellable;
    }

    public synchronized void start() {
        this.checkNotStarted();
        try {
            this.myStartTime = System.currentTimeMillis();
            if (!this.myProject.isDefault() && !this.mySilent && this.myVcs != null) {
                this.myVcs.showCommandLine("cd " + this.myWorkingDirectory);
                this.myVcs.showCommandLine(this.printableCommandLine());
                LOG.info("cd " + this.myWorkingDirectory);
                LOG.info(this.printableCommandLine());
            } else {
                LOG.debug("cd " + this.myWorkingDirectory);
                LOG.debug("[" + this.myWorkingDirectory.getName() + "] " + this.printableCommandLine());
            }
            GitRemoteProtocol remoteProtocol = GitRemoteProtocol.fromUrl(this.myUrl);
            if (remoteProtocol == GitRemoteProtocol.SSH && this.myProjectSettings.isIdeaSsh()) {
                GitXmlRpcSshService ssh = (GitXmlRpcSshService)ServiceManager.getService(GitXmlRpcSshService.class);
                this.myEnv.put("GIT_SSH", ssh.getScriptPath().getPath());
                this.myHandlerNo = ssh.registerHandler(new GitSSHGUIHandler(this.myProject));
                this.myEnvironmentCleanedUp = false;
                this.myEnv.put("GIT4IDEA_SSH_HANDLER", Integer.toString(this.myHandlerNo));
                int port = ssh.getXmlRcpPort();
                this.myEnv.put("GIT4IDEA_SSH_PORT", Integer.toString(port));
                LOG.debug(String.format("handler=%s, port=%s", this.myHandlerNo, port));
                HttpConfigurable httpConfigurable = HttpConfigurable.getInstance();
                boolean useHttpProxy = httpConfigurable.USE_HTTP_PROXY && !GitHandler.isSshUrlExcluded(httpConfigurable, this.myUrl);
                this.myEnv.put("GIT4IDEA_SSH_USE_PROXY", String.valueOf(useHttpProxy));
                if (useHttpProxy) {
                    this.myEnv.put("GIT4IDEA_SSH_PROXY_HOST", StringUtil.notNullize((String)httpConfigurable.PROXY_HOST));
                    this.myEnv.put("GIT4IDEA_SSH_PROXY_PORT", String.valueOf(httpConfigurable.PROXY_PORT));
                    boolean proxyAuthentication = httpConfigurable.PROXY_AUTHENTICATION;
                    this.myEnv.put("GIT4IDEA_SSH_PROXY_AUTHENTICATION", String.valueOf(proxyAuthentication));
                    if (proxyAuthentication) {
                        this.myEnv.put("GIT4IDEA_SSH_PROXY_USER", StringUtil.notNullize((String)httpConfigurable.PROXY_LOGIN));
                        this.myEnv.put("GIT4IDEA_SSH_PROXY_PASSWORD", StringUtil.notNullize((String)httpConfigurable.getPlainProxyPassword()));
                    }
                }
            } else if (remoteProtocol == GitRemoteProtocol.HTTP) {
                GitHttpAuthService service = (GitHttpAuthService)ServiceManager.getService(GitHttpAuthService.class);
                this.myEnv.put("GIT_ASKPASS", service.getScriptPath().getPath());
                assert (this.myUrl != null) : "myUrl can't be null here";
                GitHttpAuthenticator httpAuthenticator = service.createAuthenticator(this.myProject, this.myCommand, this.myUrl);
                this.myHandlerNo = service.registerHandler(httpAuthenticator);
                this.myEnvironmentCleanedUp = false;
                this.myEnv.put("GIT_ASKPASS_HANDLER", Integer.toString(this.myHandlerNo));
                int port = service.getXmlRcpPort();
                this.myEnv.put("GIT_ASKPASS_PORT", Integer.toString(port));
                LOG.debug(String.format("handler=%s, port=%s", this.myHandlerNo, port));
                this.addAuthListener(httpAuthenticator);
            }
            this.myCommandLine.getEnvironment().clear();
            this.myCommandLine.getEnvironment().putAll(this.myEnv);
            this.myProcess = this.startProcess();
            this.startHandlingStreams();
        }
        catch (Throwable t) {
            if (!ApplicationManager.getApplication().isUnitTestMode() || !this.myProject.isDisposed()) {
                LOG.error(t);
            }
            this.cleanupEnv();
            ((ProcessEventListener)this.myListeners.getMulticaster()).startFailed(t);
        }
    }

    protected static boolean isSshUrlExcluded(@NotNull HttpConfigurable httpConfigurable, @NotNull String url) {
        if (httpConfigurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "httpConfigurable", "git4idea/commands/GitHandler", "isSshUrlExcluded"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "git4idea/commands/GitHandler", "isSshUrlExcluded"));
        }
        String host = URLUtil.parseHostFromSshUrl((String)url);
        return ((IdeaWideProxySelector)httpConfigurable.getOnlyBySettingsSelector()).isProxyException(host);
    }

    private void addAuthListener(final @NotNull GitHttpAuthenticator authenticator) {
        if (authenticator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authenticator", "git4idea/commands/GitHandler", "addAuthListener"));
        }
        if (this instanceof GitLineHandler) {
            ((GitLineHandler)this).addLineListener(new GitLineHandlerAdapter(){

                @Override
                public void onLineAvailable(String line, Key outputType) {
                    if (line.toLowerCase().contains("authentication failed")) {
                        GitHandler.this.myHttpAuthFailed = true;
                    }
                }

                @Override
                public void processTerminated(int exitCode) {
                    if (!authenticator.wasCancelled()) {
                        if (GitHandler.this.myHttpAuthFailed) {
                            authenticator.forgetPassword();
                        } else {
                            authenticator.saveAuthData();
                        }
                    } else {
                        GitHandler.this.myHttpAuthFailed = false;
                    }
                }
            });
        }
    }

    public boolean hasHttpAuthFailed() {
        return this.myHttpAuthFailed;
    }

    protected abstract Process startProcess() throws ExecutionException;

    protected abstract void startHandlingStreams();

    public String printableCommandLine() {
        return this.unescapeCommandLine(this.myCommandLine.getCommandLineString("git"));
    }

    public synchronized void cancel() {
        this.checkStarted();
        if (!this.myIsCancellable) {
            throw new IllegalStateException("The process is not cancellable.");
        }
        this.destroyProcess();
    }

    public abstract void destroyProcess();

    public synchronized int getExitCode() {
        if (this.myExitCode == null) {
            throw new IllegalStateException("Exit code is not yet available");
        }
        return this.myExitCode;
    }

    protected synchronized void setExitCode(int exitCode) {
        this.myExitCode = exitCode;
    }

    protected synchronized void cleanupEnv() {
        if (this.myEnvironmentCleanedUp) {
            return;
        }
        GitRemoteProtocol remoteProtocol = GitRemoteProtocol.fromUrl(this.myUrl);
        if (remoteProtocol == GitRemoteProtocol.SSH) {
            GitXmlRpcSshService ssh = (GitXmlRpcSshService)ServiceManager.getService(GitXmlRpcSshService.class);
            this.myEnvironmentCleanedUp = true;
            ssh.unregisterHandler(this.myHandlerNo);
        } else if (remoteProtocol == GitRemoteProtocol.HTTP) {
            GitHttpAuthService service = (GitHttpAuthService)ServiceManager.getService(GitHttpAuthService.class);
            this.myEnvironmentCleanedUp = true;
            service.unregisterHandler(this.myHandlerNo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor() {
        this.checkStarted();
        try {
            if (this.myInputProcessor != null && this.myProcess != null) {
                this.myInputProcessor.process((Object)this.myProcess.getOutputStream());
            }
        }
        finally {
            this.waitForProcess();
        }
    }

    protected abstract void waitForProcess();

    public void setSilent(boolean silent) {
        this.checkNotStarted();
        this.mySilent = silent;
        if (silent) {
            this.setStderrSuppressed(true);
            this.setStdoutSuppressed(true);
        }
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = this.myCharset;
        if (charset == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitHandler", "getCharset"));
        }
        return charset;
    }

    public void setCharset(@NotNull Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "git4idea/commands/GitHandler", "setCharset"));
        }
        this.myCharset = charset;
    }

    public boolean isStdoutSuppressed() {
        return this.myStdoutSuppressed;
    }

    public void setStdoutSuppressed(boolean stdoutSuppressed) {
        this.checkNotStarted();
        this.myStdoutSuppressed = stdoutSuppressed;
    }

    public boolean isStderrSuppressed() {
        return this.myStderrSuppressed;
    }

    public void setStderrSuppressed(boolean stderrSuppressed) {
        this.checkNotStarted();
        this.myStderrSuppressed = stderrSuppressed;
    }

    public void setEnvironment(String name, String value) {
        this.myEnv.put(name, value);
    }

    public void setInputProcessor(Processor<OutputStream> inputProcessor) {
        this.myInputProcessor = inputProcessor;
    }

    synchronized void setSuspendResume(Runnable suspend, Runnable resume) {
        this.mySuspendAction = suspend;
        this.myResumeAction = resume;
    }

    public synchronized void suspendWriteLock() {
        assert (this.mySuspendAction != null);
        this.mySuspendAction.run();
    }

    public synchronized void resumeWriteLock() {
        assert (this.mySuspendAction != null);
        this.myResumeAction.run();
    }

    public boolean isLargeCommandLine() {
        return this.myCommandLine.getCommandLineString().length() > 7600;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runInCurrentThread(@Nullable Runnable postStartAction) {
        block29: {
            GitVcs vcs = GitVcs.getInstance(this.myProject);
            if (vcs == null) {
                return;
            }
            boolean suspendable = false;
            switch (this.myCommand.lockingPolicy()) {
                case READ: {
                    break;
                }
                case WRITE_SUSPENDABLE: {
                    suspendable = true;
                }
                case WRITE: {
                    vcs.getCommandLock().writeLock().lock();
                }
            }
            try {
                if (suspendable) {
                    final Object EXIT = new Object();
                    final Object SUSPEND = new Object();
                    final Object RESUME = new Object();
                    final LinkedBlockingQueue queue = new LinkedBlockingQueue();
                    Runnable suspend = new Runnable(){

                        @Override
                        public void run() {
                            queue.add(SUSPEND);
                        }
                    };
                    Runnable resume = new Runnable(){

                        @Override
                        public void run() {
                            queue.add(RESUME);
                        }
                    };
                    this.setSuspendResume(suspend, resume);
                    this.start();
                    if (!this.isStarted()) break block29;
                    if (postStartAction != null) {
                        postStartAction.run();
                    }
                    ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                        @Override
                        public void run() {
                            GitHandler.this.waitFor();
                            queue.add(EXIT);
                        }
                    });
                    boolean suspended = false;
                    while (true) {
                        Object action;
                        try {
                            action = queue.take();
                        }
                        catch (InterruptedException e) {
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug("queue.take() is interrupted", (Throwable)e);
                            continue;
                        }
                        if (action == EXIT) {
                            if (suspended) {
                                LOG.error("Exiting while RW lock is suspended (reacquiring W-lock command)");
                                vcs.getCommandLock().writeLock().lock();
                            }
                            break block29;
                        }
                        if (action == SUSPEND) {
                            if (suspended) {
                                LOG.error("Suspending suspended W-lock (ignoring command)");
                                continue;
                            }
                            vcs.getCommandLock().writeLock().unlock();
                            suspended = true;
                            continue;
                        }
                        if (action != RESUME) continue;
                        if (!suspended) {
                            LOG.error("Resuming not suspended W-lock (ignoring command)");
                            continue;
                        }
                        vcs.getCommandLock().writeLock().lock();
                        suspended = false;
                    }
                }
                this.start();
                if (this.isStarted()) {
                    if (postStartAction != null) {
                        postStartAction.run();
                    }
                    this.waitFor();
                }
            }
            finally {
                switch (this.myCommand.lockingPolicy()) {
                    case READ: {
                        break;
                    }
                    case WRITE_SUSPENDABLE: 
                    case WRITE: {
                        vcs.getCommandLock().writeLock().unlock();
                    }
                }
                this.logTime();
            }
        }
    }

    private void logTime() {
        if (this.myStartTime > 0L) {
            long time = System.currentTimeMillis() - this.myStartTime;
            if (!LOG.isDebugEnabled() && time > 10000L) {
                LOG.info(String.format("git %s took %s ms. Command parameters: %n%s", this.myCommand, time, this.myCommandLine.getCommandLineString()));
            } else {
                LOG.debug(String.format("git %s took %s ms", this.myCommand, time));
            }
        } else {
            LOG.debug(String.format("git %s finished.", this.myCommand));
        }
    }

    public String toString() {
        return this.myCommandLine.toString();
    }
}

