/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.RepoStateException;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitSvnRemoteBranch;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBranchesCollection;
import git4idea.repo.GitRemote;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitRepositoryReader {
    private static final Logger LOG = Logger.getInstance(GitRepositoryReader.class);
    private static Pattern BRANCH_PATTERN = Pattern.compile("ref: refs/heads/(\\S+)");
    private static Pattern BRANCH_WEAK_PATTERN = Pattern.compile(" *(ref:)? */?refs/heads/(\\S+)");
    private static Pattern COMMIT_PATTERN = Pattern.compile("[0-9a-fA-F]+");
    private static final Processor<File> NOT_HIDDEN_DIRECTORIES = new Processor<File>(){

        public boolean process(File dir) {
            return !GitRepositoryReader.isHidden(dir);
        }
    };
    @NonNls
    private static final String REFS_HEADS_PREFIX = "refs/heads/";
    @NonNls
    private static final String REFS_REMOTES_PREFIX = "refs/remotes/";
    @NotNull
    private final File myGitDir;
    @NotNull
    private final File myHeadFile;
    @NotNull
    private final File myRefsHeadsDir;
    @NotNull
    private final File myRefsRemotesDir;
    @NotNull
    private final File myPackedRefsFile;

    GitRepositoryReader(@NotNull File gitDir) {
        if (gitDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gitDir", "git4idea/repo/GitRepositoryReader", "<init>"));
        }
        this.myGitDir = gitDir;
        DvcsUtil.assertFileExists((File)this.myGitDir, (String)(".git directory not found in " + gitDir));
        this.myHeadFile = new File(this.myGitDir, "HEAD");
        DvcsUtil.assertFileExists((File)this.myHeadFile, (String)(".git/HEAD file not found in " + gitDir));
        this.myRefsHeadsDir = new File(new File(this.myGitDir, "refs"), "heads");
        this.myRefsRemotesDir = new File(new File(this.myGitDir, "refs"), "remotes");
        this.myPackedRefsFile = new File(this.myGitDir, "packed-refs");
    }

    @Nullable
    private static Hash createHash(@Nullable String hash) {
        try {
            return hash == null ? null : HashImpl.build((String)hash);
        }
        catch (Throwable t) {
            LOG.info(t);
            return null;
        }
    }

    @NotNull
    public Repository.State readState() {
        if (this.isMergeInProgress()) {
            Repository.State state = Repository.State.MERGING;
            if (state == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readState"));
            }
            return state;
        }
        if (this.isRebaseInProgress()) {
            Repository.State state = Repository.State.REBASING;
            if (state == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readState"));
            }
            return state;
        }
        Head head = this.readHead();
        if (!head.isBranch) {
            Repository.State state = Repository.State.DETACHED;
            if (state == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readState"));
            }
            return state;
        }
        Repository.State state = Repository.State.NORMAL;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readState"));
        }
        return state;
    }

    @Nullable
    String readCurrentRevision() {
        Head head = this.readHead();
        if (!head.isBranch) {
            return head.ref;
        }
        File branchFile = null;
        for (Map.Entry<String, File> entry : this.readLocalBranches().entrySet()) {
            if (!entry.getKey().equals(head.ref)) continue;
            branchFile = entry.getValue();
        }
        if (branchFile != null) {
            return GitRepositoryReader.readBranchFile(branchFile);
        }
        return this.findBranchRevisionInPackedRefs(head.ref);
    }

    @Nullable
    GitLocalBranch readCurrentBranch() {
        Head head = this.readHead();
        if (head.isBranch) {
            String branchName = head.ref;
            String hash = this.readCurrentRevision();
            Hash h = GitRepositoryReader.createHash(hash);
            if (branchName == null || h == null) {
                return null;
            }
            return new GitLocalBranch(branchName, h);
        }
        if (this.isRebaseInProgress()) {
            GitLocalBranch branch = this.readRebaseBranch("rebase-apply");
            if (branch == null) {
                branch = this.readRebaseBranch("rebase-merge");
            }
            return branch;
        }
        return null;
    }

    @Nullable
    private GitLocalBranch readRebaseBranch(@NonNls String rebaseDirName) {
        String branchName;
        File rebaseDir = new File(this.myGitDir, rebaseDirName);
        if (!rebaseDir.exists()) {
            return null;
        }
        File headName = new File(rebaseDir, "head-name");
        if (!headName.exists()) {
            return null;
        }
        try {
            branchName = DvcsUtil.tryLoadFile((File)headName);
        }
        catch (RepoStateException e) {
            LOG.error((Throwable)e);
            return null;
        }
        File branchFile = this.findBranchFile(branchName);
        if (!branchFile.exists()) {
            return null;
        }
        Hash hash = GitRepositoryReader.createHash(GitRepositoryReader.readBranchFile(branchFile));
        if (hash == null) {
            return null;
        }
        if (branchName.startsWith(REFS_HEADS_PREFIX)) {
            branchName = branchName.substring(REFS_HEADS_PREFIX.length());
        }
        return new GitLocalBranch(branchName, hash);
    }

    @NotNull
    private File findBranchFile(@NotNull String branchName) {
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "git4idea/repo/GitRepositoryReader", "findBranchFile"));
        }
        File file = new File(this.myGitDir.getPath() + File.separator + branchName);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "findBranchFile"));
        }
        return file;
    }

    private boolean isMergeInProgress() {
        File mergeHead = new File(this.myGitDir, "MERGE_HEAD");
        return mergeHead.exists();
    }

    private boolean isRebaseInProgress() {
        File f = new File(this.myGitDir, "rebase-apply");
        if (f.exists()) {
            return true;
        }
        f = new File(this.myGitDir, "rebase-merge");
        return f.exists();
    }

    @Nullable
    private String findBranchRevisionInPackedRefs(final String ref) {
        if (!this.myPackedRefsFile.exists()) {
            return null;
        }
        try {
            List<HashAndName> hashAndNames = this.readPackedRefsFile(new Condition<HashAndName>(){

                public boolean value(HashAndName hashAndName) {
                    return hashAndName.name.endsWith(ref);
                }
            });
            HashAndName item = (HashAndName)ContainerUtil.getFirstItem(hashAndNames);
            return item == null ? null : item.hash;
        }
        catch (RepoStateException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private List<HashAndName> readPackedRefsFile(final @Nullable Condition<HashAndName> firstMatchCondition) throws RepoStateException {
        return (List)DvcsUtil.tryOrThrow((Callable)new Callable<List<HashAndName>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<HashAndName> call() throws Exception {
                ArrayList hashAndNames = ContainerUtil.newArrayList();
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new FileReader(GitRepositoryReader.this.myPackedRefsFile));
                    String line = reader.readLine();
                    while (line != null) {
                        HashAndName hashAndName = GitRepositoryReader.parsePackedRefsLine(line);
                        if (hashAndName != null) {
                            if (firstMatchCondition != null) {
                                if (firstMatchCondition.value((Object)hashAndName)) {
                                    List<HashAndName> list = Collections.singletonList(hashAndName);
                                    return list;
                                }
                            } else {
                                hashAndNames.add(hashAndName);
                            }
                        }
                        line = reader.readLine();
                    }
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
                return hashAndNames;
            }
        }, (File)this.myPackedRefsFile);
    }

    private Map<String, File> readLocalBranches() {
        final HashMap<String, File> branches = new HashMap<String, File>();
        if (!this.myRefsHeadsDir.exists()) {
            return branches;
        }
        FileUtil.processFilesRecursively((File)this.myRefsHeadsDir, (Processor)new Processor<File>(){

            public boolean process(File file) {
                String relativePath;
                if (!file.isDirectory() && !GitRepositoryReader.isHidden(file) && (relativePath = FileUtil.getRelativePath((File)GitRepositoryReader.this.myRefsHeadsDir, (File)file)) != null) {
                    branches.put(FileUtil.toSystemIndependentName((String)relativePath), file);
                }
                return true;
            }
        }, NOT_HIDDEN_DIRECTORIES);
        return branches;
    }

    private static boolean isHidden(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "git4idea/repo/GitRepositoryReader", "isHidden"));
        }
        return file.getName().startsWith(".");
    }

    GitBranchesCollection readBranches(@NotNull Collection<GitRemote> remotes) {
        if (remotes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remotes", "git4idea/repo/GitRepositoryReader", "readBranches"));
        }
        Set<GitLocalBranch> localBranches = this.readUnpackedLocalBranches();
        Set<GitRemoteBranch> remoteBranches = this.readUnpackedRemoteBranches(remotes);
        try {
            GitBranchesCollection packedBranches = this.readPackedBranches(remotes);
            localBranches.addAll(packedBranches.getLocalBranches());
            remoteBranches.addAll(packedBranches.getRemoteBranches());
        }
        catch (RepoStateException e) {
            LOG.error((Throwable)e);
        }
        return new GitBranchesCollection(localBranches, remoteBranches);
    }

    @NotNull
    private Set<GitLocalBranch> readUnpackedLocalBranches() {
        HashSet<GitLocalBranch> branches = new HashSet<GitLocalBranch>();
        for (Map.Entry<String, File> entry : this.readLocalBranches().entrySet()) {
            String branchName = entry.getKey();
            File branchFile = entry.getValue();
            String hash = GitRepositoryReader.loadHashFromBranchFile(branchFile);
            Hash h = GitRepositoryReader.createHash(hash);
            if (h == null) continue;
            branches.add(new GitLocalBranch(branchName, h));
        }
        HashSet<GitLocalBranch> hashSet = branches;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readUnpackedLocalBranches"));
        }
        return hashSet;
    }

    @Nullable
    private static String loadHashFromBranchFile(@NotNull File branchFile) {
        if (branchFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchFile", "git4idea/repo/GitRepositoryReader", "loadHashFromBranchFile"));
        }
        return DvcsUtil.tryLoadFileOrReturn((File)branchFile, null);
    }

    @NotNull
    private Set<GitRemoteBranch> readUnpackedRemoteBranches(final @NotNull Collection<GitRemote> remotes) {
        if (remotes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remotes", "git4idea/repo/GitRepositoryReader", "readUnpackedRemoteBranches"));
        }
        final HashSet<GitRemoteBranch> branches = new HashSet<GitRemoteBranch>();
        if (!this.myRefsRemotesDir.exists()) {
            HashSet<GitRemoteBranch> hashSet = branches;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readUnpackedRemoteBranches"));
            }
            return hashSet;
        }
        FileUtil.processFilesRecursively((File)this.myRefsRemotesDir, (Processor)new Processor<File>(){

            public boolean process(File file) {
                String relativePath;
                if (!(file.isDirectory() || file.getName().equalsIgnoreCase("HEAD") || GitRepositoryReader.isHidden(file) || (relativePath = FileUtil.getRelativePath((File)GitRepositoryReader.this.myGitDir, (File)file)) == null)) {
                    GitRemoteBranch remoteBranch;
                    String branchName = FileUtil.toSystemIndependentName((String)relativePath);
                    String hash = GitRepositoryReader.loadHashFromBranchFile(file);
                    Hash h = GitRepositoryReader.createHash(hash);
                    if (h != null && (remoteBranch = GitRepositoryReader.parseRemoteBranch(branchName, h, remotes)) != null) {
                        branches.add(remoteBranch);
                    }
                }
                return true;
            }
        }, NOT_HIDDEN_DIRECTORIES);
        HashSet<GitRemoteBranch> hashSet = branches;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readUnpackedRemoteBranches"));
        }
        return hashSet;
    }

    @NotNull
    private GitBranchesCollection readPackedBranches(@NotNull Collection<GitRemote> remotes) throws RepoStateException {
        if (remotes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remotes", "git4idea/repo/GitRepositoryReader", "readPackedBranches"));
        }
        HashSet<GitLocalBranch> localBranches = new HashSet<GitLocalBranch>();
        HashSet<GitRemoteBranch> remoteBranches = new HashSet<GitRemoteBranch>();
        if (!this.myPackedRefsFile.exists()) {
            GitBranchesCollection gitBranchesCollection = GitBranchesCollection.EMPTY;
            if (gitBranchesCollection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readPackedBranches"));
            }
            return gitBranchesCollection;
        }
        List<HashAndName> hashAndNames = this.readPackedRefsFile(null);
        for (HashAndName hashAndName : hashAndNames) {
            GitRemoteBranch remoteBranch;
            Hash hash = GitRepositoryReader.createHash(hashAndName.hash);
            if (hash == null) continue;
            String branchName = hashAndName.name;
            if (branchName.startsWith(REFS_HEADS_PREFIX)) {
                localBranches.add(new GitLocalBranch(branchName, hash));
                continue;
            }
            if (!branchName.startsWith(REFS_REMOTES_PREFIX) || (remoteBranch = GitRepositoryReader.parseRemoteBranch(branchName, hash, remotes)) == null) continue;
            remoteBranches.add(remoteBranch);
        }
        GitBranchesCollection gitBranchesCollection = new GitBranchesCollection(localBranches, remoteBranches);
        if (gitBranchesCollection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readPackedBranches"));
        }
        return gitBranchesCollection;
    }

    @Nullable
    private static GitRemoteBranch parseRemoteBranch(@NotNull String fullBranchName, @NotNull Hash hash, @NotNull Collection<GitRemote> remotes) {
        if (fullBranchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullBranchName", "git4idea/repo/GitRepositoryReader", "parseRemoteBranch"));
        }
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "git4idea/repo/GitRepositoryReader", "parseRemoteBranch"));
        }
        if (remotes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remotes", "git4idea/repo/GitRepositoryReader", "parseRemoteBranch"));
        }
        String stdName = GitBranchUtil.stripRefsPrefix(fullBranchName);
        int slash = stdName.indexOf(47);
        if (slash == -1) {
            return new GitSvnRemoteBranch(fullBranchName, hash);
        }
        String remoteName = stdName.substring(0, slash);
        String branchName = stdName.substring(slash + 1);
        GitRemote remote = GitUtil.findRemoteByName(remotes, remoteName);
        if (remote == null) {
            LOG.debug(String.format("No remote found with the name [%s]. All remotes: %s", remoteName, remotes));
            GitRemote fakeRemote = new GitRemote(remoteName, ContainerUtil.emptyList(), Collections.<String>emptyList(), Collections.<String>emptyList(), Collections.<String>emptyList());
            return new GitStandardRemoteBranch(fakeRemote, branchName, hash);
        }
        return new GitStandardRemoteBranch(remote, branchName, hash);
    }

    @Nullable
    private static String readBranchFile(@NotNull File branchFile) {
        if (branchFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchFile", "git4idea/repo/GitRepositoryReader", "readBranchFile"));
        }
        return DvcsUtil.tryLoadFileOrReturn((File)branchFile, null);
    }

    @NotNull
    private Head readHead() {
        String headContent;
        try {
            headContent = DvcsUtil.tryLoadFile((File)this.myHeadFile);
        }
        catch (RepoStateException e) {
            LOG.error((Throwable)e);
            Head head = new Head(false, null);
            if (head == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readHead"));
            }
            return head;
        }
        Matcher matcher = BRANCH_PATTERN.matcher(headContent);
        if (matcher.matches()) {
            Head head = new Head(true, matcher.group(1));
            if (head == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readHead"));
            }
            return head;
        }
        if (COMMIT_PATTERN.matcher(headContent).matches()) {
            Head head = new Head(false, headContent);
            if (head == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readHead"));
            }
            return head;
        }
        matcher = BRANCH_WEAK_PATTERN.matcher(headContent);
        if (matcher.matches()) {
            LOG.info(".git/HEAD has not standard format: [" + headContent + "]. We've parsed branch [" + matcher.group(1) + "]");
            Head head = new Head(true, matcher.group(1));
            if (head == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readHead"));
            }
            return head;
        }
        LOG.error((Throwable)new RepoStateException("Invalid format of the .git/HEAD file: [" + headContent + "]"));
        Head head = new Head(false, null);
        if (head == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readHead"));
        }
        return head;
    }

    @Nullable
    private static HashAndName parsePackedRefsLine(@NotNull String line) {
        int i;
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "git4idea/repo/GitRepositoryReader", "parsePackedRefsLine"));
        }
        if ((line = line.trim()).isEmpty()) {
            return null;
        }
        char firstChar = line.charAt(0);
        if (firstChar == '#') {
            return null;
        }
        if (firstChar == '^') {
            return null;
        }
        String hash = null;
        for (i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (Character.isLetterOrDigit(c)) continue;
            hash = line.substring(0, i);
            break;
        }
        if (hash == null) {
            LOG.warn("Ignoring invalid packed-refs line: [" + line + "]");
            return null;
        }
        String branch = null;
        int start = i;
        if (start < line.length() && line.charAt(start++) == ' ') {
            char c;
            for (i = start; i < line.length() && !Character.isWhitespace(c = line.charAt(i)); ++i) {
            }
            branch = line.substring(start, i);
        }
        if (branch == null) {
            LOG.warn("Ignoring invalid packed-refs line: [" + line + "]");
            return null;
        }
        return new HashAndName(GitRepositoryReader.shortBuffer(hash.trim()), GitRepositoryReader.shortBuffer(branch));
    }

    @NotNull
    private static String shortBuffer(String raw) {
        String string = new String(raw);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "shortBuffer"));
        }
        return string;
    }

    private static class Head {
        @Nullable
        private final String ref;
        private final boolean isBranch;

        Head(boolean branch, @Nullable String ref) {
            this.isBranch = branch;
            this.ref = ref;
        }
    }

    private static class HashAndName {
        private final String hash;
        private final String name;

        public HashAndName(String hash, String name) {
            this.hash = hash;
            this.name = name;
        }
    }
}

