/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.socksx.v4;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.handler.codec.socksx.v4.Socks4CmdResponse;
import io.netty.handler.codec.socksx.v4.Socks4CmdStatus;
import io.netty.handler.codec.socksx.v4.Socks4CommonUtils;
import io.netty.handler.codec.socksx.v4.Socks4Response;
import io.netty.handler.codec.socksx.v4.UnknownSocks4Response;
import java.util.List;

public class Socks4CmdResponseDecoder
extends ReplayingDecoder<State> {
    private Socks4CmdStatus cmdStatus;
    private String host;
    private int port;
    private Socks4Response msg = UnknownSocks4Response.INSTANCE;

    public Socks4CmdResponseDecoder() {
        super(State.CHECK_NULL_BYTE);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf byteBuf, List<Object> out) throws Exception {
        switch ((State)((Object)this.state())) {
            case CHECK_NULL_BYTE: {
                if (byteBuf.readByte() != 0) break;
                this.checkpoint(State.READ_CMD_HEADER);
            }
            case READ_CMD_HEADER: {
                this.cmdStatus = Socks4CmdStatus.valueOf(byteBuf.readByte());
                this.checkpoint(State.READ_CMD_ADDRESS);
            }
            case READ_CMD_ADDRESS: {
                this.port = byteBuf.readUnsignedShort();
                this.host = Socks4CommonUtils.intToIp(byteBuf.readInt());
                this.msg = new Socks4CmdResponse(this.cmdStatus, this.host, this.port);
            }
        }
        ctx.pipeline().remove(this);
        out.add(this.msg);
    }

    static enum State {
        CHECK_NULL_BYTE,
        READ_CMD_HEADER,
        READ_CMD_ADDRESS;

    }
}

