/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console;

import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.console.GroovyShellCodeFragment;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.GrTopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class GroovyShellConsoleImpl
extends LanguageConsoleImpl {
    public GroovyShellConsoleImpl(Project project, String name) {
        super(project, name, (Language)GroovyLanguage.INSTANCE);
    }

    @NotNull
    protected PsiFile createFile(@NotNull LightVirtualFile virtualFile, @NotNull Document document, @NotNull Project project) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "org/jetbrains/plugins/groovy/console/GroovyShellConsoleImpl", "createFile"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/plugins/groovy/console/GroovyShellConsoleImpl", "createFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/console/GroovyShellConsoleImpl", "createFile"));
        }
        GroovyShellCodeFragment groovyShellCodeFragment = new GroovyShellCodeFragment(project, virtualFile);
        if (groovyShellCodeFragment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/console/GroovyShellConsoleImpl", "createFile"));
        }
        return groovyShellCodeFragment;
    }

    @NotNull
    protected String addToHistoryInner(@NotNull TextRange textRange, @NotNull EditorEx editor, boolean erase, boolean preserveMarkup) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "org/jetbrains/plugins/groovy/console/GroovyShellConsoleImpl", "addToHistoryInner"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/groovy/console/GroovyShellConsoleImpl", "addToHistoryInner"));
        }
        String result = super.addToHistoryInner(textRange, editor, erase, preserveMarkup);
        if ("purge variables".equals(result.trim())) {
            this.clearVariables();
        } else if ("purge classes".equals(result.trim())) {
            this.clearClasses();
        } else if ("purge imports".equals(result.trim())) {
            this.clearImports();
        } else if ("purge all".equals(result.trim())) {
            this.clearVariables();
            this.clearClasses();
            this.clearImports();
        } else {
            this.processCode();
        }
        String string = result;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/console/GroovyShellConsoleImpl", "addToHistoryInner"));
        }
        return string;
    }

    private void processCode() {
        for (GrTopStatement statement : this.getFile().getTopStatements()) {
            if (statement instanceof GrImportStatement) {
                this.getFile().addImportsFromString(GroovyShellConsoleImpl.importToString((GrImportStatement)statement));
                continue;
            }
            if (statement instanceof GrMethod) {
                this.getFile().addVariable(((GrMethod)statement).getName(), this.generateClosure((GrMethod)statement));
                continue;
            }
            if (statement instanceof GrAssignmentExpression) {
                GrAssignmentExpression assignment = (GrAssignmentExpression)statement;
                GrExpression left = assignment.getLValue();
                if (!(left instanceof GrReferenceExpression) || ((GrReferenceExpression)left).isQualified()) continue;
                this.getFile().addVariable(((GrReferenceExpression)left).getReferenceName(), assignment.getRValue());
                continue;
            }
            if (!(statement instanceof GrTypeDefinition)) continue;
            this.getFile().addTypeDefinition(this.prepareTypeDefinition((GrTypeDefinition)statement));
        }
        PsiType scriptType = this.getFile().getInferredScriptReturnType();
        if (scriptType != null) {
            this.getFile().addVariable("_", scriptType);
        }
    }

    @NotNull
    public GroovyShellCodeFragment getFile() {
        GroovyShellCodeFragment groovyShellCodeFragment = (GroovyShellCodeFragment)this.myFile;
        if (groovyShellCodeFragment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/console/GroovyShellConsoleImpl", "getFile"));
        }
        return groovyShellCodeFragment;
    }

    private void clearVariables() {
        this.getFile().clearVariables();
    }

    private void clearClasses() {
        this.getFile().clearClasses();
    }

    private void clearImports() {
        this.getFile().clearImports();
    }

    @NotNull
    private GrTypeDefinition prepareTypeDefinition(@NotNull GrTypeDefinition typeDefinition) {
        if (typeDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeDefinition", "org/jetbrains/plugins/groovy/console/GroovyShellConsoleImpl", "prepareTypeDefinition"));
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
        GroovyFile file = factory.createGroovyFile("", false, (PsiElement)this.myFile);
        GrTypeDefinition grTypeDefinition = (GrTypeDefinition)file.add(typeDefinition);
        if (grTypeDefinition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/console/GroovyShellConsoleImpl", "prepareTypeDefinition"));
        }
        return grTypeDefinition;
    }

    @NotNull
    private GrClosableBlock generateClosure(@NotNull GrMethod method) {
        GrParameter[] parameters;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/console/GroovyShellConsoleImpl", "generateClosure"));
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        for (GrParameter parameter : parameters = method.getParameters()) {
            buffer.append(parameter.getText());
            buffer.append(',');
        }
        if (parameters.length > 0) {
            buffer.delete(buffer.length() - 1, buffer.length());
        }
        buffer.append("->}");
        GrClosableBlock grClosableBlock = factory.createClosureFromText(buffer.toString(), (PsiElement)this.myFile);
        if (grClosableBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/console/GroovyShellConsoleImpl", "generateClosure"));
        }
        return grClosableBlock;
    }

    @Nullable
    private static String importToString(@NotNull GrImportStatement anImport) {
        if (anImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anImport", "org/jetbrains/plugins/groovy/console/GroovyShellConsoleImpl", "importToString"));
        }
        StringBuilder buffer = new StringBuilder();
        GrCodeReferenceElement reference = anImport.getImportReference();
        if (reference == null) {
            return null;
        }
        String qname = reference.getClassNameText();
        buffer.append(qname);
        if (!anImport.isOnDemand()) {
            String importedName = anImport.getImportedName();
            buffer.append(":").append(importedName);
        }
        return buffer.toString();
    }
}

