/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.plugincomponents;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;

public class EditorConfigNotifier {
    public static final String LAST_NOTIFICATION_STATUS = "editorconfig.notification";

    public static EditorConfigNotifier getInstance() {
        return (EditorConfigNotifier)ServiceManager.getService(EditorConfigNotifier.class);
    }

    public void error(Project project, String id, String message) {
        this.doNotify(project, id, message, NotificationType.ERROR);
    }

    protected void doNotify(Project project, String id, String message, NotificationType type) {
        String value = PropertiesComponent.getInstance((Project)project).getValue(LAST_NOTIFICATION_STATUS);
        if (id.equals(value)) {
            return;
        }
        Notifications.Bus.notify((Notification)new Notification("editorconfig", "EditorConfig", message, type), (Project)project);
        PropertiesComponent.getInstance((Project)project).setValue(LAST_NOTIFICATION_STATUS, id);
    }

    public void info(Project project, String message) {
        this.doNotify(project, message, message, NotificationType.INFORMATION);
    }
}

