/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.integrations.javaee;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.data.War;
import org.jetbrains.plugins.gradle.model.data.WarDirectory;
import org.jetbrains.plugins.gradle.model.data.WebConfigurationModelData;
import org.jetbrains.plugins.gradle.model.data.WebResource;
import org.jetbrains.plugins.gradle.model.web.WebConfiguration;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Order(value=1000)
public class JavaEEGradleProjectResolverExtension
extends AbstractProjectResolverExtension {
    private static final Logger LOG = Logger.getInstance(JavaEEGradleProjectResolverExtension.class);

    @Override
    public void populateModuleExtraModels(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "org/jetbrains/plugins/gradle/integrations/javaee/JavaEEGradleProjectResolverExtension", "populateModuleExtraModels"));
        }
        if (ideModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModule", "org/jetbrains/plugins/gradle/integrations/javaee/JavaEEGradleProjectResolverExtension", "populateModuleExtraModels"));
        }
        WebConfiguration webConfiguration = this.resolverCtx.getExtraProject(gradleModule, WebConfiguration.class);
        List warModels = webConfiguration != null ? ContainerUtil.map((Collection)webConfiguration.getWarModels(), (Function)new Function<WebConfiguration.WarModel, War>(){

            public War fun(WebConfiguration.WarModel model) {
                War war = new War(model.getWarName(), model.getWebAppDirName(), model.getWebAppDir());
                war.setWebXml(model.getWebXml());
                war.setWebResources(JavaEEGradleProjectResolverExtension.map(model.getWebResources()));
                war.setClasspath(model.getClasspath());
                war.setManifestContent(model.getManifestContent());
                return war;
            }
        }) : ContainerUtil.emptyList();
        ideModule.createChild(WebConfigurationModelData.KEY, (Object)new WebConfigurationModelData(GradleConstants.SYSTEM_ID, warModels));
        this.nextResolver.populateModuleExtraModels(gradleModule, ideModule);
    }

    @Override
    @NotNull
    public Set<Class> getExtraProjectModelClasses() {
        Set<Class> set = Collections.singleton(WebConfiguration.class);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/integrations/javaee/JavaEEGradleProjectResolverExtension", "getExtraProjectModelClasses"));
        }
        return set;
    }

    private static List<WebResource> map(List<WebConfiguration.WebResource> webResources) {
        return ContainerUtil.mapNotNull(webResources, (Function)new Function<WebConfiguration.WebResource, WebResource>(){

            public WebResource fun(WebConfiguration.WebResource resource) {
                if (resource == null) {
                    return null;
                }
                WarDirectory warDirectory = WarDirectory.fromPath(resource.getWarDirectory());
                return new WebResource(warDirectory, resource.getRelativePath(), resource.getFile());
            }
        });
    }
}

