/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.wizard;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.wizard.AbstractExternalModuleBuilder;
import com.intellij.openapi.externalSystem.service.project.wizard.ExternalModuleSettingsStep;
import com.intellij.openapi.externalSystem.service.settings.AbstractExternalProjectSettingsControl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.settings.GradleProjectSettingsControl;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleModuleBuilder
extends AbstractExternalModuleBuilder<GradleProjectSettings> {
    private static final Logger LOG = Logger.getInstance(GradleModuleBuilder.class);
    private static final String TEMPLATE_GRADLE_SETTINGS = "Gradle Settings.gradle";
    private static final String TEMPLATE_GRADLE_SETTINGS_MERGE = "Gradle Settings merge.gradle";
    private static final String TEMPLATE_GRADLE_BUILD_WITH_WRAPPER = "Gradle Build Script with wrapper.gradle";
    private static final String DEFAULT_TEMPLATE_GRADLE_BUILD = "Gradle Build Script.gradle";
    private static final String TEMPLATE_ATTRIBUTE_PROJECT_NAME = "PROJECT_NAME";
    private static final String TEMPLATE_ATTRIBUTE_MODULE_DIR_NAME = "MODULE_DIR_NAME";
    private static final String TEMPLATE_ATTRIBUTE_MODULE_NAME = "MODULE_NAME";
    @NotNull
    private WizardContext myWizardContext;

    public GradleModuleBuilder() {
        super(GradleConstants.SYSTEM_ID, (ExternalProjectSettings)new GradleProjectSettings());
    }

    public void setupRootModel(ModifiableRootModel modifiableRootModel) throws ConfigurationException {
        String contentEntryPath = this.getContentEntryPath();
        if (StringUtil.isEmpty((String)contentEntryPath)) {
            return;
        }
        File contentRootDir = new File(contentEntryPath);
        FileUtilRt.createDirectory((File)contentRootDir);
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        VirtualFile modelContentRootDir = fileSystem.refreshAndFindFileByIoFile(contentRootDir);
        if (modelContentRootDir == null) {
            return;
        }
        modifiableRootModel.addContentEntry(modelContentRootDir);
        if (this.myJdk != null) {
            modifiableRootModel.setSdk(this.myJdk);
        } else {
            modifiableRootModel.inheritSdk();
        }
        Project project = modifiableRootModel.getProject();
        this.setupGradleBuildFile(modelContentRootDir);
        this.setupGradleSettingsFile(modelContentRootDir, modifiableRootModel);
        if (this.myWizardContext.isCreatingNewProject()) {
            String externalProjectPath = FileUtil.toCanonicalPath((String)project.getBasePath());
            ((GradleProjectSettings)this.getExternalProjectSettings()).setExternalProjectPath(externalProjectPath);
            AbstractExternalSystemSettings settings = ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID);
            project.putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, (Object)Boolean.TRUE);
            settings.linkProject(this.getExternalProjectSettings());
        } else {
            FileDocumentManager.getInstance().saveAllDocuments();
            ExternalSystemUtil.refreshProjects((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (boolean)false);
        }
    }

    public ModuleWizardStep[] createWizardSteps(@NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        if (wizardContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizardContext", "org/jetbrains/plugins/gradle/service/project/wizard/GradleModuleBuilder", "createWizardSteps"));
        }
        if (modulesProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesProvider", "org/jetbrains/plugins/gradle/service/project/wizard/GradleModuleBuilder", "createWizardSteps"));
        }
        this.myWizardContext = wizardContext;
        return super.createWizardSteps(wizardContext, modulesProvider);
    }

    @Nullable
    public ModuleWizardStep getCustomOptionsStep(WizardContext context, Disposable parentDisposable) {
        if (!this.myWizardContext.isCreatingNewProject()) {
            return new ModuleWizardStep(){

                public JComponent getComponent() {
                    return new JPanel();
                }

                public void updateDataModel() {
                }
            };
        }
        GradleProjectSettingsControl settingsControl = new GradleProjectSettingsControl((GradleProjectSettings)this.getExternalProjectSettings());
        return new ExternalModuleSettingsStep((AbstractExternalModuleBuilder)this, (AbstractExternalProjectSettingsControl)settingsControl);
    }

    public boolean isSuitableSdkType(SdkTypeId sdk) {
        return sdk instanceof JavaSdkType;
    }

    public String getParentGroup() {
        return "Build Tools";
    }

    public int getWeight() {
        return 80;
    }

    public ModuleType getModuleType() {
        return StdModuleTypes.JAVA;
    }

    @Nullable
    private VirtualFile setupGradleBuildFile(@NotNull VirtualFile modelContentRootDir) throws ConfigurationException {
        if (modelContentRootDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelContentRootDir", "org/jetbrains/plugins/gradle/service/project/wizard/GradleModuleBuilder", "setupGradleBuildFile"));
        }
        VirtualFile file = GradleModuleBuilder.getExternalProjectConfigFile(modelContentRootDir.getPath(), "build.gradle");
        String templateName = ((GradleProjectSettings)this.getExternalProjectSettings()).getDistributionType() == DistributionType.WRAPPED ? TEMPLATE_GRADLE_BUILD_WITH_WRAPPER : DEFAULT_TEMPLATE_GRADLE_BUILD;
        HashMap attributes = ContainerUtil.newHashMap();
        if (file != null) {
            GradleModuleBuilder.saveFile(file, templateName, attributes);
        }
        return file;
    }

    @Nullable
    private VirtualFile setupGradleSettingsFile(@NotNull VirtualFile modelContentRootDir, @NotNull ModifiableRootModel model) throws ConfigurationException {
        if (modelContentRootDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelContentRootDir", "org/jetbrains/plugins/gradle/service/project/wizard/GradleModuleBuilder", "setupGradleSettingsFile"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/plugins/gradle/service/project/wizard/GradleModuleBuilder", "setupGradleSettingsFile"));
        }
        VirtualFile file = null;
        if (this.myWizardContext.isCreatingNewProject()) {
            String moduleDirName = VfsUtilCore.getRelativePath((VirtualFile)modelContentRootDir, (VirtualFile)model.getProject().getBaseDir(), (char)'/');
            file = GradleModuleBuilder.getExternalProjectConfigFile(model.getProject().getBasePath(), "settings.gradle");
            if (file == null) {
                return null;
            }
            HashMap attributes = ContainerUtil.newHashMap();
            String projectName = model.getProject().getName();
            attributes.put(TEMPLATE_ATTRIBUTE_PROJECT_NAME, projectName);
            attributes.put(TEMPLATE_ATTRIBUTE_MODULE_DIR_NAME, moduleDirName);
            attributes.put(TEMPLATE_ATTRIBUTE_MODULE_NAME, model.getModule().getName());
            GradleModuleBuilder.saveFile(file, TEMPLATE_GRADLE_SETTINGS, attributes);
        } else {
            String rootProjectPath;
            HashMap moduleMap = ContainerUtil.newHashMap();
            for (Module module : ModuleManager.getInstance((Project)model.getProject()).getModules()) {
                for (ContentEntry contentEntry : model.getContentEntries()) {
                    if (contentEntry.getFile() == null) continue;
                    moduleMap.put(contentEntry.getFile().getPath(), module);
                }
            }
            Module module = null;
            for (VirtualFile virtualFile = modelContentRootDir; virtualFile != null && module == null; virtualFile = virtualFile.getParent()) {
                module = (Module)moduleMap.get(virtualFile.getPath());
            }
            if (module != null && !StringUtil.isEmpty((String)(rootProjectPath = module.getOptionValue("external.root.project.path")))) {
                VirtualFile rootProjectFile = VfsUtil.findFileByIoFile((File)new File(rootProjectPath), (boolean)true);
                if (rootProjectFile == null) {
                    return null;
                }
                String moduleDirName = VfsUtilCore.getRelativePath((VirtualFile)modelContentRootDir, (VirtualFile)rootProjectFile, (char)'/');
                file = GradleModuleBuilder.getExternalProjectConfigFile(rootProjectPath, "settings.gradle");
                if (file == null) {
                    return null;
                }
                HashMap attributes = ContainerUtil.newHashMap();
                attributes.put(TEMPLATE_ATTRIBUTE_MODULE_DIR_NAME, moduleDirName);
                attributes.put(TEMPLATE_ATTRIBUTE_MODULE_NAME, model.getModule().getName());
                GradleModuleBuilder.appendToFile(file, TEMPLATE_GRADLE_SETTINGS_MERGE, attributes);
            }
        }
        return file;
    }

    private static void saveFile(@NotNull VirtualFile file, @NotNull String templateName, @Nullable Map templateAttributes) throws ConfigurationException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/gradle/service/project/wizard/GradleModuleBuilder", "saveFile"));
        }
        if (templateName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateName", "org/jetbrains/plugins/gradle/service/project/wizard/GradleModuleBuilder", "saveFile"));
        }
        FileTemplateManager manager = FileTemplateManager.getInstance();
        FileTemplate template = manager.getInternalTemplate(templateName);
        try {
            VfsUtil.saveText((VirtualFile)file, (String)(templateAttributes != null ? template.getText(templateAttributes) : template.getText()));
        }
        catch (IOException e) {
            LOG.warn(String.format("Unexpected exception on applying template %s config", GradleConstants.SYSTEM_ID.getReadableName()), (Throwable)e);
            throw new ConfigurationException(e.getMessage(), String.format("Can't apply %s template config text", GradleConstants.SYSTEM_ID.getReadableName()));
        }
    }

    private static void appendToFile(@NotNull VirtualFile file, @NotNull String templateName, @Nullable Map templateAttributes) throws ConfigurationException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/gradle/service/project/wizard/GradleModuleBuilder", "appendToFile"));
        }
        if (templateName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateName", "org/jetbrains/plugins/gradle/service/project/wizard/GradleModuleBuilder", "appendToFile"));
        }
        FileTemplateManager manager = FileTemplateManager.getInstance();
        FileTemplate template = manager.getInternalTemplate(templateName);
        try {
            VfsUtil.saveText((VirtualFile)file, (String)(VfsUtilCore.loadText((VirtualFile)file) + (templateAttributes != null ? template.getText(templateAttributes) : template.getText())));
        }
        catch (IOException e) {
            LOG.warn(String.format("Unexpected exception on appending template %s config", GradleConstants.SYSTEM_ID.getReadableName()), (Throwable)e);
            throw new ConfigurationException(e.getMessage(), String.format("Can't append %s template config text", GradleConstants.SYSTEM_ID.getReadableName()));
        }
    }

    @Nullable
    private static VirtualFile getExternalProjectConfigFile(@NotNull String parent, @NotNull String fileName) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/plugins/gradle/service/project/wizard/GradleModuleBuilder", "getExternalProjectConfigFile"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/plugins/gradle/service/project/wizard/GradleModuleBuilder", "getExternalProjectConfigFile"));
        }
        File file = new File(parent, fileName);
        FileUtilRt.createIfNotExists((File)file);
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
    }
}

