/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.PackageAnnotator;
import com.intellij.rt.coverage.instrumentation.SourceLineCounter;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntProcedure;
import java.util.List;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

public class SourceLineCounterUtil {
    public static boolean collectNonCoveredClassInfo(PackageAnnotator.ClassCoverageInfo classCoverageInfo, PackageAnnotator.PackageCoverageInfo packageCoverageInfo, byte[] content, boolean excludeLines) {
        if (content == null) {
            return false;
        }
        ClassReader reader = new ClassReader(content, 0, content.length);
        SourceLineCounter counter = new SourceLineCounter(null, excludeLines, null);
        reader.accept((ClassVisitor)counter, 0);
        classCoverageInfo.totalLineCount += counter.getNSourceLines();
        classCoverageInfo.totalMethodCount += counter.getNMethodsWithCode();
        packageCoverageInfo.totalLineCount += counter.getNSourceLines();
        packageCoverageInfo.totalMethodCount += counter.getNMethodsWithCode();
        if (!counter.isInterface()) {
            ++packageCoverageInfo.totalClassCount;
        }
        return true;
    }

    public static void collectSrcLinesForUntouchedFiles(final List<Integer> uncoveredLines, byte[] content, boolean excludeLines) {
        ClassReader reader = new ClassReader(content);
        SourceLineCounter collector = new SourceLineCounter(null, excludeLines, null);
        reader.accept((ClassVisitor)collector, 0);
        TIntObjectHashMap lines = collector.getSourceLines();
        lines.forEachKey(new TIntProcedure(){

            public boolean execute(int line) {
                uncoveredLines.add(--line);
                return true;
            }
        });
    }
}

