/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation;

import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.rendering.api.ViewType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.navigation.RenderingParameters;
import com.android.tools.idea.editors.navigation.Transform;
import com.android.tools.idea.editors.navigation.model.ModelDimension;
import com.android.tools.idea.editors.navigation.model.ModelPoint;
import com.android.tools.idea.rendering.ImageUtils;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderedImage;
import com.android.tools.idea.rendering.RenderedView;
import com.android.tools.idea.rendering.RenderedViewHierarchy;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidRootComponent
extends JComponent {
    public static final boolean DEBUG = false;
    private final RenderingParameters myRenderingParameters;
    private final PsiFile myLayoutFile;
    public final boolean isMenu;
    @NotNull
    Transform transform;
    private Image myScaledImage;
    private RenderResult myRenderResult;
    private boolean myRenderPending;
    private boolean myCachedMenuValid;
    private RenderedView myCachedMenu;

    public AndroidRootComponent(@NotNull RenderingParameters renderingParameters, @Nullable PsiFile psiFile, boolean isMenu) {
        if (renderingParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderingParameters", "com/android/tools/idea/editors/navigation/AndroidRootComponent", "<init>"));
        }
        this.transform = this.createTransform(1.0f);
        this.myRenderResult = null;
        this.myRenderPending = false;
        this.myCachedMenuValid = false;
        this.myRenderingParameters = renderingParameters;
        this.myLayoutFile = psiFile;
        this.isMenu = isMenu;
    }

    public static void launchEditor(RenderingParameters renderingParameters, @Nullable PsiFile file, boolean layoutFile) {
        if (file != null) {
            Project project = renderingParameters.myProject;
            VirtualFile virtualFile = file.getVirtualFile();
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, virtualFile, 0);
            FileEditorManager manager = FileEditorManager.getInstance((Project)project);
            manager.openEditor(descriptor, true);
            if (layoutFile) {
                manager.setSelectedEditor(virtualFile, "android-designer");
            }
        }
    }

    public void launchLayoutEditor() {
        AndroidRootComponent.launchEditor(this.myRenderingParameters, this.myLayoutFile, true);
    }

    @Nullable
    public RenderResult getRenderResult() {
        return this.myRenderResult;
    }

    private void setRenderResult(@Nullable RenderResult renderResult) {
        Container parent = this.getParent();
        if (parent == null) {
            return;
        }
        this.myRenderResult = renderResult;
        if (this.isMenu) {
            this.myCachedMenuValid = false;
            this.revalidate();
        }
        parent.repaint();
    }

    public float getScale() {
        return this.transform.myScale;
    }

    private void invalidate2() {
        this.myScaledImage = null;
    }

    public void setScale(float scale) {
        this.transform = this.createTransform(scale);
        this.invalidate2();
    }

    @Nullable
    private RenderedView getCachedMenu() {
        if (!this.myCachedMenuValid) {
            this.myCachedMenu = AndroidRootComponent.getMenu(this.myRenderResult);
            this.myCachedMenuValid = true;
        }
        return this.myCachedMenu;
    }

    private Transform createTransform(float scale) {
        if (this.isMenu) {
            return new Transform(scale){

                private int getDx() {
                    RenderedView menu = AndroidRootComponent.this.getCachedMenu();
                    return menu == null ? 0 : menu.x;
                }

                private int getDy() {
                    RenderedView menu = AndroidRootComponent.this.getCachedMenu();
                    return menu == null ? 0 : menu.y;
                }

                @Override
                public int modelToViewX(int x) {
                    return super.modelToViewX(x - this.getDx());
                }

                @Override
                public int modelToViewY(int y) {
                    return super.modelToViewY(y - this.getDy());
                }

                @Override
                public int viewToModelX(int x) {
                    return super.viewToModelX(x) + this.getDx();
                }

                @Override
                public int viewToModelY(int y) {
                    return super.viewToModelY(y) + this.getDy();
                }
            };
        }
        return new Transform(scale);
    }

    @Nullable
    private static RenderedView findMenu(List<RenderedView> children) {
        for (RenderedView child : children) {
            ViewInfo view = child.view;
            if (view != null && view.getViewType() == ViewType.ACTION_BAR_OVERFLOW_MENU) {
                return child.getParent();
            }
            RenderedView menu = AndroidRootComponent.findMenu(child.getChildren());
            if (menu == null) continue;
            return menu;
        }
        return null;
    }

    @Nullable
    private static RenderedView getMenu(RenderResult renderResult) {
        if (renderResult == null) {
            return null;
        }
        RenderedViewHierarchy hierarchy = renderResult.getHierarchy();
        if (hierarchy == null) {
            return null;
        }
        return AndroidRootComponent.findMenu(hierarchy.getRoots());
    }

    private static ModelDimension size(@Nullable RenderedView view) {
        if (view == null) {
            return new ModelDimension(100, 100);
        }
        return new ModelDimension(view.w, view.h);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.transform.modelToView(this.isMenu ? AndroidRootComponent.size(AndroidRootComponent.getMenu(this.myRenderResult)) : this.myRenderingParameters.getDeviceScreenSize());
    }

    @Nullable
    private Image getScaledImage() {
        if (this.myScaledImage == null || this.myScaledImage.getWidth(null) != this.getWidth() || this.myScaledImage.getHeight(null) != this.getHeight()) {
            RenderedImage renderedImage = this.myRenderResult == null ? null : this.myRenderResult.getImage();
            BufferedImage image = renderedImage == null ? null : renderedImage.getOriginalImage();
            this.myScaledImage = image == null ? null : ImageUtils.scale(image, this.transform.myScale, this.transform.myScale, 0, 0);
        }
        return this.myScaledImage;
    }

    private void center(Graphics g, String message, Font font, int height) {
        int messageWidth = this.getFontMetrics(font).stringWidth(message);
        g.drawString(message, (this.getWidth() - messageWidth) / 2, height);
    }

    @Override
    public void paintComponent(Graphics g) {
        Image scaledImage = this.getScaledImage();
        if (scaledImage != null) {
            if (this.isMenu) {
                Point point = this.transform.modelToView(ModelPoint.ORIGIN);
                g.drawImage(scaledImage, point.x, point.y, null);
            } else {
                g.drawImage(scaledImage, 0, 0, null);
            }
        } else {
            g.setColor((Color)JBColor.WHITE);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor((Color)JBColor.GRAY);
            Font font = g.getFont();
            int vCenter = this.getHeight() / 2;
            String message = "[" + (this.myLayoutFile == null ? "no xml resource" : this.myLayoutFile.getName()) + "]";
            this.center(g, message, font, vCenter);
            this.render();
        }
    }

    private void render() {
        if (this.myLayoutFile == null) {
            return;
        }
        Project project = this.myRenderingParameters.myProject;
        final AndroidFacet facet = this.myRenderingParameters.myFacet;
        final Configuration configuration = this.myRenderingParameters.myConfiguration;
        if (project.isDisposed()) {
            return;
        }
        if (this.myRenderPending) {
            return;
        }
        this.myRenderPending = true;
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                Module module = facet.getModule();
                RenderLogger logger = new RenderLogger(AndroidRootComponent.this.myLayoutFile.getName(), module);
                RenderService service = RenderService.create(facet, module, AndroidRootComponent.this.myLayoutFile, configuration, logger, null);
                if (service != null) {
                    Result result;
                    RenderSession session;
                    RenderResult renderedResult;
                    if (!AndroidRootComponent.this.isMenu) {
                        service.getLayoutlibCallback().getActionBarCallback().setMenuIdNames(Collections.<String>emptyList());
                    }
                    if ((renderedResult = service.render()) != null && (session = renderedResult.getSession()) != null && (result = session.getResult()).isSuccess()) {
                        AndroidRootComponent.this.setRenderResult(renderedResult);
                        service.dispose();
                        return;
                    }
                }
            }
        });
    }

    @Nullable
    public RenderedView getRenderedView(Point p) {
        RenderResult renderResult = this.getRenderResult();
        if (renderResult == null) {
            return null;
        }
        RenderedViewHierarchy hierarchy = renderResult.getHierarchy();
        if (hierarchy == null) {
            return null;
        }
        return hierarchy.findLeafAt(this.transform.viewToModelX(p.x), this.transform.viewToModelY(p.y));
    }
}

