/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.sdklib.repository.FullRevision;
import com.android.tools.idea.gradle.project.ChooseGradleHomeDialog;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

final class PreSyncChecks {
    private static final Logger LOG = Logger.getInstance(PreSyncChecks.class);
    private static final String GRADLE_SYNC_MSG_TITLE = "Gradle Sync";

    private PreSyncChecks() {
    }

    static boolean canSync(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/PreSyncChecks", "canSync"));
        }
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            return true;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            FullRevision modelVersion = GradleUtil.getResolvedAndroidGradleModelVersion(project);
            PreSyncChecks.ensureCorrectGradleSettings(project, modelVersion);
            GradleUtil.attemptToUseEmbeddedGradle(project);
        }
        return true;
    }

    private static void ensureCorrectGradleSettings(@NotNull Project project, @Nullable FullRevision modelVersion) {
        boolean usingWrapper;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/PreSyncChecks", "ensureCorrectGradleSettings"));
        }
        if (modelVersion == null || PreSyncChecks.createWrapperIfNecessary(project)) {
            return;
        }
        GradleProjectSettings gradleSettings = GradleUtil.getGradleProjectSettings(project);
        File wrapperPropertiesFile = GradleUtil.findWrapperPropertiesFile(project);
        DistributionType distributionType = gradleSettings != null ? gradleSettings.getDistributionType() : null;
        boolean bl = usingWrapper = (distributionType == null || distributionType == DistributionType.DEFAULT_WRAPPED) && wrapperPropertiesFile != null;
        if (usingWrapper) {
            PreSyncChecks.attemptToUpdateGradleVersionInWrapper(wrapperPropertiesFile, modelVersion, project);
            if (gradleSettings != null) {
                gradleSettings.setDistributionType(DistributionType.DEFAULT_WRAPPED);
            }
        } else if (distributionType == DistributionType.LOCAL) {
            PreSyncChecks.attemptToUseSupportedLocalGradle(modelVersion, gradleSettings, project);
        }
    }

    private static boolean createWrapperIfNecessary(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/PreSyncChecks", "createWrapperIfNecessary"));
        }
        GradleProjectSettings gradleSettings = GradleUtil.getGradleProjectSettings(project);
        if (gradleSettings == null) {
            return true;
        }
        File wrapperPropertiesFile = GradleUtil.findWrapperPropertiesFile(project);
        if (wrapperPropertiesFile == null) {
            ChooseGradleHomeDialog dialog;
            DistributionType distributionType = gradleSettings.getDistributionType();
            boolean createWrapper = false;
            if (distributionType == null) {
                String msg = "Gradle settings for this project are not configured yet.\n\nWould you like the project to use the Gradle wrapper?\n(The wrapper will automatically download the latest supported Gradle version).\n\nClick 'OK' to use the Gradle wrapper, or 'Cancel' to manually set the path of a local Gradle distribution.";
                int answer = Messages.showOkCancelDialog((Project)project, (String)msg, (String)GRADLE_SYNC_MSG_TITLE, (Icon)Messages.getQuestionIcon());
                createWrapper = answer == 0;
            } else if (distributionType == DistributionType.DEFAULT_WRAPPED) {
                createWrapper = true;
            }
            if (createWrapper) {
                File projectDirPath = new File(project.getBasePath());
                File gradleDirPath = new File(projectDirPath, "gradle");
                if (!FileUtil.delete((File)gradleDirPath)) {
                    return true;
                }
                try {
                    GradleUtil.createGradleWrapper(projectDirPath);
                    if (distributionType == null) {
                        gradleSettings.setDistributionType(DistributionType.DEFAULT_WRAPPED);
                    }
                    return true;
                }
                catch (IOException e) {
                    LOG.info("Failed to create Gradle wrapper for project '" + project.getName() + "'", (Throwable)e);
                }
            } else if (distributionType == null && (dialog = new ChooseGradleHomeDialog()).showAndGet()) {
                String enteredGradleHomePath = dialog.getEnteredGradleHomePath();
                gradleSettings.setGradleHome(enteredGradleHomePath);
                gradleSettings.setDistributionType(DistributionType.LOCAL);
                return true;
            }
        }
        return false;
    }

    private static void attemptToUpdateGradleVersionInWrapper(@NotNull File wrapperPropertiesFile, @NotNull FullRevision modelVersion, @NotNull Project project) {
        if (wrapperPropertiesFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapperPropertiesFile", "com/android/tools/idea/gradle/project/PreSyncChecks", "attemptToUpdateGradleVersionInWrapper"));
        }
        if (modelVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelVersion", "com/android/tools/idea/gradle/project/PreSyncChecks", "attemptToUpdateGradleVersionInWrapper"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/PreSyncChecks", "attemptToUpdateGradleVersionInWrapper"));
        }
        FullRevision minimumPluginVersion = FullRevision.parseRevision((String)"1.0.0");
        if (modelVersion.compareTo(minimumPluginVersion) < 0) {
            return;
        }
        String gradleVersion = null;
        try {
            gradleVersion = GradleUtil.getGradleWrapperVersion(wrapperPropertiesFile);
        }
        catch (IOException e) {
            LOG.warn("Failed to read file " + wrapperPropertiesFile.getPath());
        }
        if (gradleVersion == null) {
            return;
        }
        FullRevision gradleRevision = null;
        try {
            gradleRevision = FullRevision.parseRevision((String)gradleVersion);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (gradleRevision != null && !PreSyncChecks.isSupportedGradleVersion(gradleRevision)) {
            String newGradleVersion = "2.2.1";
            String msg = PreSyncChecks.getMinimumGradleVersionErrorPrefix(modelVersion) + "\nClick 'OK' to automatically update the Gradle version in the Gradle wrapper and continue.";
            Messages.showMessageDialog((Project)project, (String)msg, (String)GRADLE_SYNC_MSG_TITLE, (Icon)Messages.getQuestionIcon());
            try {
                GradleUtil.updateGradleDistributionUrl(newGradleVersion, wrapperPropertiesFile);
            }
            catch (IOException e) {
                LOG.warn("Failed to update Gradle wrapper file to Gradle version " + newGradleVersion);
            }
        }
    }

    private static void attemptToUseSupportedLocalGradle(@NotNull FullRevision modelVersion, @NotNull GradleProjectSettings gradleSettings, @NotNull Project project) {
        if (modelVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelVersion", "com/android/tools/idea/gradle/project/PreSyncChecks", "attemptToUseSupportedLocalGradle"));
        }
        if (gradleSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleSettings", "com/android/tools/idea/gradle/project/PreSyncChecks", "attemptToUseSupportedLocalGradle"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/PreSyncChecks", "attemptToUseSupportedLocalGradle"));
        }
        String gradleHome = gradleSettings.getGradleHome();
        FullRevision gradleVersion = null;
        boolean askToSwitchToWrapper = false;
        if (StringUtil.isEmpty((String)gradleHome)) {
            askToSwitchToWrapper = true;
        } else {
            File gradleHomePath = new File(gradleHome);
            gradleVersion = GradleUtil.getGradleVersion(gradleHomePath);
            if (gradleVersion == null) {
                askToSwitchToWrapper = true;
            }
        }
        if (!askToSwitchToWrapper) {
            boolean bl = askToSwitchToWrapper = !PreSyncChecks.isSupportedGradleVersion(gradleVersion);
        }
        if (askToSwitchToWrapper) {
            String msg = PreSyncChecks.getMinimumGradleVersionErrorPrefix(modelVersion) + "A local Gradle distribution was not found, or was not properly set in the IDE.\n\n" + "Would you like your project to use the Gradle wrapper instead?\n" + "(The wrapper will automatically download the latest supported Gradle version).\n\n" + "Click 'OK' to use the Gradle wrapper, or 'Cancel' to manually set the path of a local Gradle distribution.";
            int answer = Messages.showOkCancelDialog((Project)project, (String)msg, (String)GRADLE_SYNC_MSG_TITLE, (Icon)Messages.getQuestionIcon());
            if (answer == 0) {
                try {
                    File projectDirPath = new File(project.getBasePath());
                    GradleUtil.createGradleWrapper(projectDirPath);
                    gradleSettings.setDistributionType(DistributionType.DEFAULT_WRAPPED);
                }
                catch (IOException e) {
                    LOG.warn("Failed to update Gradle wrapper file to Gradle version 2.2.1", (Throwable)e);
                }
                return;
            }
            ChooseGradleHomeDialog dialog = new ChooseGradleHomeDialog();
            dialog.setTitle(String.format("Please select the location of a Gradle distribution version %1$s or newer", "2.2.1"));
            if (dialog.showAndGet()) {
                String enteredGradleHomePath = dialog.getEnteredGradleHomePath();
                gradleSettings.setGradleHome(enteredGradleHomePath);
            }
        }
    }

    @NotNull
    private static String getMinimumGradleVersionErrorPrefix(@NotNull FullRevision modelVersion) {
        if (modelVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelVersion", "com/android/tools/idea/gradle/project/PreSyncChecks", "getMinimumGradleVersionErrorPrefix"));
        }
        String string = "Version " + modelVersion + " of the Android Gradle plug-in requires Gradle " + "2.2.1" + " or newer.\n";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/PreSyncChecks", "getMinimumGradleVersionErrorPrefix"));
        }
        return string;
    }

    private static boolean isSupportedGradleVersion(@NotNull FullRevision gradleVersion) {
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleVersion", "com/android/tools/idea/gradle/project/PreSyncChecks", "isSupportedGradleVersion"));
        }
        FullRevision supported = FullRevision.parseRevision((String)"2.2.1");
        return supported.compareTo(gradleVersion) <= 0;
    }
}

