/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.errors;

import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSyncErrorHandler {
    public static final ExtensionPointName<AbstractSyncErrorHandler> EP_NAME = ExtensionPointName.create((String)"org.jetbrains.android.androidSyncErrorHandler");
    public static final String FAILED_TO_SYNC_GRADLE_PROJECT_ERROR_GROUP_FORMAT = "Failed to sync Gradle project '%1$s'";
    protected static final NotificationHyperlink[] EMPTY = new NotificationHyperlink[0];
    private static final Pattern ERROR_LOCATION_IN_FILE_PATTERN = Pattern.compile("Build file '(.*)' line: ([\\d]+)");
    private static final Pattern ERROR_IN_FILE_PATTERN = Pattern.compile("Build file '(.*)'");
    protected static final NotificationType DEFAULT_NOTIFICATION_TYPE = NotificationType.ERROR;

    public abstract boolean handleError(@NotNull List<String> var1, @NotNull ExternalSystemException var2, @NotNull NotificationData var3, @NotNull Project var4);

    @Nullable
    protected static Pair<String, Integer> getErrorLocation(@NotNull String msg) {
        if (msg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/android/tools/idea/gradle/service/notification/errors/AbstractSyncErrorHandler", "getErrorLocation"));
        }
        Matcher matcher = ERROR_LOCATION_IN_FILE_PATTERN.matcher(msg);
        if (matcher.matches()) {
            String filePath = matcher.group(1);
            int line = -1;
            try {
                line = Integer.parseInt(matcher.group(2));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            return Pair.create((Object)filePath, (Object)line);
        }
        matcher = ERROR_IN_FILE_PATTERN.matcher(msg);
        if (matcher.matches()) {
            String filePath = matcher.group(1);
            return Pair.create((Object)filePath, (Object)-1);
        }
        return null;
    }

    protected static void updateNotification(@NotNull NotificationData notification, @NotNull Project project, @NotNull String errorMsg, @NotNull List<NotificationHyperlink> hyperlinks) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/service/notification/errors/AbstractSyncErrorHandler", "updateNotification"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/errors/AbstractSyncErrorHandler", "updateNotification"));
        }
        if (errorMsg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMsg", "com/android/tools/idea/gradle/service/notification/errors/AbstractSyncErrorHandler", "updateNotification"));
        }
        if (hyperlinks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hyperlinks", "com/android/tools/idea/gradle/service/notification/errors/AbstractSyncErrorHandler", "updateNotification"));
        }
        AbstractSyncErrorHandler.updateNotification(notification, project, errorMsg, hyperlinks.toArray(new NotificationHyperlink[hyperlinks.size()]));
    }

    protected static void updateNotification(@NotNull NotificationData notification, @NotNull Project project, @NotNull String errorMsg, NotificationHyperlink ... hyperlinks) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/service/notification/errors/AbstractSyncErrorHandler", "updateNotification"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/errors/AbstractSyncErrorHandler", "updateNotification"));
        }
        if (errorMsg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMsg", "com/android/tools/idea/gradle/service/notification/errors/AbstractSyncErrorHandler", "updateNotification"));
        }
        if (hyperlinks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hyperlinks", "com/android/tools/idea/gradle/service/notification/errors/AbstractSyncErrorHandler", "updateNotification"));
        }
        String title = String.format(FAILED_TO_SYNC_GRADLE_PROJECT_ERROR_GROUP_FORMAT, project.getName());
        AbstractSyncErrorHandler.updateNotification(notification, project, title, errorMsg, hyperlinks);
    }

    public static void updateNotification(@NotNull NotificationData notification, @NotNull Project project, @NotNull String title, @NotNull String errorMsg, NotificationHyperlink ... hyperlinks) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/service/notification/errors/AbstractSyncErrorHandler", "updateNotification"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/errors/AbstractSyncErrorHandler", "updateNotification"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/gradle/service/notification/errors/AbstractSyncErrorHandler", "updateNotification"));
        }
        if (errorMsg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMsg", "com/android/tools/idea/gradle/service/notification/errors/AbstractSyncErrorHandler", "updateNotification"));
        }
        if (hyperlinks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hyperlinks", "com/android/tools/idea/gradle/service/notification/errors/AbstractSyncErrorHandler", "updateNotification"));
        }
        String text = errorMsg;
        int hyperlinkCount = hyperlinks.length;
        if (hyperlinkCount > 0) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < hyperlinkCount; ++i) {
                b.append(hyperlinks[i].toHtml());
                if (i >= hyperlinkCount - 1) continue;
                b.append("<br>");
            }
            text = text + '\n' + b.toString();
        }
        notification.setTitle(title);
        notification.setMessage(text);
        notification.setNotificationCategory(NotificationCategory.convert((NotificationType)DEFAULT_NOTIFICATION_TYPE));
        AbstractSyncErrorHandler.addNotificationListener(notification, project, hyperlinks);
    }

    protected static void addNotificationListener(@NotNull NotificationData notification, final @NotNull Project project, NotificationHyperlink ... hyperlinks) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/service/notification/errors/AbstractSyncErrorHandler", "addNotificationListener"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/errors/AbstractSyncErrorHandler", "addNotificationListener"));
        }
        if (hyperlinks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hyperlinks", "com/android/tools/idea/gradle/service/notification/errors/AbstractSyncErrorHandler", "addNotificationListener"));
        }
        for (final NotificationHyperlink hyperlink : hyperlinks) {
            notification.setListener(hyperlink.getUrl(), (NotificationListener)new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/service/notification/errors/AbstractSyncErrorHandler$1", "hyperlinkActivated"));
                    }
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/service/notification/errors/AbstractSyncErrorHandler$1", "hyperlinkActivated"));
                    }
                    hyperlink.executeIfClicked(project, e);
                }
            });
        }
    }
}

