/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.multi;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.State;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.NestedConfiguration;
import com.android.tools.idea.configurations.RenderContext;
import com.android.tools.idea.ddms.screenshot.DeviceArtPainter;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.ImageUtils;
import com.android.tools.idea.rendering.IncludeReference;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.rendering.RenderErrorPanel;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderedImage;
import com.android.tools.idea.rendering.ShadowPainter;
import com.android.tools.idea.rendering.multi.PreviewRenderContext;
import com.android.tools.idea.rendering.multi.RenderPreviewManager;
import com.android.tools.idea.rendering.multi.RenderPreviewMode;
import com.android.utils.SdkUtils;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.PairFunction;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Comparator;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.AndroidEditorSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderPreview
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.android.tools.idea.rendering.RenderPreview");
    private static final int HEADER_HEIGHT = 20;
    private static final boolean ZOOM_SUPPORT = false;
    private static final boolean DUMP_RENDER_DIAGNOSTICS = true;
    private static final boolean DEBUG = false;
    @NotNull
    private Configuration myConfiguration;
    @NotNull
    private Configuration myAlternateConfiguration;
    @NotNull
    private final RenderPreviewManager myManager;
    @NotNull
    private final RenderContext myRenderContext;
    @Nullable
    private BufferedImage myThumbnail;
    @Nullable
    private String myDisplayName;
    private int myX;
    private int myY;
    private int myLayoutWidth;
    private int myLayoutHeight;
    private int myTitleHeight;
    private double myScale;
    private double myAspectRatio;
    private boolean myShowFrame;
    private boolean myThumbnailHasFrame;
    @Nullable
    private Rectangle myViewBounds;
    @Nullable
    private Runnable myPendingRendering;
    @Nullable
    private String myId;
    @Nullable
    private VirtualFile myAlternateInput;
    @Nullable
    private IncludeReference myIncludedWithin;
    private boolean myActive;
    private String myError;
    private boolean myVisible;
    private int myDirty;
    private BufferedImage myFullImage;
    private int myFullWidth;
    private int myFullHeight;
    static Comparator<RenderPreview> INCREASING_ASPECT_RATIO = new Comparator<RenderPreview>(){

        @Override
        public int compare(RenderPreview preview1, RenderPreview preview2) {
            return (int)Math.signum(preview1.myAspectRatio - preview2.myAspectRatio);
        }
    };
    static Comparator<RenderPreview> DECREASING_ASPECT_RATIO = new Comparator<RenderPreview>(){

        @Override
        public int compare(RenderPreview preview1, RenderPreview preview2) {
            return (int)Math.signum(preview2.myAspectRatio - preview1.myAspectRatio);
        }
    };
    static Comparator<RenderPreview> VISUAL_ORDER = new Comparator<RenderPreview>(){

        @Override
        public int compare(RenderPreview preview1, RenderPreview preview2) {
            int delta = preview1.myY - preview2.myY;
            if (delta == 0) {
                delta = preview1.myX - preview2.myX;
            }
            return delta;
        }
    };
    private int myMaxWidth;
    private int myMaxHeight;

    private RenderPreview(@NotNull RenderPreviewManager manager, @NotNull RenderContext renderContext, @NotNull Configuration configuration, boolean showFrame) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/android/tools/idea/rendering/multi/RenderPreview", "<init>"));
        }
        if (renderContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderContext", "com/android/tools/idea/rendering/multi/RenderPreview", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/rendering/multi/RenderPreview", "<init>"));
        }
        this.myScale = 1.0;
        this.myManager = manager;
        this.myRenderContext = renderContext;
        this.myConfiguration = configuration;
        this.myShowFrame = showFrame;
        assert (this.myConfiguration.getDevice() != null);
        assert (this.myConfiguration.getDeviceState() != null);
        assert (this.myConfiguration.getTarget() != null);
        assert (this.myConfiguration.getTheme() != null);
        assert (this.myConfiguration.getFullConfig().getScreenSizeQualifier() != null) : this.myConfiguration;
        this.computeInitialSize();
    }

    void computeInitialSize() {
        this.computeFullSize();
        if (this.myFullHeight > 0) {
            double scale = Math.min(1.0, RenderPreview.getScale(this.myFullWidth, this.myFullHeight));
            this.myLayoutWidth = (int)((double)this.myFullWidth * scale);
            this.myLayoutHeight = (int)((double)this.myFullHeight * scale);
        } else {
            this.myAspectRatio = 1.0;
            this.myLayoutWidth = RenderPreviewManager.getMaxWidth();
            this.myLayoutHeight = RenderPreviewManager.getMaxHeight();
        }
    }

    private boolean computeFullSize() {
        Device device = this.myConfiguration.getDevice();
        if (device == null) {
            return true;
        }
        Screen screen = device.getDefaultHardware().getScreen();
        if (screen == null) {
            return true;
        }
        State deviceState = this.myConfiguration.getDeviceState();
        if (deviceState == null) {
            deviceState = device.getDefaultState();
        }
        ScreenOrientation orientation = deviceState.getOrientation();
        Dimension size = device.getScreenSize(orientation);
        assert (size != null);
        int screenWidth = size.width;
        int screenHeight = size.height;
        boolean changed = this.myFullWidth != screenWidth || this.myFullHeight != screenHeight;
        this.myFullWidth = screenWidth;
        this.myFullHeight = screenHeight;
        if (this.myShowFrame) {
            DeviceArtPainter framePainter = DeviceArtPainter.getInstance();
            double xScale = framePainter.getFrameWidthOverhead(device, orientation);
            double yScale = framePainter.getFrameHeightOverhead(device, orientation);
            this.myFullWidth = (int)((double)this.myFullWidth * xScale);
            this.myFullHeight = (int)((double)this.myFullHeight * yScale);
        }
        this.myAspectRatio = this.myFullHeight == 0 ? 1.0 : (double)this.myFullWidth / (double)this.myFullHeight;
        return changed;
    }

    void updateSize() {
        boolean changed = this.computeFullSize();
        if (changed) {
            this.setMaxSize(this.myMaxWidth, this.myMaxHeight);
        }
    }

    public void setConfiguration(@NotNull Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/rendering/multi/RenderPreview", "setConfiguration"));
        }
        this.myConfiguration = configuration;
    }

    public double getScale() {
        return this.myScale;
    }

    public void setScale(double scale) {
    }

    public double getAspectRatio() {
        return this.myAspectRatio;
    }

    public boolean isActive() {
        return this.myActive;
    }

    public void setActive(boolean active) {
        this.myActive = active;
    }

    public boolean isVisible() {
        return this.myVisible;
    }

    public boolean isForked() {
        return this.myAlternateInput != null || this.myIncludedWithin != null;
    }

    @Nullable
    public VirtualFile getAlternateInput() {
        if (this.myAlternateInput != null) {
            return this.myAlternateInput;
        }
        if (this.myIncludedWithin != null) {
            return this.myIncludedWithin.getFromFile();
        }
        return null;
    }

    int getArea() {
        return this.myLayoutWidth * this.myLayoutHeight;
    }

    public void setVisible(boolean visible) {
        if (visible != this.myVisible) {
            this.myVisible = visible;
            if (this.myVisible) {
                if (this.myDirty != 0) {
                    this.configurationChanged(this.myDirty);
                } else {
                    this.updateForkStatus();
                    this.myManager.scheduleRender(this);
                }
            } else {
                this.dispose();
            }
        }
    }

    void setPosition(int x, int y) {
        this.myX = x;
        this.myY = y;
    }

    int getX() {
        return this.myX;
    }

    int getY() {
        return this.myY;
    }

    private void updateForkStatus() {
        AppResourceRepository resources;
        FolderConfiguration config = this.myConfiguration.getFullConfig();
        if (this.myAlternateInput != null && this.myConfiguration.isBestMatchFor(this.myAlternateInput, config)) {
            return;
        }
        this.myAlternateInput = null;
        VirtualFile editedFile = this.myConfiguration.getFile();
        if (editedFile != null && !this.myConfiguration.isBestMatchFor(editedFile, config) && (resources = AppResourceRepository.getAppResources(this.myConfiguration.getModule(), true)) != null) {
            VirtualFile best = resources.getMatchingFile(editedFile, ResourceType.LAYOUT, config);
            if (best != null) {
                this.myAlternateInput = best;
            }
            if (this.myAlternateInput != null) {
                this.myAlternateConfiguration = Configuration.create(this.myConfiguration, this.myAlternateInput);
            }
        }
    }

    @NotNull
    public static RenderPreview create(@NotNull RenderPreviewManager manager, @NotNull Configuration configuration, boolean showFrame) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/android/tools/idea/rendering/multi/RenderPreview", "create"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/rendering/multi/RenderPreview", "create"));
        }
        RenderContext context = manager.getRenderContext();
        RenderPreview renderPreview = new RenderPreview(manager, context, configuration, showFrame);
        if (renderPreview == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/multi/RenderPreview", "create"));
        }
        return renderPreview;
    }

    public void dispose() {
        this.disposeThumbnail();
        if (this != this.myManager.getStashedPreview()) {
            this.myConfiguration.dispose();
        }
    }

    void disposeThumbnail() {
        this.myThumbnail = null;
        this.myFullImage = null;
    }

    @NotNull
    public String getDisplayName() {
        if (this.myDisplayName == null) {
            String displayName = this.getConfiguration().getDisplayName();
            if (displayName == null) {
                if ("Original" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/multi/RenderPreview", "getDisplayName"));
                }
                return "Original";
            }
            String string = displayName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/multi/RenderPreview", "getDisplayName"));
            }
            return string;
        }
        String string = this.myDisplayName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/multi/RenderPreview", "getDisplayName"));
        }
        return string;
    }

    public void setDisplayName(@Nullable String displayName) {
        this.myDisplayName = displayName;
    }

    public void setIncludedWithin(@Nullable IncludeReference includedWithin) {
        this.myIncludedWithin = includedWithin;
    }

    void renderSync() {
        if (!this.tryRenderSync()) {
            this.disposeThumbnail();
        }
    }

    private boolean tryRenderSync() {
        RenderResult result;
        RenderSession session;
        PreviewRenderContext renderContext;
        Module module = this.myRenderContext.getModule();
        if (module == null) {
            return false;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return false;
        }
        Configuration configuration = this.myAlternateInput != null && this.myAlternateConfiguration != null ? this.myAlternateConfiguration : this.myConfiguration;
        Object psiFile = this.myAlternateInput != null ? AndroidPsiUtils.getPsiFileSafely(module.getProject(), this.myAlternateInput) : this.myRenderContext.getXmlFile();
        if (psiFile == null) {
            return false;
        }
        RenderLogger logger = new RenderLogger(psiFile.getName(), module);
        RenderService renderService = RenderService.create(facet, module, (PsiFile)psiFile, configuration, logger, renderContext = new PreviewRenderContext(this.myRenderContext, configuration, (XmlFile)psiFile));
        if (renderService == null) {
            return false;
        }
        if (this.myIncludedWithin != null) {
            renderService.setIncludedWithin(this.myIncludedWithin);
        }
        RenderSession renderSession = session = (result = renderService.render()) != null ? result.getSession() : null;
        if (session != null) {
            RenderedImage renderedImage;
            Result render = session.getResult();
            if (logger.hasProblems() || !session.getResult().isSuccess()) {
                RenderErrorPanel panel = new RenderErrorPanel();
                String html = panel.showErrors(result);
                LOG.info("Found problems rendering preview " + this.getDisplayName() + ": " + html);
            }
            if (render.isSuccess()) {
                this.myError = null;
            } else {
                this.myError = render.getErrorMessage();
                if (this.myError == null) {
                    this.myError = "<unknown error>";
                }
            }
            if (render.getStatus() == Result.Status.ERROR_TIMEOUT) {
                return false;
            }
            this.disposeThumbnail();
            if (render.isSuccess() && (renderedImage = result.getImage()) != null) {
                this.myFullImage = renderedImage.getOriginalImage();
            }
            if (this.myError != null) {
                this.createErrorThumbnail();
            }
            return true;
        }
        this.myError = "Render Failed";
        this.disposeThumbnail();
        this.createErrorThumbnail();
        return false;
    }

    @Nullable
    private BufferedImage getThumbnail() {
        if (this.myThumbnail == null && this.myFullImage != null) {
            this.createThumbnail();
        }
        return this.myThumbnail;
    }

    void createThumbnail() {
        BufferedImage image = this.myFullImage;
        if (image == null) {
            this.myThumbnail = null;
            return;
        }
        Project project = this.myConfiguration.getModule().getProject();
        AndroidEditorSettings.GlobalState settings = AndroidEditorSettings.getInstance().getGlobalState();
        if (UIUtil.isRetina() && ImageUtils.supportsRetina() && settings.isRetina() && this.createRetinaThumbnail()) {
            return;
        }
        int shadowSize = 0;
        this.myThumbnailHasFrame = false;
        boolean showFrame = this.myShowFrame;
        if (showFrame && settings.isShowDeviceFrames()) {
            DeviceArtPainter framePainter = DeviceArtPainter.getInstance();
            Device device = this.myConfiguration.getDevice();
            boolean showEffects = settings.isShowEffects();
            State deviceState = this.myConfiguration.getDeviceState();
            if (device != null && deviceState != null) {
                double scale = Math.min(1.0, (double)this.getLayoutWidth() / (double)image.getWidth());
                ScreenOrientation orientation = deviceState.getOrientation();
                double frameScale = framePainter.getFrameMaxOverhead(device, orientation);
                scale /= frameScale;
                if (this.myViewBounds == null) {
                    this.myViewBounds = new Rectangle();
                }
                image = framePainter.createFrame(image, device, orientation, showEffects, scale, this.myViewBounds);
                this.myThumbnailHasFrame = true;
            } else {
                double scale = Math.min(1.0, (double)this.getLayoutWidth() / (double)image.getWidth());
                image = ImageUtils.scale(image, scale, scale, 0, 0);
            }
        } else {
            boolean drawShadows = !this.myRenderContext.hasAlphaChannel();
            double scale = Math.min(1.0, (double)this.getLayoutWidth() / (double)image.getWidth());
            int n = shadowSize = drawShadows ? 10 : 0;
            if (scale < 1.0) {
                image = ImageUtils.scale(image, scale, scale, shadowSize, shadowSize);
                if (drawShadows) {
                    ShadowPainter.drawSmallRectangleShadow(image, 0, 0, image.getWidth() - shadowSize, image.getHeight() - shadowSize);
                }
            }
        }
        this.myThumbnail = image;
        if (image != null) {
            this.myLayoutWidth = image.getWidth() - shadowSize;
            this.myLayoutHeight = image.getHeight() - shadowSize;
        }
    }

    private boolean createRetinaThumbnail() {
        BufferedImage image = this.myFullImage;
        if (image == null) {
            this.myThumbnail = null;
            return true;
        }
        this.myThumbnailHasFrame = false;
        boolean showFrame = this.myShowFrame;
        AndroidEditorSettings.GlobalState settings = AndroidEditorSettings.getInstance().getGlobalState();
        if (showFrame && settings.isShowDeviceFrames()) {
            DeviceArtPainter framePainter = DeviceArtPainter.getInstance();
            Device device = this.myConfiguration.getDevice();
            boolean showEffects = settings.isShowEffects();
            State deviceState = this.myConfiguration.getDeviceState();
            if (device != null && deviceState != null) {
                double scale = (double)this.getLayoutWidth() / (double)image.getWidth();
                ScreenOrientation orientation = deviceState.getOrientation();
                double frameScale = framePainter.getFrameMaxOverhead(device, orientation);
                scale /= frameScale;
                if (this.myViewBounds == null) {
                    this.myViewBounds = new Rectangle();
                }
                image = framePainter.createFrame(image, device, orientation, showEffects, 2.0 * scale, this.myViewBounds);
                this.myViewBounds.x /= 2;
                this.myViewBounds.y /= 2;
                this.myViewBounds.width /= 2;
                this.myViewBounds.height /= 2;
                this.myThumbnailHasFrame = true;
            } else {
                double scale = (double)this.getLayoutWidth() / (double)image.getWidth();
                image = ImageUtils.scale(image, 2.0 * scale, 2.0 * scale, 0, 0);
            }
            image = ImageUtils.convertToRetina(image);
            if (image == null) {
                return false;
            }
        } else {
            boolean drawShadows = !this.myRenderContext.hasAlphaChannel();
            double scale = (double)this.getLayoutWidth() / (double)image.getWidth();
            if (scale < 1.0) {
                image = ImageUtils.scale(image, 2.0 * scale, 2.0 * scale);
                if ((image = ImageUtils.convertToRetina(image)) == null) {
                    return false;
                }
                this.myLayoutWidth = image.getWidth();
                this.myLayoutHeight = image.getHeight();
                if (drawShadows) {
                    image = ShadowPainter.createSmallRectangularDropShadow(image);
                }
                this.myThumbnail = image;
                return true;
            }
        }
        this.myThumbnail = image;
        this.myLayoutWidth = image.getWidth();
        this.myLayoutHeight = image.getHeight();
        return true;
    }

    void createErrorThumbnail() {
        boolean drawShadows;
        int width = this.getLayoutWidth();
        int height = this.getLayoutHeight();
        BufferedImage image = new BufferedImage(width + 10, height + 10, 2);
        Graphics2D g = image.createGraphics();
        g.setColor(new Color(-262970));
        g.fillRect(0, 0, width, height);
        g.dispose();
        boolean bl = drawShadows = !this.myRenderContext.hasAlphaChannel();
        if (drawShadows) {
            ShadowPainter.drawSmallRectangleShadow(image, 0, 0, image.getWidth() - 10, image.getHeight() - 10);
        }
        this.myThumbnail = image;
    }

    private static double getScale(int width, int height) {
        int maxWidth = RenderPreviewManager.getMaxWidth();
        int maxHeight = RenderPreviewManager.getMaxHeight();
        if (width > 0 && height > 0 && (width > maxWidth || height > maxHeight)) {
            if (width >= height) {
                return (double)maxWidth / (double)width;
            }
            return (double)maxHeight / (double)height;
        }
        return 1.0;
    }

    public int getWidth() {
        return (int)((double)this.myLayoutWidth * this.myScale * RenderPreviewManager.getScale());
    }

    public int getHeight() {
        return (int)((double)this.myLayoutHeight * this.myScale * RenderPreviewManager.getScale());
    }

    public int getLayoutWidth() {
        return this.myLayoutWidth;
    }

    public int getLayoutHeight() {
        return this.myLayoutHeight;
    }

    public boolean click(int x, int y) {
        if (y >= this.myTitleHeight && y < this.myTitleHeight + 20) {
            int left = 0;
            if (x <= (left += AllIcons.Actions.CloseNewHovered.getIconWidth())) {
                this.myManager.deletePreview(this);
                return true;
            }
            if (x <= (left += AllIcons.Actions.Edit.getIconWidth())) {
                Project project = this.myConfiguration.getConfigurationManager().getProject();
                String newName = Messages.showInputDialog((Project)project, (String)"Name:", (String)"Rename Preview", null, (String)this.myConfiguration.getDisplayName(), null);
                if (newName != null) {
                    this.myConfiguration.setDisplayName(newName);
                    this.myManager.redraw();
                }
                return true;
            }
        }
        this.myManager.switchTo(this);
        return true;
    }

    void paint(Graphics2D gc, int x, int y) {
        this.myTitleHeight = this.paintTitle(gc, x, y, true);
        y += this.myTitleHeight;
        y += 2;
        Component component = this.myRenderContext.getComponent();
        gc.setFont(UIUtil.getToolTipFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        int fontHeight = fontMetrics.getHeight();
        int fontBaseline = fontHeight - fontMetrics.getDescent();
        int width = this.getWidth();
        int height = this.getHeight();
        BufferedImage thumbnail = this.getThumbnail();
        if (thumbnail != null && this.myError == null) {
            UIUtil.drawImage((Graphics)gc, (Image)thumbnail, (int)x, (int)y, null);
            if (this.myActive) {
                int x1 = x;
                int y1 = y;
                int w = this.myLayoutWidth;
                int h = this.myLayoutHeight;
                if (this.myThumbnailHasFrame && this.myViewBounds != null) {
                    x1 = this.myViewBounds.x + x1;
                    y1 = this.myViewBounds.y + y1;
                    w = this.myViewBounds.width;
                    h = this.myViewBounds.height;
                }
                gc.setColor(new Color(181, 213, 255));
                if (HardwareConfigHelper.isRound((Device)this.myConfiguration.getDevice())) {
                    Stroke prevStroke = gc.getStroke();
                    gc.setStroke(new BasicStroke(3.0f));
                    Object prevAntiAlias = gc.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                    gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    Ellipse2D.Double ellipse = new Ellipse2D.Double(x1, y1, w, h);
                    gc.draw(ellipse);
                    gc.setStroke(prevStroke);
                    gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, prevAntiAlias);
                } else {
                    gc.drawRect(x1 - 1, y1 - 1, w + 1, h + 1);
                    gc.drawRect(x1 - 2, y1 - 2, w + 3, h + 3);
                    gc.drawRect(x1 - 3, y1 - 3, w + 5, h + 5);
                }
            }
        } else if (this.myError != null && !this.myError.isEmpty()) {
            if (thumbnail != null) {
                UIUtil.drawImage((Graphics)gc, (Image)thumbnail, (int)x, (int)y, null);
            } else {
                gc.setColor(Color.DARK_GRAY);
                gc.drawRect(x, y, width, height);
            }
            Shape prevClip = gc.getClip();
            gc.setClip(x, y, width, height);
            Icon icon = AndroidIcons.RenderError;
            icon.paintIcon(component, gc, x + (width - icon.getIconWidth()) / 2, y + (height - icon.getIconHeight()) / 2);
            Composite prevComposite = gc.getComposite();
            gc.setComposite(AlphaComposite.getInstance(3, 0.8f));
            gc.setColor(Color.WHITE);
            gc.fillRect(x, y, width, height);
            gc.setComposite(prevComposite);
            String msg = this.myError;
            Density density = this.myConfiguration.getDensity();
            if (density == Density.TV || density == Density.LOW) {
                msg = "Broken rendering library; unsupported DPI. Try using the SDK manager to get updated layout libraries.";
            }
            int charWidth = fontMetrics.charWidth('x');
            int charsPerLine = (width - 10) / charWidth;
            msg = SdkUtils.wrap((String)msg, (int)charsPerLine, null);
            gc.setColor(Color.BLACK);
            gc.setFont(UIUtil.getToolTipFont());
            UIUtil.applyRenderingHints((Graphics)gc);
            UIUtil.TextPainter painter = new UIUtil.TextPainter().withShadow(true).withLineSpacing(1.4f);
            for (String line : msg.split("\n")) {
                painter.appendLine(line);
            }
            final int xf = x + 5;
            final int yf = y + 20 + fontBaseline;
            painter.draw((Graphics)gc, (PairFunction)new PairFunction<Integer, Integer, Couple<Integer>>(){

                public Couple<Integer> fun(Integer width, Integer height) {
                    return Couple.of((Object)xf, (Object)yf);
                }
            });
            gc.setClip(prevClip);
        } else {
            gc.setColor(Color.DARK_GRAY);
            gc.drawRect(x, y, width, height);
            Icon icon = AndroidIcons.RefreshPreview;
            Composite prevComposite = gc.getComposite();
            gc.setComposite(AlphaComposite.getInstance(3, 0.35f));
            icon.paintIcon(component, gc, x + (width - icon.getIconWidth()) / 2, y + (height - icon.getIconHeight()) / 2);
            gc.setComposite(prevComposite);
        }
        if (this.myActive && !this.myShowFrame) {
            int left = x;
            Composite prevComposite = gc.getComposite();
            gc.setComposite(AlphaComposite.getInstance(3, 0.8f));
            gc.setColor(Color.WHITE);
            gc.fillRect(left, y, x + width - left, 20);
            AllIcons.Actions.CloseNewHovered.paintIcon(component, gc, left, y += 2);
            AllIcons.Actions.Edit.paintIcon(component, gc, left += AllIcons.Actions.CloseNewHovered.getIconWidth(), y);
            left += AllIcons.Actions.Edit.getIconWidth();
            gc.setComposite(prevComposite);
        }
    }

    private int paintTitle(Graphics2D gc, int x, int y, boolean showFile) {
        String displayName = this.getDisplayName();
        return this.paintTitle(gc, x, y, showFile, displayName);
    }

    int paintTitle(Graphics2D gc, int x, int y, boolean showFile, String displayName) {
        int titleHeight = 0;
        if (showFile && this.myIncludedWithin != null) {
            displayName = this.myManager.getMode() != RenderPreviewMode.INCLUDES ? "<include>" : null;
        }
        int labelTop = y + 1;
        Shape prevClip = gc.getClip();
        Rectangle clipBounds = prevClip.getBounds();
        int clipWidth = this.myMaxWidth > 0 ? this.myMaxWidth : this.myLayoutWidth;
        gc.setClip(x, labelTop, Math.min(clipWidth, clipBounds.x + clipBounds.width - x), Math.min(100, clipBounds.y + clipBounds.height - labelTop));
        gc.setFont(UIUtil.getToolTipFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        int fontHeight = fontMetrics.getHeight();
        int fontBaseline = fontHeight - fontMetrics.getDescent();
        if (displayName != null && displayName.length() > 0) {
            gc.setColor(Color.WHITE);
            Rectangle2D extent = fontMetrics.getStringBounds(displayName, gc);
            int labelLeft = Math.max(x, x + (this.myLayoutWidth - (int)extent.getWidth()) / 2);
            Icon icon = null;
            Locale locale = this.myConfiguration.getLocale();
            if ((locale.hasLanguage() || locale.hasRegion()) && (!(this.myConfiguration instanceof NestedConfiguration) || ((NestedConfiguration)this.myConfiguration).isOverridingLocale())) {
                icon = locale.getFlagImage();
            }
            if (icon != null) {
                int flagWidth = icon.getIconWidth();
                int flagHeight = icon.getIconHeight();
                labelLeft = Math.max(x + flagWidth / 2, labelLeft);
                icon.paintIcon(this.myRenderContext.getComponent(), gc, labelLeft - flagWidth / 2 - 1, labelTop + (fontHeight - flagHeight) / 2);
                gc.drawString(displayName, labelLeft += flagWidth / 2 + 1, labelTop - (fontHeight - flagHeight) / 2 + fontBaseline);
            } else {
                gc.drawString(displayName, labelLeft, labelTop + fontBaseline);
            }
            labelTop += (int)extent.getHeight();
            titleHeight += fontHeight;
        }
        if (showFile && (this.myAlternateInput != null || this.myIncludedWithin != null)) {
            VirtualFile file = this.myAlternateInput != null ? this.myAlternateInput : this.myIncludedWithin.getFromFile();
            String fileName = file.getParent().getName() + File.separator + file.getName();
            Rectangle2D extent = fontMetrics.getStringBounds(fileName, gc);
            Icon icon = AllIcons.FileTypes.Xml;
            int iconWidth = icon.getIconWidth();
            int iconHeight = icon.getIconHeight();
            int labelLeft = Math.max(x, x + (this.myLayoutWidth - (int)extent.getWidth() - iconWidth - 1) / 2);
            icon.paintIcon(this.myRenderContext.getComponent(), gc, labelLeft, labelTop);
            gc.setColor(Color.DARK_GRAY);
            gc.drawString(fileName, labelLeft += iconWidth + 1, (labelTop -= ((int)extent.getHeight() - iconHeight) / 2) + fontBaseline);
            titleHeight += Math.max(titleHeight, icon.getIconHeight());
        }
        gc.setClip(prevClip);
        return titleHeight;
    }

    public void configurationChanged(int flags) {
        if (!this.myVisible) {
            this.myDirty |= flags;
            return;
        }
        if ((flags & 0xFE) != 0) {
            this.updateForkStatus();
        }
        this.myDirty = 0;
        this.myManager.scheduleRender(this);
    }

    @NotNull
    public Configuration getConfiguration() {
        Configuration configuration = this.myConfiguration;
        if (configuration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/multi/RenderPreview", "getConfiguration"));
        }
        return configuration;
    }

    public void setAlternateInput(@Nullable VirtualFile file) {
        this.myAlternateInput = file;
    }

    public String toString() {
        return this.getDisplayName() + ':' + this.myConfiguration;
    }

    public void setMaxSize(int width, int height) {
        this.myMaxWidth = width;
        this.myMaxHeight = height;
        if (width == 0 || height == 0) {
            this.computeInitialSize();
        } else {
            double scale = Math.min(1.0, Math.min((double)width / (double)this.myFullWidth, (double)(height - 14) / (double)this.myFullHeight));
            this.myLayoutWidth = (int)((double)this.myFullWidth * scale);
            this.myLayoutHeight = (int)((double)this.myFullHeight * scale);
        }
        if (this.myThumbnail != null && Math.abs(this.myLayoutWidth - this.myThumbnail.getWidth() / 1) > 1) {
            this.myThumbnail = null;
        }
    }

    @Nullable
    public String getId() {
        return this.myId;
    }

    public void setId(@Nullable String id) {
        this.myId = id;
    }

    public int getMaxWidth() {
        return this.myMaxWidth;
    }

    public int getMaxHeight() {
        return this.myMaxHeight;
    }

    @Nullable
    public Runnable getPendingRendering() {
        return this.myPendingRendering;
    }

    public void setPendingRendering(@Nullable Runnable pendingRendering) {
        this.myPendingRendering = pendingRendering;
    }

    public boolean isShowFrame() {
        return this.myShowFrame;
    }

    public void setShowFrame(boolean showFrame) {
        this.myShowFrame = showFrame;
    }
}

