/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui;

import com.android.tools.idea.ui.WrapAwareColoredComponent;
import com.android.tools.idea.ui.WrapAwareLinkMouseListenerBase;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrapAwareTreeNodePartListener
extends WrapAwareLinkMouseListenerBase {
    private final TreeCellRenderer myRenderer;
    @Nullable
    private DefaultMutableTreeNode myLastHitNode;
    @Nullable
    private Component myRenderedComp;

    public WrapAwareTreeNodePartListener(@NotNull TreeCellRenderer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/android/tools/idea/ui/WrapAwareTreeNodePartListener", "<init>"));
        }
        this.myRenderer = renderer;
    }

    protected Object getTagAt(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/ui/WrapAwareTreeNodePartListener", "getTagAt"));
        }
        JTree tree = (JTree)e.getSource();
        TreePath path = tree.getPathForLocation(e.getX(), e.getY());
        if (path != null) {
            Rectangle bounds;
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (this.myLastHitNode != treeNode) {
                this.myLastHitNode = treeNode;
                this.myRenderedComp = this.myRenderer.getTreeCellRendererComponent(tree, treeNode, false, false, treeNode.isLeaf(), -1, false);
            }
            if (this.myRenderedComp != null && (bounds = tree.getPathBounds(path)) != null) {
                Component root = tree.getCellRenderer().getTreeCellRendererComponent(tree, treeNode, false, false, treeNode.isLeaf(), -1, false);
                root.setSize(bounds.getSize());
                root.doLayout();
                if (root instanceof WrapAwareColoredComponent) {
                    WrapAwareColoredComponent component = (WrapAwareColoredComponent)root;
                    int fragmentIndex = component.findFragmentAt(e.getX() - bounds.x, e.getY() - bounds.y);
                    return fragmentIndex >= 0 ? component.getFragmentTag(fragmentIndex) : null;
                }
            }
        }
        return null;
    }
}

