/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdListDialog;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunAndroidAvdManagerAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.actions.RunAndroidAvdManagerAction");
    private AvdListDialog myDialog;

    public RunAndroidAvdManagerAction() {
        super(RunAndroidAvdManagerAction.getName());
    }

    public RunAndroidAvdManagerAction(String name) {
        super(name);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/android/actions/RunAndroidAvdManagerAction", "update"));
        }
        Project project = e.getProject();
        e.getPresentation().setEnabledAndVisible(project != null && !ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID).isEmpty());
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        this.openAvdManager(project);
    }

    public void openAvdManager(@Nullable Project project) {
        this.myDialog = new AvdListDialog(project);
        this.myDialog.init();
        this.myDialog.show();
    }

    @Nullable
    public AvdInfo getSelected() {
        return this.myDialog.getSelected();
    }

    public static String getName() {
        return AndroidBundle.message("android.run.avd.manager.action.text", new Object[0]);
    }
}

