/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.ProjectRootManager;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.utils.ComboBoxUtil;

public class MavenJdkComboBox
extends JComboBox {
    private static final int MAX_PATH_LENGTH = 50;
    @Nullable
    private final Project myProject;

    public MavenJdkComboBox(@Nullable Project project) {
        this.myProject = project;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public void refreshData(@Nullable String selectedValue) {
        Map<String, String> jdkMap = this.collectJdkNamesAndDescriptions();
        if (selectedValue != null && !jdkMap.containsKey(selectedValue)) {
            assert (selectedValue.length() > 0);
            jdkMap.put(selectedValue, selectedValue);
        }
        this.removeAllItems();
        for (Map.Entry<String, String> entry : jdkMap.entrySet()) {
            ComboBoxUtil.addToModel((DefaultComboBoxModel)this.getModel(), entry.getKey(), entry.getValue());
        }
        ComboBoxUtil.select((DefaultComboBoxModel)this.getModel(), selectedValue);
    }

    public String getSelectedValue() {
        return ComboBoxUtil.getSelectedString((DefaultComboBoxModel)this.getModel());
    }

    private Map<String, String> collectJdkNamesAndDescriptions() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Object projectJdk : ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)JavaSdk.getInstance())) {
            String name = projectJdk.getName();
            String path = projectJdk.getHomePath();
            String label = path == null ? name : String.format("<html>%s <font color=gray>(%s)</font></html>", name, MavenJdkComboBox.truncateLongPath(path));
            result.put(name, label);
        }
        String internalJdkPath = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk().getHomePath();
        assert (internalJdkPath != null);
        result.put("#JAVA_INTERNAL", RunnerBundle.message("maven.java.internal", MavenJdkComboBox.truncateLongPath(internalJdkPath)));
        if (this.myProject != null) {
            Object projectJdk;
            projectJdk = ProjectRootManager.getInstance((Project)this.myProject).getProjectSdkName();
            String projectJdkTitle = String.format("<html>Use Project JDK <font color=gray>(%s)</font></html>", projectJdk == null ? "not defined yet" : projectJdk);
            result.put("#USE_PROJECT_JDK", projectJdkTitle);
        }
        String javaHomePath = System.getenv("JAVA_HOME");
        String javaHomeLabel = RunnerBundle.message("maven.java.home.env", javaHomePath == null ? "not defined yet" : MavenJdkComboBox.truncateLongPath(javaHomePath));
        result.put("#JAVA_HOME", javaHomeLabel);
        return result;
    }

    @NotNull
    private static String truncateLongPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/maven/execution/MavenJdkComboBox", "truncateLongPath"));
        }
        if (path.length() > 50) {
            String string = path.substring(0, 25) + "..." + path.substring(path.length() - 25 - 3);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/execution/MavenJdkComboBox", "truncateLongPath"));
            }
            return string;
        }
        String string = path;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/execution/MavenJdkComboBox", "truncateLongPath"));
        }
        return string;
    }
}

