/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.Profile;
import org.apache.maven.profiles.activation.DetectedProfileActivator;
import org.codehaus.plexus.interpolation.EnvarBasedValueSource;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;

public class MyFileProfileActivator
extends DetectedProfileActivator
implements LogEnabled {
    private Logger logger;
    private final File baseDir;

    public MyFileProfileActivator(File baseDir) {
        this.baseDir = baseDir;
    }

    protected boolean canDetectActivation(Profile profile) {
        return profile.getActivation() != null && profile.getActivation().getFile() != null;
    }

    public boolean isActive(Profile profile) {
        Activation activation = profile.getActivation();
        ActivationFile actFile = activation.getFile();
        if (actFile != null) {
            String fileString = actFile.getExists();
            RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
            try {
                interpolator.addValueSource((ValueSource)new EnvarBasedValueSource());
            }
            catch (IOException e) {
                // empty catch block
            }
            interpolator.addValueSource((ValueSource)new MapBasedValueSource((Map)System.getProperties()));
            try {
                if (StringUtils.isNotEmpty((String)fileString)) {
                    fileString = StringUtils.replace((String)interpolator.interpolate(fileString, ""), (String)"\\", (String)"/");
                    return this.fileExists(fileString);
                }
                fileString = actFile.getMissing();
                if (StringUtils.isNotEmpty((String)fileString)) {
                    return !this.fileExists(fileString = StringUtils.replace((String)interpolator.interpolate(fileString, ""), (String)"\\", (String)"/"));
                }
            }
            catch (InterpolationException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Failed to interpolate missing file location for profile activator: " + fileString, (Throwable)e);
                }
                this.logger.warn("Failed to interpolate missing file location for profile activator: " + fileString + ". Run in debug mode (-X) for more information.");
            }
        }
        return false;
    }

    private boolean fileExists(String path) {
        return new File(path).exists() || new File(this.baseDir, path).exists();
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }
}

