/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import gnu.trove.THashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="LastSelectedPropertiesFileStore", storages={@Storage(file="$APP_CONFIG$/other.xml")})
public class LastSelectedPropertiesFileStore
implements PersistentStateComponent<Element> {
    private final Map<String, String> lastSelectedUrls = new THashMap();
    private String lastSelectedFileUrl;
    @NonNls
    private static final String PROPERTIES_FILE_STATISTICS_KEY = "PROPERTIES_FILE";

    public static LastSelectedPropertiesFileStore getInstance() {
        return (LastSelectedPropertiesFileStore)ServiceManager.getService(LastSelectedPropertiesFileStore.class);
    }

    @Nullable
    public String suggestLastSelectedPropertiesFileUrl(PsiFile context) {
        for (VirtualFile virtualFile = context.getVirtualFile(); virtualFile != null; virtualFile = virtualFile.getParent()) {
            String contextUrl = virtualFile.getUrl();
            String url = this.lastSelectedUrls.get(contextUrl);
            if (url == null) continue;
            return url;
        }
        if (this.lastSelectedFileUrl != null) {
            VirtualFile lastFile = VirtualFileManager.getInstance().findFileByUrl(this.lastSelectedFileUrl);
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)context.getProject()).getFileIndex();
            if (lastFile != null && ModuleUtilCore.findModuleForPsiElement((PsiElement)context) == fileIndex.getModuleForFile(lastFile)) {
                return this.lastSelectedFileUrl;
            }
        }
        return null;
    }

    public static int getUseCount(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/properties/LastSelectedPropertiesFileStore", "getUseCount"));
        }
        return StatisticsManager.getInstance().getUseCount(new StatisticsInfo(PROPERTIES_FILE_STATISTICS_KEY, path));
    }

    public void saveLastSelectedPropertiesFile(PsiFile context, PropertiesFile file) {
        VirtualFile virtualFile = context.getVirtualFile();
        if (virtualFile instanceof VirtualFileWindow) {
            virtualFile = ((VirtualFileWindow)virtualFile).getDelegate();
        }
        assert (virtualFile != null);
        String contextUrl = virtualFile.getUrl();
        VirtualFile vFile = file.getVirtualFile();
        if (vFile != null) {
            String url = vFile.getUrl();
            this.lastSelectedUrls.put(contextUrl, url);
            VirtualFile containingDir = virtualFile.getParent();
            this.lastSelectedUrls.put(containingDir.getUrl(), url);
            this.lastSelectedFileUrl = url;
            StatisticsManager.getInstance().incUseCount(new StatisticsInfo(PROPERTIES_FILE_STATISTICS_KEY, FileUtil.toSystemDependentName((String)VfsUtil.urlToPath((String)url))));
        }
    }

    private void readExternal(@NonNls Element element) {
        this.lastSelectedUrls.clear();
        List list = element.getChildren("entry");
        for (Object o : list) {
            Element child = (Element)o;
            String context = child.getAttributeValue("context");
            String url = child.getAttributeValue("url");
            VirtualFile propFile = VirtualFileManager.getInstance().findFileByUrl(url);
            VirtualFile contextFile = VirtualFileManager.getInstance().findFileByUrl(context);
            if (propFile == null || contextFile == null) continue;
            this.lastSelectedUrls.put(context, url);
        }
        this.lastSelectedFileUrl = element.getAttributeValue("lastSelectedFileUrl");
    }

    private void writeExternal(@NonNls Element element) {
        for (Map.Entry<String, String> entry : this.lastSelectedUrls.entrySet()) {
            String context = entry.getKey();
            String url = entry.getValue();
            Element child = new Element("entry");
            child.setAttribute("context", context);
            child.setAttribute("url", url);
            element.addContent(child);
        }
        if (this.lastSelectedFileUrl != null) {
            element.setAttribute("lastSelectedFileUrl", this.lastSelectedFileUrl);
        }
    }

    public Element getState() {
        Element e = new Element("state");
        this.writeExternal(e);
        return e;
    }

    public void loadState(Element state) {
        this.readExternal(state);
    }
}

