/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.PlatformUtils;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EncodingEnvironmentUtil {
    private static final Logger LOG = Logger.getInstance(EncodingEnvironmentUtil.class);
    private static final String LC_ALL = "LC_ALL";
    private static final String LC_CTYPE = "LC_CTYPE";
    private static final String LANG = "LANG";

    public static void setLocaleEnvironmentIfMac(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/configurations/EncodingEnvironmentUtil", "setLocaleEnvironmentIfMac"));
        }
        if (SystemInfo.isMac && !EncodingEnvironmentUtil.isLocaleDefined(commandLine)) {
            EncodingEnvironmentUtil.setLocaleEnvironment(commandLine.getEnvironment(), commandLine.getCharset());
        }
    }

    @Deprecated
    public static void fixDefaultEncodingIfMac(@NotNull GeneralCommandLine commandLine, @Nullable Project project) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/configurations/EncodingEnvironmentUtil", "fixDefaultEncodingIfMac"));
        }
        if (SystemInfo.isMac && !EncodingEnvironmentUtil.isLocaleDefined(commandLine)) {
            EncodingEnvironmentUtil.setLocaleEnvironment(commandLine.getEnvironment(), EncodingEnvironmentUtil.getCharset(project));
        }
    }

    private static void setLocaleEnvironment(@NotNull Map<String, String> env, @NotNull Charset charset) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/execution/configurations/EncodingEnvironmentUtil", "setLocaleEnvironment"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/execution/configurations/EncodingEnvironmentUtil", "setLocaleEnvironment"));
        }
        env.put(LC_CTYPE, EncodingEnvironmentUtil.formatLocaleValue(charset));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fixed mac locale: " + charset.name());
        }
    }

    @NotNull
    private static String formatLocaleValue(@NotNull Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/execution/configurations/EncodingEnvironmentUtil", "formatLocaleValue"));
        }
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        String country = locale.getCountry();
        if (language.isEmpty() || country.isEmpty()) {
            String string = "en_US." + charset.name();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/EncodingEnvironmentUtil", "formatLocaleValue"));
            }
            return string;
        }
        String string = language + "_" + country + "." + charset.name();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/EncodingEnvironmentUtil", "formatLocaleValue"));
        }
        return string;
    }

    @Deprecated
    public static void fixDefaultEncodingIfMac(@NotNull Map<String, String> env, @Nullable Project project) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/execution/configurations/EncodingEnvironmentUtil", "fixDefaultEncodingIfMac"));
        }
        if (SystemInfo.isMac && !EncodingEnvironmentUtil.isLocaleDefined(env)) {
            EncodingEnvironmentUtil.setLocaleEnvironment(env, EncodingEnvironmentUtil.getCharset(project));
        }
    }

    public static void setLocaleEnvironmentIfMac(@NotNull Map<String, String> env, @NotNull Charset charset) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/execution/configurations/EncodingEnvironmentUtil", "setLocaleEnvironmentIfMac"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/execution/configurations/EncodingEnvironmentUtil", "setLocaleEnvironmentIfMac"));
        }
        if (SystemInfo.isMac && !EncodingEnvironmentUtil.isLocaleDefined(env)) {
            EncodingEnvironmentUtil.setLocaleEnvironment(env, charset);
        }
    }

    private static boolean isLocaleDefined(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/configurations/EncodingEnvironmentUtil", "isLocaleDefined"));
        }
        Map<String, String> env = commandLine.getEnvironment();
        if (EncodingEnvironmentUtil.isLocaleDefined(env)) {
            return true;
        }
        if (commandLine.isPassParentEnvironment()) {
            Map parentEnv;
            Map map = parentEnv = PlatformUtils.isAppCode() ? System.getenv() : EnvironmentUtil.getEnvironmentMap();
            if (EncodingEnvironmentUtil.isLocaleDefined(parentEnv)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isLocaleDefined(@NotNull Map<String, String> env) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/execution/configurations/EncodingEnvironmentUtil", "isLocaleDefined"));
        }
        return env.containsKey(LC_ALL) || env.containsKey(LC_CTYPE) || env.containsKey(LANG);
    }

    @NotNull
    private static Charset getCharset(@Nullable Project project) {
        Charset charset = null;
        if (project != null) {
            charset = EncodingProjectManager.getInstance(project).getDefaultCharset();
        }
        if (charset == null) {
            charset = EncodingManager.getInstance().getDefaultCharset();
        }
        if (charset == null) {
            charset = CharsetToolkit.UTF8_CHARSET;
        }
        Charset charset2 = charset;
        if (charset2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/EncodingEnvironmentUtil", "getCharset"));
        }
        return charset2;
    }
}

