/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.CustomFoldingProvider;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomFoldingSurroundDescriptor
implements SurroundDescriptor {
    public static final CustomFoldingSurroundDescriptor INSTANCE = new CustomFoldingSurroundDescriptor();
    public static final CustomFoldingRegionSurrounder[] SURROUNDERS;
    private static final String DEFAULT_DESC_TEXT = "Description";

    @Override
    @NotNull
    public PsiElement[] getElementsToSurround(PsiFile file, int startOffset, int endOffset) {
        PsiElement endElement;
        if (startOffset >= endOffset) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor", "getElementsToSurround"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(file.getLanguage());
        if (commenter == null || commenter.getLineCommentPrefix() == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor", "getElementsToSurround"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement startElement = file.findElementAt(startOffset);
        if (startElement instanceof PsiWhiteSpace) {
            startElement = startElement.getNextSibling();
        }
        if ((endElement = file.findElementAt(endOffset - 1)) instanceof PsiWhiteSpace) {
            endElement = endElement.getPrevSibling();
        }
        if (startElement != null && endElement != null && (startElement = CustomFoldingSurroundDescriptor.findClosestParentAfterLineBreak(startElement)) != null && (endElement = CustomFoldingSurroundDescriptor.findClosestParentBeforeLineBreak(endElement)) != null) {
            PsiElement[] psiElementArray = CustomFoldingSurroundDescriptor.adjustRange(startElement, endElement);
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor", "getElementsToSurround"));
            }
            return psiElementArray;
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor", "getElementsToSurround"));
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @NotNull
    private static PsiElement[] adjustRange(@NotNull PsiElement start, @NotNull PsiElement end) {
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor", "adjustRange"));
        }
        if (end == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "end", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor", "adjustRange"));
        }
        PsiElement newStart = CustomFoldingSurroundDescriptor.lowerStartElementIfNeeded(start, end);
        PsiElement newEnd = CustomFoldingSurroundDescriptor.lowerEndElementIfNeeded(start, end);
        if (newStart == null || newEnd == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor", "adjustRange"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement commonParent = CustomFoldingSurroundDescriptor.findCommonAncestorForWholeRange(newStart, newEnd);
        if (commonParent != null) {
            PsiElement[] psiElementArray = new PsiElement[]{commonParent};
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor", "adjustRange"));
            }
            return psiElementArray;
        }
        if (newStart.getParent().getFirstChild() == newStart && newStart.getFirstChild() == null) {
            newStart = newStart.getParent();
        }
        if (newEnd.getParent().getLastChild() == newEnd && newEnd.getFirstChild() == null) {
            newEnd = newEnd.getParent();
        }
        if (newStart.getParent() == newEnd.getParent()) {
            PsiElement[] psiElementArray = new PsiElement[]{newStart, newEnd};
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor", "adjustRange"));
            }
            return psiElementArray;
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor", "adjustRange"));
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Nullable
    private static PsiElement lowerEndElementIfNeeded(@NotNull PsiElement start, @NotNull PsiElement end) {
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor", "lowerEndElementIfNeeded"));
        }
        if (end == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "end", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor", "lowerEndElementIfNeeded"));
        }
        if (PsiTreeUtil.isAncestor(end, start, true)) {
            PsiElement lastChild;
            for (lastChild = end.getLastChild(); lastChild != null && lastChild.getParent() != start.getParent(); lastChild = lastChild.getLastChild()) {
            }
            return lastChild;
        }
        return end;
    }

    @Nullable
    private static PsiElement lowerStartElementIfNeeded(@NotNull PsiElement start, @NotNull PsiElement end) {
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor", "lowerStartElementIfNeeded"));
        }
        if (end == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "end", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor", "lowerStartElementIfNeeded"));
        }
        if (PsiTreeUtil.isAncestor(start, end, true)) {
            PsiElement firstChild;
            for (firstChild = start.getFirstChild(); firstChild != null && firstChild.getParent() != end.getParent(); firstChild = firstChild.getFirstChild()) {
            }
            return firstChild;
        }
        return start;
    }

    @Nullable
    private static PsiElement findCommonAncestorForWholeRange(@NotNull PsiElement start, @NotNull PsiElement end) {
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor", "findCommonAncestorForWholeRange"));
        }
        if (end == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "end", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor", "findCommonAncestorForWholeRange"));
        }
        PsiElement parent = PsiTreeUtil.findCommonParent(start, end);
        if (parent == null) {
            return null;
        }
        TextRange parentRange = parent.getTextRange();
        if (parentRange.getStartOffset() == start.getTextRange().getStartOffset() && parentRange.getEndOffset() == end.getTextRange().getEndOffset()) {
            return parent;
        }
        return null;
    }

    @Nullable
    private static PsiElement findClosestParentAfterLineBreak(PsiElement element) {
        for (PsiElement parent = element; parent != null && !(parent instanceof PsiFileSystemItem); parent = parent.getParent()) {
            PsiElement prev;
            for (prev = parent.getPrevSibling(); prev != null && prev.getTextLength() <= 0; prev = prev.getPrevSibling()) {
            }
            if (CustomFoldingSurroundDescriptor.firstElementInFile(parent)) {
                return parent.getContainingFile();
            }
            if (!CustomFoldingSurroundDescriptor.isWhiteSpaceWithLineFeed(prev)) continue;
            return parent;
        }
        return null;
    }

    private static boolean firstElementInFile(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor", "firstElementInFile"));
        }
        return element.getTextOffset() == 0;
    }

    @Nullable
    private static PsiElement findClosestParentBeforeLineBreak(PsiElement element) {
        for (PsiElement parent = element; parent != null && !(parent instanceof PsiFileSystemItem); parent = parent.getParent()) {
            PsiElement next = parent.getNextSibling();
            if (CustomFoldingSurroundDescriptor.lastElementInFile(parent)) {
                return parent.getContainingFile();
            }
            if (!CustomFoldingSurroundDescriptor.isWhiteSpaceWithLineFeed(next)) continue;
            return parent;
        }
        return null;
    }

    private static boolean lastElementInFile(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor", "lastElementInFile"));
        }
        return element.getTextRange().getEndOffset() == element.getContainingFile().getTextRange().getEndOffset();
    }

    private static boolean isWhiteSpaceWithLineFeed(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        if (element instanceof PsiWhiteSpace) {
            return element.textContains('\n');
        }
        ASTNode node = element.getNode();
        if (node == null) {
            return false;
        }
        CharSequence text = node.getChars();
        boolean lineFeedFound = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!StringUtil.isWhiteSpace((char)c)) {
                return false;
            }
            lineFeedFound |= c == '\n';
        }
        return lineFeedFound;
    }

    @Override
    @NotNull
    public Surrounder[] getSurrounders() {
        if (SURROUNDERS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor", "getSurrounders"));
        }
        return SURROUNDERS;
    }

    @Override
    public boolean isExclusive() {
        return false;
    }

    static {
        ArrayList<CustomFoldingRegionSurrounder> surrounderList = new ArrayList<CustomFoldingRegionSurrounder>();
        for (CustomFoldingProvider provider : CustomFoldingProvider.getAllProviders()) {
            surrounderList.add(new CustomFoldingRegionSurrounder(provider));
        }
        SURROUNDERS = surrounderList.toArray(new CustomFoldingRegionSurrounder[surrounderList.size()]);
    }

    private static class CustomFoldingRegionSurrounder
    implements Surrounder {
        private final CustomFoldingProvider myProvider;

        public CustomFoldingRegionSurrounder(@NotNull CustomFoldingProvider provider) {
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor$CustomFoldingRegionSurrounder", "<init>"));
            }
            this.myProvider = provider;
        }

        @Override
        public String getTemplateDescription() {
            return this.myProvider.getDescription();
        }

        @Override
        public boolean isApplicable(@NotNull PsiElement[] elements) {
            if (elements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor$CustomFoldingRegionSurrounder", "isApplicable"));
            }
            if (elements.length == 0) {
                return false;
            }
            for (FoldingBuilder each : LanguageFolding.INSTANCE.allForLanguage(elements[0].getLanguage())) {
                if (!(each instanceof CustomFoldingBuilder)) continue;
                return true;
            }
            return false;
        }

        @Override
        public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement[] elements) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor$CustomFoldingRegionSurrounder", "surroundElements"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor$CustomFoldingRegionSurrounder", "surroundElements"));
            }
            if (elements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor$CustomFoldingRegionSurrounder", "surroundElements"));
            }
            if (elements.length == 0) {
                return null;
            }
            PsiElement firstElement = elements[0];
            PsiElement lastElement = elements[elements.length - 1];
            PsiFile psiFile = firstElement.getContainingFile();
            Language language = psiFile.getLanguage();
            Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
            if (commenter == null) {
                return null;
            }
            String linePrefix = commenter.getLineCommentPrefix();
            if (linePrefix == null) {
                return null;
            }
            int prefixLength = linePrefix.length();
            int startOffset = firstElement.getTextRange().getStartOffset();
            Document document = editor.getDocument();
            int startLineNumber = document.getLineNumber(startOffset);
            String startIndent = document.getText(new TextRange(document.getLineStartOffset(startLineNumber), startOffset));
            int endOffset = lastElement.getTextRange().getEndOffset();
            int delta = 0;
            TextRange rangeToSelect = new TextRange(startOffset, startOffset);
            String startText = this.myProvider.getStartString();
            int descPos = startText.indexOf("?");
            if (descPos >= 0) {
                startText = startText.replace("?", CustomFoldingSurroundDescriptor.DEFAULT_DESC_TEXT);
                rangeToSelect = new TextRange(startOffset + descPos, startOffset + descPos + CustomFoldingSurroundDescriptor.DEFAULT_DESC_TEXT.length());
            }
            String startString = linePrefix + startText + "\n" + startIndent;
            String endString = "\n" + linePrefix + this.myProvider.getEndString();
            document.insertString(endOffset, endString);
            delta += endString.length();
            document.insertString(startOffset, startString);
            rangeToSelect = rangeToSelect.shiftRight(prefixLength);
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance(project);
            documentManager.commitDocument(documentManager.getDocument(psiFile));
            CustomFoldingRegionSurrounder.adjustLineIndent(project, psiFile, language, new TextRange(endOffset + (delta += startString.length()) - endString.length(), endOffset + delta));
            CustomFoldingRegionSurrounder.adjustLineIndent(project, psiFile, language, new TextRange(startOffset, startOffset + startString.length()));
            return rangeToSelect;
        }

        private static void adjustLineIndent(@NotNull Project project, PsiFile file, Language language, TextRange range) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/folding/CustomFoldingSurroundDescriptor$CustomFoldingRegionSurrounder", "adjustLineIndent"));
            }
            CommonCodeStyleSettings formatSettings = CodeStyleSettingsManager.getSettings(project).getCommonSettings(language);
            boolean keepAtFirstCol = formatSettings.KEEP_FIRST_COLUMN_COMMENT;
            formatSettings.KEEP_FIRST_COLUMN_COMMENT = false;
            CodeStyleManager.getInstance(project).adjustLineIndent(file, range);
            formatSettings.KEEP_FIRST_COLUMN_COMMENT = keepAtFirstCol;
        }
    }
}

