/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.util.ReflectionUtil;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ActionGroup
extends AnAction {
    private boolean myPopup;
    private final PropertyChangeSupport myChangeSupport = new PropertyChangeSupport(this);
    public static final ActionGroup EMPTY_GROUP = new ActionGroup(){

        @Override
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/ActionGroup$1", "getChildren"));
            }
            return EMPTY_ARRAY;
        }
    };
    private Set<AnAction> mySecondaryActions;
    @NonNls
    public static final String PROP_POPUP = "popup";
    private Boolean myDumbAware;

    public ActionGroup() {
        this(null, false);
    }

    public ActionGroup(String shortName, boolean popup) {
        super(shortName);
        this.setPopup(popup);
    }

    public ActionGroup(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
    }

    public boolean canBePerformed(DataContext context) {
        return false;
    }

    public boolean isPopup() {
        return this.myPopup;
    }

    public final void setPopup(boolean popup) {
        boolean oldPopup = this.myPopup;
        this.myPopup = popup;
        this.firePropertyChange(PROP_POPUP, oldPopup ? Boolean.TRUE : Boolean.FALSE, this.myPopup ? Boolean.TRUE : Boolean.FALSE);
    }

    public final void addPropertyChangeListener(PropertyChangeListener l) {
        this.myChangeSupport.addPropertyChangeListener(l);
    }

    public final void removePropertyChangeListener(PropertyChangeListener l) {
        this.myChangeSupport.removePropertyChangeListener(l);
    }

    protected final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.myChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    @NotNull
    public abstract AnAction[] getChildren(@Nullable AnActionEvent var1);

    final void setAsPrimary(AnAction action, boolean isPrimary) {
        if (isPrimary) {
            if (this.mySecondaryActions != null) {
                this.mySecondaryActions.remove(action);
            }
        } else {
            if (this.mySecondaryActions == null) {
                this.mySecondaryActions = new HashSet<AnAction>();
            }
            this.mySecondaryActions.add(action);
        }
    }

    public final boolean isPrimary(AnAction action) {
        return this.mySecondaryActions == null || !this.mySecondaryActions.contains(action);
    }

    protected final void replace(AnAction originalAction, AnAction newAction) {
        if (this.mySecondaryActions != null && this.mySecondaryActions.contains(originalAction)) {
            this.mySecondaryActions.remove(originalAction);
            this.mySecondaryActions.add(newAction);
        }
    }

    @Override
    public boolean isDumbAware() {
        if (this.myDumbAware != null) {
            return this.myDumbAware;
        }
        boolean dumbAware = super.isDumbAware();
        if (dumbAware) {
            this.myDumbAware = Boolean.TRUE;
        } else if (this.myDumbAware == null) {
            Class declaringClass = ReflectionUtil.getMethodDeclaringClass(this.getClass(), (String)"update", (Class[])new Class[]{AnActionEvent.class});
            this.myDumbAware = AnAction.class.equals((Object)declaringClass) || ActionGroup.class.equals((Object)declaringClass);
        }
        return this.myDumbAware;
    }

    public boolean hideIfNoVisibleChildren() {
        return false;
    }

    public boolean disableIfNoVisibleChildren() {
        return true;
    }
}

