/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.LibrariesHelper;
import com.intellij.openapi.util.io.JarUtil;
import com.intellij.openapi.vfs.JarFile;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarVersionDetectionUtil {
    private JarVersionDetectionUtil() {
    }

    @Nullable
    public static String detectJarVersion(@NotNull String detectionClass, @NotNull Module module) {
        if (detectionClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detectionClass", "com/intellij/openapi/roots/libraries/JarVersionDetectionUtil", "detectJarVersion"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/libraries/JarVersionDetectionUtil", "detectJarVersion"));
        }
        for (OrderEntry library : ModuleRootManager.getInstance(module).getOrderEntries()) {
            VirtualFile jar;
            if (!(library instanceof LibraryOrderEntry) || (jar = LibrariesHelper.getInstance().findJarByClass(((LibraryOrderEntry)library).getLibrary(), detectionClass)) == null || !(jar.getFileSystem() instanceof JarFileSystem)) continue;
            return JdkUtil.getJarMainAttribute(jar, Attributes.Name.IMPLEMENTATION_VERSION);
        }
        return null;
    }

    @Nullable
    public static String detectJarVersion(@NotNull String detectionClass, @NotNull List<VirtualFile> files) {
        if (detectionClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detectionClass", "com/intellij/openapi/roots/libraries/JarVersionDetectionUtil", "detectJarVersion"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/roots/libraries/JarVersionDetectionUtil", "detectJarVersion"));
        }
        VirtualFile jarRoot = LibrariesHelper.getInstance().findRootByClass(files, detectionClass);
        return jarRoot != null && jarRoot.getFileSystem() instanceof JarFileSystem ? JdkUtil.getJarMainAttribute(jarRoot, Attributes.Name.IMPLEMENTATION_VERSION) : null;
    }

    public static String detectJarVersion(@Nullable JarFile zipFile) {
        if (zipFile == null) {
            return null;
        }
        try {
            JarFile.JarEntry zipEntry = zipFile.getEntry("META-INF/MANIFEST.MF");
            if (zipEntry == null) {
                return null;
            }
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            Manifest manifest = new Manifest(inputStream);
            Attributes attributes = manifest.getMainAttributes();
            return attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nullable
    public static String getBundleVersion(@NotNull File jar) {
        if (jar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jar", "com/intellij/openapi/roots/libraries/JarVersionDetectionUtil", "getBundleVersion"));
        }
        return JarUtil.getJarAttribute((File)jar, (Attributes.Name)new Attributes.Name("Bundle-Version"));
    }

    @Nullable
    public static String getImplementationVersion(@NotNull File jar) {
        if (jar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jar", "com/intellij/openapi/roots/libraries/JarVersionDetectionUtil", "getImplementationVersion"));
        }
        return JarUtil.getJarAttribute((File)jar, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
    }

    public static String getJarAttributeVersion(@NotNull File jar, @NotNull Attributes.Name attribute, @Nullable String entryName) {
        if (jar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jar", "com/intellij/openapi/roots/libraries/JarVersionDetectionUtil", "getJarAttributeVersion"));
        }
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/openapi/roots/libraries/JarVersionDetectionUtil", "getJarAttributeVersion"));
        }
        return entryName != null ? JarUtil.getJarAttribute((File)jar, (String)entryName, (Attributes.Name)attribute) : JarUtil.getJarAttribute((File)jar, (Attributes.Name)attribute);
    }
}

