/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.net.HttpConfigurable;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpRequests {
    private static final boolean ourWrapClassLoader = SystemInfo.isJavaVersionAtLeast((String)"1.7") && !SystemProperties.getBooleanProperty((String)"idea.parallel.class.loader", (boolean)true);

    @NotNull
    public static RequestBuilder request(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/io/HttpRequests", "request"));
        }
        RequestBuilder requestBuilder = new RequestBuilder(url);
        if (requestBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/HttpRequests", "request"));
        }
        return requestBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T wrapAndProcess(RequestBuilder builder, RequestProcessor<T> processor) throws IOException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(new URLClassLoader(new URL[0], oldClassLoader));
        try {
            T t = HttpRequests.process(builder, processor);
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T process(RequestBuilder builder, RequestProcessor<T> processor) throws IOException {
        class RequestImpl
        implements Request {
            private URLConnection myConnection;
            private InputStream myInputStream;
            final /* synthetic */ RequestBuilder val$builder;

            RequestImpl(RequestBuilder requestBuilder) {
                this.val$builder = requestBuilder;
            }

            @Override
            @NotNull
            public URLConnection getConnection() throws IOException {
                if (this.myConnection == null) {
                    this.myConnection = HttpRequests.openConnection(this.val$builder);
                }
                URLConnection uRLConnection = this.myConnection;
                if (uRLConnection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/HttpRequests$1RequestImpl", "getConnection"));
                }
                return uRLConnection;
            }

            @Override
            @NotNull
            public InputStream getInputStream() throws IOException {
                if (this.myInputStream == null) {
                    this.myInputStream = this.getConnection().getInputStream();
                    if (this.val$builder.myGzip && "gzip".equalsIgnoreCase(this.getConnection().getContentEncoding())) {
                        this.myInputStream = new GZIPInputStream(this.myInputStream);
                    }
                }
                InputStream inputStream = this.myInputStream;
                if (inputStream == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/HttpRequests$1RequestImpl", "getInputStream"));
                }
                return inputStream;
            }

            private void cleanup() throws IOException {
                if (this.myInputStream != null) {
                    this.myInputStream.close();
                }
                if (this.myConnection instanceof HttpURLConnection) {
                    ((HttpURLConnection)this.myConnection).disconnect();
                }
            }
        }
        RequestImpl request = new RequestImpl(builder);
        try {
            T t = processor.process(request);
            return t;
        }
        finally {
            request.cleanup();
        }
    }

    private static URLConnection openConnection(RequestBuilder builder) throws IOException {
        String url = builder.myUrl;
        if (builder.myForceHttps && StringUtil.startsWith((CharSequence)url, (CharSequence)"http:")) {
            url = "https:" + url.substring(5);
        }
        for (int i = 0; i < builder.myRedirectLimit; ++i) {
            int responseCode;
            URLConnection connection = ApplicationManager.getApplication() == null ? new URL(url).openConnection() : HttpConfigurable.getInstance().openConnection(url);
            connection.setConnectTimeout(builder.myConnectTimeout);
            connection.setReadTimeout(builder.myTimeout);
            if (builder.myUserAgent != null) {
                connection.setRequestProperty("User-Agent", builder.myUserAgent);
            }
            if (builder.myHostnameVerifier != null && connection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)connection).setHostnameVerifier(builder.myHostnameVerifier);
            }
            if (builder.myGzip) {
                connection.setRequestProperty("Accept-Encoding", "gzip");
            }
            connection.setUseCaches(false);
            if (connection instanceof HttpURLConnection && (responseCode = ((HttpURLConnection)connection).getResponseCode()) != 200 && responseCode != 304) {
                ((HttpURLConnection)connection).disconnect();
                if ((responseCode == 301 || responseCode == 302) && (url = connection.getHeaderField("Location")) != null) continue;
                throw new IOException(IdeBundle.message("error.connection.failed.with.http.code.N", responseCode));
            }
            return connection;
        }
        throw new IOException(IdeBundle.message("error.connection.failed.redirects", new Object[0]));
    }

    public static class RequestBuilder {
        private final String myUrl;
        private int myConnectTimeout;
        private int myTimeout;
        private int myRedirectLimit;
        private boolean myGzip;
        private boolean myForceHttps;
        private HostnameVerifier myHostnameVerifier;
        private String myUserAgent;

        private RequestBuilder(@NotNull String url) {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/io/HttpRequests$RequestBuilder", "<init>"));
            }
            this.myConnectTimeout = HttpConfigurable.CONNECTION_TIMEOUT;
            this.myTimeout = HttpConfigurable.READ_TIMEOUT;
            this.myRedirectLimit = HttpConfigurable.REDIRECT_LIMIT;
            this.myGzip = true;
            this.myUrl = url;
        }

        @NotNull
        public RequestBuilder connectTimeout(int value) {
            this.myConnectTimeout = value;
            RequestBuilder requestBuilder = this;
            if (requestBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/HttpRequests$RequestBuilder", "connectTimeout"));
            }
            return requestBuilder;
        }

        @NotNull
        public RequestBuilder readTimeout(int value) {
            this.myTimeout = value;
            RequestBuilder requestBuilder = this;
            if (requestBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/HttpRequests$RequestBuilder", "readTimeout"));
            }
            return requestBuilder;
        }

        @NotNull
        public RequestBuilder redirectLimit(int redirectLimit) {
            this.myRedirectLimit = redirectLimit;
            RequestBuilder requestBuilder = this;
            if (requestBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/HttpRequests$RequestBuilder", "redirectLimit"));
            }
            return requestBuilder;
        }

        @NotNull
        public RequestBuilder gzip(boolean value) {
            this.myGzip = value;
            RequestBuilder requestBuilder = this;
            if (requestBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/HttpRequests$RequestBuilder", "gzip"));
            }
            return requestBuilder;
        }

        @NotNull
        public RequestBuilder forceHttps(boolean forceHttps) {
            this.myForceHttps = forceHttps;
            RequestBuilder requestBuilder = this;
            if (requestBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/HttpRequests$RequestBuilder", "forceHttps"));
            }
            return requestBuilder;
        }

        @NotNull
        public RequestBuilder hostNameVerifier(@Nullable HostnameVerifier hostnameVerifier) {
            this.myHostnameVerifier = hostnameVerifier;
            RequestBuilder requestBuilder = this;
            if (requestBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/HttpRequests$RequestBuilder", "hostNameVerifier"));
            }
            return requestBuilder;
        }

        @NotNull
        public RequestBuilder userAgent(@Nullable String userAgent) {
            this.myUserAgent = userAgent;
            RequestBuilder requestBuilder = this;
            if (requestBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/HttpRequests$RequestBuilder", "userAgent"));
            }
            return requestBuilder;
        }

        public <T> T connect(@NotNull RequestProcessor<T> processor) throws IOException {
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/io/HttpRequests$RequestBuilder", "connect"));
            }
            if (ourWrapClassLoader) {
                return (T)HttpRequests.wrapAndProcess(this, processor);
            }
            return (T)HttpRequests.process(this, processor);
        }
    }

    public static interface RequestProcessor<T> {
        public T process(@NotNull Request var1) throws IOException;
    }

    public static interface Request {
        @NotNull
        public URLConnection getConnection() throws IOException;

        @NotNull
        public InputStream getInputStream() throws IOException;
    }
}

