/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.config;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.ResolveScopeEnlarger;
import com.intellij.psi.search.NonClasspathDirectoriesScope;
import com.intellij.psi.search.SearchScope;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.config.GradleClassFinder;

public class GradleBuildClasspathResolveScopeEnlarger
extends ResolveScopeEnlarger {
    public SearchScope getAdditionalResolveScope(@NotNull VirtualFile file, Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/gradle/config/GradleBuildClasspathResolveScopeEnlarger", "getAdditionalResolveScope"));
        }
        String fileExtension = file.getExtension();
        if ("groovy".equals(fileExtension)) {
            GradleClassFinder gradleClassFinder = (GradleClassFinder)((Object)Extensions.findExtension((ExtensionPointName)PsiElementFinder.EP_NAME, (AreaInstance)project, GradleClassFinder.class));
            List<VirtualFile> roots = gradleClassFinder.getClassRoots();
            for (VirtualFile root : roots) {
                if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)true)) continue;
                return NonClasspathDirectoriesScope.compose(roots);
            }
        }
        return null;
    }
}

