/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main.rels;

import java.io.IOException;
import org.jetbrains.java.decompiler.code.InstructionSequence;
import org.jetbrains.java.decompiler.code.cfg.ControlFlowGraph;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.modules.code.DeadCodeHelper;
import org.jetbrains.java.decompiler.modules.decompiler.ClearStructHelper;
import org.jetbrains.java.decompiler.modules.decompiler.DomHelper;
import org.jetbrains.java.decompiler.modules.decompiler.ExitHelper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.FinallyProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.IdeaNotNullHelper;
import org.jetbrains.java.decompiler.modules.decompiler.IfHelper;
import org.jetbrains.java.decompiler.modules.decompiler.InlineSingleBlockHelper;
import org.jetbrains.java.decompiler.modules.decompiler.LabelHelper;
import org.jetbrains.java.decompiler.modules.decompiler.LoopExtractHelper;
import org.jetbrains.java.decompiler.modules.decompiler.MergeHelper;
import org.jetbrains.java.decompiler.modules.decompiler.PPandMMHelper;
import org.jetbrains.java.decompiler.modules.decompiler.SecondaryFunctionsHelper;
import org.jetbrains.java.decompiler.modules.decompiler.SequenceHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StackVarsProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.deobfuscator.ExceptionDeobfuscator;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructMethod;

public class MethodProcessorThread
implements Runnable {
    public final Object lock = new Object();
    private final StructMethod method;
    private final VarProcessor varproc;
    private final DecompilerContext parentContext;
    private volatile RootStatement root;
    private volatile Throwable error;

    public MethodProcessorThread(StructMethod method, VarProcessor varproc, DecompilerContext parentContext) {
        this.method = method;
        this.varproc = varproc;
        this.parentContext = parentContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DecompilerContext.setCurrentContext(this.parentContext);
        this.error = null;
        this.root = null;
        try {
            this.root = MethodProcessorThread.codeToJava(this.method, this.varproc);
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
        catch (ThreadDeath ex) {
            throw ex;
        }
        catch (Throwable ex) {
            this.error = ex;
        }
    }

    public static RootStatement codeToJava(StructMethod mt, VarProcessor varproc) throws IOException {
        StackVarsProcessor stackproc;
        StructClass cl = mt.getClassStruct();
        boolean isInitializer = "<clinit>".equals(mt.getName());
        mt.expandData();
        InstructionSequence seq = mt.getInstructionSequence();
        ControlFlowGraph graph = new ControlFlowGraph(seq);
        DeadCodeHelper.removeDeadBlocks(graph);
        graph.inlineJsr(mt);
        DeadCodeHelper.connectDummyExitBlock(graph);
        DeadCodeHelper.removeGotos(graph);
        ExceptionDeobfuscator.removeCircularRanges(graph);
        ExceptionDeobfuscator.restorePopRanges(graph);
        if (DecompilerContext.getOption("rer")) {
            ExceptionDeobfuscator.removeEmptyRanges(graph);
        }
        if (DecompilerContext.getOption("ner")) {
            DeadCodeHelper.incorporateValueReturns(graph);
        }
        ExceptionDeobfuscator.insertEmptyExceptionHandlerBlocks(graph);
        DeadCodeHelper.mergeBasicBlocks(graph);
        DecompilerContext.getCounterContainer().setCounter(2, mt.getLocalVariables());
        if (ExceptionDeobfuscator.hasObfuscatedExceptions(graph)) {
            DecompilerContext.getLogger().writeMessage("Heavily obfuscated exception ranges found!", IFernflowerLogger.Severity.WARN);
        }
        RootStatement root = DomHelper.parseGraph(graph);
        FinallyProcessor fproc = new FinallyProcessor(varproc);
        while (fproc.iterateGraph(mt, root, graph)) {
            root = DomHelper.parseGraph(graph);
        }
        DomHelper.removeSynchronizedHandler(root);
        SequenceHelper.condenseSequences(root);
        ClearStructHelper.clearStatements(root);
        ExprProcessor proc = new ExprProcessor();
        proc.processStatement(root, cl);
        do {
            stackproc = new StackVarsProcessor();
            stackproc.simplifyStackVars(root, mt, cl);
            varproc.setVarVersions(root);
        } while (new PPandMMHelper().findPPandMM(root));
        do {
            LabelHelper.cleanUpEdges(root);
            do {
                MergeHelper.enhanceLoops(root);
            } while (LoopExtractHelper.extractLoops(root) || IfHelper.mergeAllIfs(root));
            if (DecompilerContext.getOption("inn") && IdeaNotNullHelper.removeHardcodedChecks(root, mt)) {
                SequenceHelper.condenseSequences(root);
                stackproc = new StackVarsProcessor();
                stackproc.simplifyStackVars(root, mt, cl);
                varproc.setVarVersions(root);
            }
            LabelHelper.identifyLabels(root);
        } while (InlineSingleBlockHelper.inlineSingleBlocks(root) || !isInitializer && ExitHelper.condenseExits(root));
        ExitHelper.removeRedundantReturns(root);
        SecondaryFunctionsHelper.identifySecondaryFunctions(root);
        varproc.setVarDefinitions(root);
        LabelHelper.replaceContinueWithBreak(root);
        mt.releaseResources();
        return root;
    }

    public RootStatement getResult() throws Throwable {
        Throwable t = this.error;
        if (t != null) {
            throw t;
        }
        return this.root;
    }

    public Throwable getError() {
        return this.error;
    }
}

