/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class AssignmentExprent
extends Exprent {
    public static final int CONDITION_NONE = -1;
    private static final String[] funceq = new String[]{" += ", " -= ", " *= ", " /= ", " &= ", " |= ", " ^= ", " %= ", " <<= ", " >>= ", " >>>= "};
    private Exprent left;
    private Exprent right;
    private int condtype = -1;

    public AssignmentExprent(Exprent left, Exprent right) {
        this.type = 2;
        this.left = left;
        this.right = right;
    }

    @Override
    public VarType getExprType() {
        return this.left.getExprType();
    }

    @Override
    public CheckTypesResult checkExprTypeBounds() {
        CheckTypesResult result = new CheckTypesResult();
        VarType typeleft = this.left.getExprType();
        VarType typeright = this.right.getExprType();
        if (typeleft.type_family > typeright.type_family) {
            result.addMinTypeExprent(this.right, VarType.getMinTypeInFamily(typeleft.type_family));
        } else if (typeleft.type_family < typeright.type_family) {
            result.addMinTypeExprent(this.left, typeright);
        } else {
            result.addMinTypeExprent(this.left, VarType.getCommonSupertype(typeleft, typeright));
        }
        return result;
    }

    @Override
    public List<Exprent> getAllExprents() {
        ArrayList<Exprent> lst = new ArrayList<Exprent>();
        lst.add(this.left);
        lst.add(this.right);
        return lst;
    }

    @Override
    public Exprent copy() {
        return new AssignmentExprent(this.left.copy(), this.right.copy());
    }

    @Override
    public int getPrecedence() {
        return 13;
    }

    @Override
    public String toJava(int indent, BytecodeMappingTracer tracer) {
        VarType leftType = this.left.getExprType();
        VarType rightType = this.right.getExprType();
        boolean fieldInClassInit = false;
        boolean hiddenField = false;
        if (this.left.type == 5) {
            StructField fd;
            FieldExprent field = (FieldExprent)this.left;
            ClassesProcessor.ClassNode node = (ClassesProcessor.ClassNode)DecompilerContext.getProperty("CURRENT_CLASS_NODE");
            if (node != null && (fd = node.classStruct.getField(field.getName(), field.getDescriptor().descriptorString)) != null) {
                if (field.isStatic() && fd.hasModifier(16)) {
                    fieldInClassInit = true;
                }
                if (node.wrapper.getHiddenMembers().contains(InterpreterUtil.makeUniqueKey(fd.getName(), fd.getDescriptor()))) {
                    hiddenField = true;
                }
            }
        }
        if (hiddenField) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        if (fieldInClassInit) {
            buffer.append(((FieldExprent)this.left).getName());
        } else {
            buffer.append(this.left.toJava(indent, tracer));
        }
        String res = this.right.toJava(indent, tracer);
        if (this.condtype == -1 && !leftType.isSuperset(rightType) && (rightType.equals(VarType.VARTYPE_OBJECT) || leftType.type != 8)) {
            if (this.right.getPrecedence() >= FunctionExprent.getPrecedence(29)) {
                res = "(" + res + ")";
            }
            res = "(" + ExprProcessor.getCastTypeName(leftType) + ")" + res;
        }
        buffer.append(this.condtype == -1 ? " = " : funceq[this.condtype]).append(res);
        tracer.addMapping(this.bytecode);
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof AssignmentExprent)) {
            return false;
        }
        AssignmentExprent as = (AssignmentExprent)o;
        return InterpreterUtil.equalObjects(this.left, as.getLeft()) && InterpreterUtil.equalObjects(this.right, as.getRight()) && this.condtype == as.getCondtype();
    }

    @Override
    public void replaceExprent(Exprent oldexpr, Exprent newexpr) {
        if (oldexpr == this.left) {
            this.left = newexpr;
        }
        if (oldexpr == this.right) {
            this.right = newexpr;
        }
    }

    public Exprent getLeft() {
        return this.left;
    }

    public void setLeft(Exprent left) {
        this.left = left;
    }

    public Exprent getRight() {
        return this.right;
    }

    public void setRight(Exprent right) {
        this.right = right;
    }

    public int getCondtype() {
        return this.condtype;
    }

    public void setCondtype(int condtype) {
        this.condtype = condtype;
    }
}

