/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SurroundAutoCloseableAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        JavaPsiFacade facade;
        PsiClass autoCloseable;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/SurroundAutoCloseableAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/SurroundAutoCloseableAction", "isAvailable"));
        }
        if (!element.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
            return false;
        }
        if (!PsiUtil.getLanguageLevel((PsiElement)element).isAtLeast(LanguageLevel.JDK_1_7)) {
            return false;
        }
        PsiLocalVariable variable = (PsiLocalVariable)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLocalVariable.class);
        if (variable == null) {
            return false;
        }
        PsiExpression initializer = variable.getInitializer();
        if (initializer == null) {
            return false;
        }
        PsiElement declaration = variable.getParent();
        if (!(declaration instanceof PsiDeclarationStatement)) {
            return false;
        }
        PsiElement codeBlock = declaration.getParent();
        if (!(codeBlock instanceof PsiCodeBlock)) {
            return false;
        }
        PsiType type = variable.getType();
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClass aClass = ((PsiClassType)type).resolve();
        return InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)(autoCloseable = (facade = JavaPsiFacade.getInstance((Project)project)).findClass("java.lang.AutoCloseable", ProjectScope.getLibrariesScope((Project)project))), (boolean)true);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiJavaToken brace;
        PsiCodeBlock tryBlock;
        PsiElement first;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/SurroundAutoCloseableAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/SurroundAutoCloseableAction", "invoke"));
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
            return;
        }
        PsiLocalVariable variable = (PsiLocalVariable)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLocalVariable.class);
        if (variable == null) {
            return;
        }
        PsiExpression initializer = variable.getInitializer();
        if (initializer == null) {
            return;
        }
        PsiElement declaration = variable.getParent();
        if (!(declaration instanceof PsiDeclarationStatement)) {
            return;
        }
        PsiElement codeBlock = declaration.getParent();
        if (!(codeBlock instanceof PsiCodeBlock)) {
            return;
        }
        LocalSearchScope scope = new LocalSearchScope(codeBlock);
        PsiElement last = null;
        for (PsiReference reference : ReferencesSearch.search((PsiElement)variable, (SearchScope)scope).findAll()) {
            PsiElement usage = PsiTreeUtil.findPrevParent((PsiElement)codeBlock, (PsiElement)reference.getElement());
            if (last != null && usage.getTextOffset() <= last.getTextOffset()) continue;
            last = usage;
        }
        String text = "try (" + variable.getTypeElement().getText() + " " + variable.getName() + " = " + initializer.getText() + ") {}";
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiTryStatement armStatement = (PsiTryStatement)declaration.replace((PsiElement)factory.createStatementFromText(text, codeBlock));
        List<PsiElement> toFormat = null;
        if (last != null && (first = armStatement.getNextSibling()) != null) {
            toFormat = SurroundAutoCloseableAction.moveStatements(first, last, armStatement);
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        PsiElement formattedElement = codeStyleManager.reformat((PsiElement)armStatement);
        if (toFormat != null) {
            for (PsiElement psiElement : toFormat) {
                codeStyleManager.reformat(psiElement);
            }
        }
        if (last == null && (tryBlock = ((PsiTryStatement)formattedElement).getTryBlock()) != null && (brace = tryBlock.getLBrace()) != null) {
            editor.getCaretModel().moveToOffset(brace.getTextOffset() + 1);
        }
    }

    private static List<PsiElement> moveStatements(@NotNull PsiElement first, PsiElement last, PsiTryStatement statement) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/codeInsight/intention/impl/SurroundAutoCloseableAction", "moveStatements"));
        }
        PsiCodeBlock tryBlock = statement.getTryBlock();
        assert (tryBlock != null) : statement.getText();
        PsiElement parent = statement.getParent();
        SmartList toFormat = new SmartList();
        PsiElement stopAt = last.getNextSibling();
        for (PsiElement child = first; child != null && child != stopAt; child = child.getNextSibling()) {
            if (!(child instanceof PsiDeclarationStatement)) continue;
            PsiElement anchor = child;
            for (PsiElement declared : ((PsiDeclarationStatement)child).getDeclaredElements()) {
                if (!(declared instanceof PsiLocalVariable)) continue;
                final int endOffset = last.getTextRange().getEndOffset();
                boolean contained = ReferencesSearch.search((PsiElement)declared, (SearchScope)new LocalSearchScope(parent)).forEach((Processor)new Processor<PsiReference>(){

                    public boolean process(PsiReference reference) {
                        return reference.getElement().getTextOffset() <= endOffset;
                    }
                });
                if (contained) continue;
                PsiLocalVariable var = (PsiLocalVariable)declared;
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)statement.getProject());
                String name = var.getName();
                assert (name != null) : child.getText();
                toFormat.add(parent.addBefore((PsiElement)factory.createVariableDeclarationStatement(name, var.getType(), null), (PsiElement)statement));
                PsiExpression varInit = var.getInitializer();
                assert (varInit != null) : child.getText();
                String varAssignText = name + " = " + varInit.getText() + ";";
                anchor = parent.addAfter((PsiElement)factory.createStatementFromText(varAssignText, parent), anchor);
                var.delete();
            }
            if (child != last || child.isValid()) continue;
            last = anchor;
        }
        tryBlock.addRangeBefore(first, last, (PsiElement)tryBlock.getRBrace());
        parent.deleteChildRange(first, last);
        return toFormat;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.surround.resource.with.ARM.block", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/SurroundAutoCloseableAction", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/SurroundAutoCloseableAction", "getText"));
        }
        return string;
    }
}

