/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaHighlightingUtil;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AnonymousCanBeLambdaInspection
extends BaseJavaBatchLocalInspectionTool {
    public static final Logger LOG = Logger.getInstance((String)("#" + AnonymousCanBeLambdaInspection.class.getName()));

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.LANGUAGE_LEVEL_SPECIFIC_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Anonymous type can be replaced with lambda" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection", "getDisplayName"));
        }
        return "Anonymous type can be replaced with lambda";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getShortName() {
        if ("Convert2Lambda" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection", "getShortName"));
        }
        return "Convert2Lambda";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitAnonymousClass(PsiAnonymousClass aClass) {
                PsiElement lambdaContext;
                super.visitAnonymousClass(aClass);
                PsiElement parent = aClass.getParent();
                PsiElement psiElement = lambdaContext = parent != null ? parent.getParent() : null;
                if (lambdaContext != null && (LambdaUtil.isValidLambdaContext((PsiElement)lambdaContext) || !(lambdaContext instanceof PsiExpressionStatement)) && AnonymousCanBeLambdaInspection.canBeConvertedToLambda(aClass, new Condition<PsiClassType>(){

                    public boolean value(PsiClassType type) {
                        return LambdaHighlightingUtil.checkInterfaceFunctional((PsiType)type) == null;
                    }
                })) {
                    PsiElement lBrace = aClass.getLBrace();
                    LOG.assertTrue(lBrace != null);
                    TextRange rangeInElement = new TextRange(0, aClass.getStartOffsetInParent() + lBrace.getStartOffsetInParent());
                    holder.registerProblem(parent, "Anonymous #ref #loc can be replaced with lambda", ProblemHighlightType.LIKE_UNUSED_SYMBOL, rangeInElement, new LocalQuickFix[]{new ReplaceWithLambdaFix()});
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static boolean hasRuntimeAnnotations(PsiMethod method) {
        PsiAnnotation[] annotations;
        for (PsiAnnotation annotation : annotations = method.getModifierList().getAnnotations()) {
            PsiClass containingClass;
            PsiElement resolved;
            PsiAnnotationMemberValue value;
            PsiAnnotation retentionAnno;
            PsiElement target;
            PsiJavaCodeReferenceElement ref = annotation.getNameReferenceElement();
            PsiElement psiElement = target = ref != null ? ref.resolve() : null;
            if (!(target instanceof PsiClass) || (retentionAnno = AnnotationUtil.findAnnotation((PsiModifierListOwner)((PsiClass)target), (String[])new String[]{Retention.class.getName()})) == null || !((value = retentionAnno.findAttributeValue("value")) instanceof PsiReferenceExpression) || !((resolved = ((PsiReferenceExpression)value).resolve()) instanceof PsiField) || !RetentionPolicy.RUNTIME.name().equals(((PsiField)resolved).getName()) || (containingClass = ((PsiField)resolved).getContainingClass()) == null || !RetentionPolicy.class.getName().equals(containingClass.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasForbiddenRefsInsideBody(PsiMethod method, PsiAnonymousClass aClass) {
        ForbiddenRefsChecker checker = new ForbiddenRefsChecker(method, aClass);
        PsiCodeBlock body = method.getBody();
        LOG.assertTrue(body != null);
        body.accept((PsiElementVisitor)checker);
        return checker.hasForbiddenRefs();
    }

    private static PsiType getInferredType(PsiAnonymousClass aClass) {
        JavaResolveResult result;
        PsiExpressionList expressionList;
        PsiElement callExpr;
        PsiExpression expression = (PsiExpression)aClass.getParent();
        PsiType psiType = PsiTypesUtil.getExpectedTypeByParent((PsiExpression)expression);
        if (psiType != null) {
            return psiType;
        }
        PsiExpression topExpr = expression;
        while (topExpr.getParent() instanceof PsiParenthesizedExpression) {
            topExpr = (PsiExpression)topExpr.getParent();
        }
        PsiElement parent = topExpr.getParent();
        if (parent instanceof PsiExpressionList && (callExpr = (expressionList = (PsiExpressionList)parent).getParent()) instanceof PsiCallExpression && (result = ((PsiCallExpression)callExpr).resolveMethodGenerics()) instanceof MethodCandidateInfo) {
            PsiType paramType;
            PsiMethod method = ((MethodCandidateInfo)result).getElement();
            Object[] expressions = expressionList.getExpressions();
            int i = ArrayUtilRt.find((Object[])expressions, (Object)topExpr);
            if (i < 0) {
                return null;
            }
            expressions[i] = null;
            PsiParameter[] parameters = method.getParameterList().getParameters();
            PsiSubstitutor substitutor = PsiResolveHelper.SERVICE.getInstance((Project)aClass.getProject()).inferTypeArguments(method.getTypeParameters(), parameters, (PsiExpression[])expressions, ((MethodCandidateInfo)result).getSiteSubstitutor(), callExpr.getParent(), (ParameterTypeInferencePolicy)DefaultParameterTypeInferencePolicy.INSTANCE);
            if (i < parameters.length) {
                paramType = parameters[i].getType();
            } else {
                paramType = parameters[parameters.length - 1].getType();
                if (!(paramType instanceof PsiEllipsisType)) {
                    return null;
                }
                paramType = ((PsiEllipsisType)paramType).getComponentType();
            }
            return substitutor.substitute(paramType);
        }
        return null;
    }

    public static boolean canBeConvertedToLambda(PsiAnonymousClass aClass, Condition<PsiClassType> baseClassTypeCondition) {
        PsiMethod[] methods;
        if (PsiUtil.getLanguageLevel((PsiElement)aClass).isAtLeast(LanguageLevel.JDK_1_8) && baseClassTypeCondition.value((Object)aClass.getBaseClassType()) && (methods = aClass.getMethods()).length == 1 && aClass.getFields().length == 0) {
            PsiMethod method = methods[0];
            return method.getBody() != null && !AnonymousCanBeLambdaInspection.hasForbiddenRefsInsideBody(method, aClass) && !AnonymousCanBeLambdaInspection.hasRuntimeAnnotations(method) && !method.hasModifierProperty("synchronized");
        }
        return false;
    }

    public static boolean functionalInterfaceMethodReferenced(PsiMethod psiMethod, PsiAnonymousClass anonymClass, PsiCallExpression callExpression) {
        if (psiMethod != null && !psiMethod.hasModifierProperty("static")) {
            PsiClass containingClass = psiMethod.getContainingClass();
            if (containingClass != null && "java.lang.Object".equals(containingClass.getQualifiedName())) {
                return false;
            }
            if (callExpression instanceof PsiMethodCallExpression && ((PsiMethodCallExpression)callExpression).getMethodExpression().isQualified()) {
                return false;
            }
            if (InheritanceUtil.isInheritorOrSelf((PsiClass)anonymClass, (PsiClass)containingClass, (boolean)true) && !InheritanceUtil.hasEnclosingInstanceInScope((PsiClass)containingClass, (PsiElement)anonymClass.getParent(), (boolean)true, (boolean)true)) {
                return true;
            }
        }
        return false;
    }

    private static class ForbiddenRefsChecker
    extends JavaRecursiveElementWalkingVisitor {
        private boolean myBodyContainsForbiddenRefs;
        private final Set<PsiLocalVariable> myLocals = ContainerUtilRt.newHashSet((int)5);
        private final PsiMethod myMethod;
        private final PsiAnonymousClass myAnonymClass;
        private final boolean myEqualInference;

        public ForbiddenRefsChecker(PsiMethod method, PsiAnonymousClass aClass) {
            this.myMethod = method;
            this.myAnonymClass = aClass;
            PsiType inferredType = AnonymousCanBeLambdaInspection.getInferredType(aClass);
            this.myEqualInference = !aClass.getBaseClassType().equals((Object)inferredType);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression methodCallExpression) {
            if (this.myBodyContainsForbiddenRefs) {
                return;
            }
            super.visitMethodCallExpression(methodCallExpression);
            PsiMethod psiMethod = methodCallExpression.resolveMethod();
            if (psiMethod == this.myMethod || AnonymousCanBeLambdaInspection.functionalInterfaceMethodReferenced(psiMethod, this.myAnonymClass, (PsiCallExpression)methodCallExpression) || psiMethod != null && !methodCallExpression.getMethodExpression().isQualified() && "getClass".equals(psiMethod.getName()) && psiMethod.getParameterList().getParametersCount() == 0) {
                this.myBodyContainsForbiddenRefs = true;
            }
        }

        public void visitThisExpression(PsiThisExpression expression) {
            if (this.myBodyContainsForbiddenRefs) {
                return;
            }
            if (expression.getQualifier() == null) {
                this.myBodyContainsForbiddenRefs = true;
            }
        }

        public void visitSuperExpression(PsiSuperExpression expression) {
            if (this.myBodyContainsForbiddenRefs) {
                return;
            }
            if (expression.getQualifier() == null) {
                this.myBodyContainsForbiddenRefs = true;
            }
        }

        public void visitLocalVariable(PsiLocalVariable variable) {
            if (this.myBodyContainsForbiddenRefs) {
                return;
            }
            super.visitLocalVariable(variable);
            this.myLocals.add(variable);
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            PsiElement resolved;
            if (this.myBodyContainsForbiddenRefs) {
                return;
            }
            super.visitReferenceExpression(expression);
            if (!(expression.getParent() instanceof PsiMethodCallExpression)) {
                PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiField.class);
                if (field != null) {
                    PsiExpression initializer;
                    PsiElement resolved2 = expression.resolve();
                    if (resolved2 instanceof PsiField && ((PsiField)resolved2).getContainingClass() == field.getContainingClass() && ((initializer = ((PsiField)resolved2).getInitializer()) == null || resolved2 == field || initializer.getTextOffset() > this.myAnonymClass.getTextOffset() && !((PsiField)resolved2).hasModifierProperty("static"))) {
                        this.myBodyContainsForbiddenRefs = true;
                        return;
                    }
                } else {
                    PsiElement resolved3;
                    PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)this.myAnonymClass, PsiMethod.class);
                    if (method != null && method.isConstructor() && (resolved3 = expression.resolve()) instanceof PsiField && ((PsiField)resolved3).hasModifierProperty("final") && ((PsiField)resolved3).getContainingClass() == method.getContainingClass()) {
                        try {
                            int startOffset;
                            ControlFlow flow;
                            Collection<PsiVariable> writtenVariables;
                            PsiCodeBlock constructorBody = method.getBody();
                            if (constructorBody != null && !(writtenVariables = ControlFlowUtil.getWrittenVariables(flow = HighlightControlFlowUtil.getControlFlowNoConstantEvaluate((PsiElement)constructorBody), 0, startOffset = flow.getStartOffset((PsiElement)this.myAnonymClass), false)).contains(resolved3)) {
                                this.myBodyContainsForbiddenRefs = true;
                                return;
                            }
                        }
                        catch (AnalysisCanceledException e) {
                            this.myBodyContainsForbiddenRefs = true;
                            return;
                        }
                    }
                }
            }
            if (this.myEqualInference && (resolved = expression.resolve()) instanceof PsiParameter && ((PsiParameter)resolved).getDeclarationScope() == this.myMethod) {
                int parameterIndex = this.myMethod.getParameterList().getParameterIndex((PsiParameter)resolved);
                for (PsiMethod superMethod : this.myMethod.findDeepestSuperMethods()) {
                    if (!(PsiUtil.resolveClassInType((PsiType)superMethod.getParameterList().getParameters()[parameterIndex].getType()) instanceof PsiTypeParameter)) continue;
                    this.myBodyContainsForbiddenRefs = true;
                    return;
                }
            }
        }

        public boolean hasForbiddenRefs() {
            return this.myBodyContainsForbiddenRefs;
        }

        public Set<PsiLocalVariable> getLocals() {
            return this.myLocals;
        }
    }

    private static class ReplaceWithLambdaFix
    implements LocalQuickFix,
    HighPriorityAction {
        private ReplaceWithLambdaFix() {
        }

        @NotNull
        public String getName() {
            if ("Replace with lambda" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection$ReplaceWithLambdaFix", "getName"));
            }
            return "Replace with lambda";
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection$ReplaceWithLambdaFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection$ReplaceWithLambdaFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/AnonymousCanBeLambdaInspection$ReplaceWithLambdaFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiNewExpression) {
                PsiElement lambdaBody;
                if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
                    return;
                }
                PsiAnonymousClass anonymousClass = ((PsiNewExpression)element).getAnonymousClass();
                LOG.assertTrue(anonymousClass != null);
                boolean voidCompatible = PsiType.VOID.equals((Object)LambdaUtil.getFunctionalInterfaceReturnType((PsiType)anonymousClass.getBaseClassType()));
                ChangeContextUtil.encodeContextInfo((PsiElement)anonymousClass, true);
                PsiElement lambdaContext = anonymousClass.getParent().getParent();
                boolean validContext = LambdaUtil.isValidLambdaContext((PsiElement)lambdaContext);
                String canonicalText = anonymousClass.getBaseClassType().getCanonicalText();
                PsiMethod method = anonymousClass.getMethods()[0];
                LOG.assertTrue(method != null);
                PsiCodeBlock body = method.getBody();
                LOG.assertTrue(body != null);
                ForbiddenRefsChecker checker = new ForbiddenRefsChecker(method, anonymousClass);
                body.accept((PsiElementVisitor)checker);
                PsiResolveHelper helper = PsiResolveHelper.SERVICE.getInstance((Project)body.getProject());
                Set<PsiLocalVariable> conflictingLocals = checker.getLocals();
                Iterator<PsiLocalVariable> iterator = conflictingLocals.iterator();
                while (iterator.hasNext()) {
                    PsiLocalVariable local = iterator.next();
                    String localName = local.getName();
                    if (localName != null && helper.resolveReferencedVariable(localName, (PsiElement)anonymousClass) != null) continue;
                    iterator.remove();
                }
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
                ReplaceWithLambdaFix.giveUniqueNames(project, lambdaContext, elementFactory, (PsiElement)body, conflictingLocals.toArray(new PsiVariable[conflictingLocals.size()]));
                String lambdaWithTypesDeclared = ReplaceWithLambdaFix.composeLambdaText(method, true);
                String withoutTypesDeclared = ReplaceWithLambdaFix.composeLambdaText(method, false);
                PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)elementFactory.createExpressionFromText(withoutTypesDeclared, (PsiElement)anonymousClass);
                PsiStatement[] statements = body.getStatements();
                PsiElement copy = body.copy();
                if (statements.length == 1) {
                    if (statements[0] instanceof PsiReturnStatement) {
                        PsiExpression value = ((PsiReturnStatement)statements[0]).getReturnValue();
                        if (value != null) {
                            copy = value.copy();
                        }
                    } else if (!(!(statements[0] instanceof PsiExpressionStatement) || voidCompatible && lambdaContext instanceof PsiExpressionList)) {
                        copy = ((PsiExpressionStatement)statements[0]).getExpression().copy();
                    }
                }
                LOG.assertTrue((lambdaBody = lambdaExpression.getBody()) != null);
                lambdaBody.replace(copy);
                ReplaceWithLambdaFix.giveUniqueNames(project, lambdaContext, elementFactory, (PsiElement)lambdaExpression, (PsiVariable[])lambdaExpression.getParameterList().getParameters());
                PsiNewExpression newExpression = (PsiNewExpression)anonymousClass.getParent();
                lambdaExpression = (PsiLambdaExpression)newExpression.replace((PsiElement)lambdaExpression);
                ChangeContextUtil.decodeContextInfo((PsiElement)lambdaExpression, null, null);
                if (!validContext) {
                    PsiParenthesizedExpression typeCast = (PsiParenthesizedExpression)elementFactory.createExpressionFromText("((" + canonicalText + ")" + withoutTypesDeclared + ")", (PsiElement)lambdaExpression);
                    PsiExpression typeCastExpr = typeCast.getExpression();
                    LOG.assertTrue(typeCastExpr != null);
                    PsiExpression typeCastOperand = ((PsiTypeCastExpression)typeCastExpr).getOperand();
                    LOG.assertTrue(typeCastOperand != null);
                    PsiElement fromText = ((PsiLambdaExpression)typeCastOperand).getBody();
                    LOG.assertTrue(fromText != null);
                    lambdaBody = lambdaExpression.getBody();
                    LOG.assertTrue(lambdaBody != null);
                    fromText.replace(lambdaBody);
                    lambdaExpression.replace((PsiElement)typeCast);
                    return;
                }
                PsiType interfaceType = lambdaExpression.getFunctionalInterfaceType();
                if (ReplaceWithLambdaFix.isInferred(lambdaExpression, interfaceType)) {
                    PsiLambdaExpression withTypes = (PsiLambdaExpression)elementFactory.createExpressionFromText(lambdaWithTypesDeclared, (PsiElement)lambdaExpression);
                    PsiElement withTypesBody = withTypes.getBody();
                    LOG.assertTrue(withTypesBody != null);
                    lambdaBody = lambdaExpression.getBody();
                    LOG.assertTrue(lambdaBody != null);
                    withTypesBody.replace(lambdaBody);
                    lambdaExpression = (PsiLambdaExpression)lambdaExpression.replace((PsiElement)withTypes);
                    interfaceType = lambdaExpression.getFunctionalInterfaceType();
                    if (ReplaceWithLambdaFix.isInferred(lambdaExpression, interfaceType)) {
                        PsiTypeCastExpression typeCast = (PsiTypeCastExpression)elementFactory.createExpressionFromText("(" + canonicalText + ")" + withoutTypesDeclared, (PsiElement)lambdaExpression);
                        PsiExpression typeCastOperand = typeCast.getOperand();
                        LOG.assertTrue(typeCastOperand instanceof PsiLambdaExpression);
                        PsiElement fromText = ((PsiLambdaExpression)typeCastOperand).getBody();
                        LOG.assertTrue(fromText != null);
                        lambdaBody = lambdaExpression.getBody();
                        LOG.assertTrue(lambdaBody != null);
                        fromText.replace(lambdaBody);
                        lambdaExpression.replace((PsiElement)typeCast);
                    }
                }
            }
        }

        private static void giveUniqueNames(Project project, PsiElement lambdaContext, final PsiElementFactory elementFactory, PsiElement body, PsiVariable[] parameters) {
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            final HashMap<PsiVariable, String> names = new HashMap<PsiVariable, String>();
            for (PsiVariable parameter : parameters) {
                String uniqueVariableName;
                String parameterName = parameter.getName();
                if (Comparing.equal((String)parameterName, (String)(uniqueVariableName = codeStyleManager.suggestUniqueVariableName(parameterName, lambdaContext, false)))) continue;
                names.put(parameter, uniqueVariableName);
            }
            final LinkedHashMap replacements = new LinkedHashMap();
            body.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitVariable(PsiVariable variable) {
                    super.visitVariable(variable);
                    String newName = (String)names.get(variable);
                    if (newName != null) {
                        replacements.put((Object)variable.getNameIdentifier(), (Object)elementFactory.createIdentifier(newName));
                    }
                }

                public void visitReferenceExpression(PsiReferenceExpression expression) {
                    String newName;
                    super.visitReferenceExpression(expression);
                    PsiElement resolve = expression.resolve();
                    if (resolve instanceof PsiVariable && (newName = (String)names.get(resolve)) != null) {
                        replacements.put((Object)expression, (Object)elementFactory.createExpressionFromText(newName, (PsiElement)expression));
                    }
                }
            });
            for (PsiElement psiElement : replacements.keySet()) {
                psiElement.replace((PsiElement)replacements.get((Object)psiElement));
            }
        }

        private static boolean isInferred(PsiLambdaExpression lambdaExpression, PsiType interfaceType) {
            return interfaceType == null || !LambdaUtil.isLambdaFullyInferred((PsiLambdaExpression)lambdaExpression, (PsiType)interfaceType) || !LambdaUtil.isFunctionalType((PsiType)interfaceType);
        }

        private static String composeLambdaText(PsiMethod method, final boolean appendType) {
            StringBuilder buf = new StringBuilder();
            Object[] parameters = method.getParameterList().getParameters();
            if (parameters.length != 1 || appendType) {
                buf.append("(");
            }
            buf.append(StringUtil.join((Object[])parameters, (Function)new Function<PsiParameter, String>(){

                public String fun(PsiParameter parameter) {
                    return ReplaceWithLambdaFix.composeParameter(parameter, appendType);
                }
            }, (String)","));
            if (parameters.length != 1 || appendType) {
                buf.append(")");
            }
            buf.append("-> {}");
            return buf.toString();
        }

        private static String composeParameter(PsiParameter parameter, boolean appendType) {
            PsiTypeElement typeElement;
            String parameterType = appendType ? ((typeElement = parameter.getTypeElement()) != null ? typeElement.getText() + " " : "") : "";
            String parameterName = parameter.getName();
            if (parameterName == null) {
                parameterName = "";
            }
            return parameterType + parameterName;
        }
    }
}

