/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.impl.CheckableRunConfigurationEditor;
import com.intellij.execution.impl.RunConfigurationSettingsEditor;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.CompositeSettingsBuilder;
import com.intellij.openapi.options.CompositeSettingsEditor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.GroupSettingsBuilder;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.options.SettingsEditorWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListScrollingUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.Convertor;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class ConfigurationSettingsEditor
extends CompositeSettingsEditor<RunnerAndConfigurationSettings> {
    private final ArrayList<SettingsEditor<RunnerAndConfigurationSettings>> myRunnerEditors = new ArrayList();
    private RunnersEditorComponent myRunnersComponent;
    private final RunConfiguration myConfiguration;
    private final SettingsEditor<RunConfiguration> myConfigurationEditor;
    private SettingsEditorGroup<RunnerAndConfigurationSettings> myCompound;

    public CompositeSettingsBuilder<RunnerAndConfigurationSettings> getBuilder() {
        this.init();
        return new GroupSettingsBuilder(this.myCompound);
    }

    private void init() {
        if (this.myCompound == null) {
            Executor[] executors;
            this.myCompound = new SettingsEditorGroup();
            Disposer.register((Disposable)this, this.myCompound);
            if (this.myConfigurationEditor instanceof SettingsEditorGroup) {
                SettingsEditorGroup group = (SettingsEditorGroup)this.myConfigurationEditor;
                List editors = group.getEditors();
                for (Pair pair : editors) {
                    this.myCompound.addEditor((String)pair.getFirst(), (SettingsEditor)new ConfigToSettingsWrapper((SettingsEditor<RunConfiguration>)((SettingsEditor)pair.getSecond())));
                }
            } else {
                this.myCompound.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new ConfigToSettingsWrapper(this.myConfigurationEditor));
            }
            this.myRunnersComponent = new RunnersEditorComponent();
            for (Executor executor : executors = ExecutorRegistry.getInstance().getRegisteredExecutors()) {
                JComponent perRunnerSettings;
                ProgramRunner runner = RunnerRegistry.getInstance().getRunner(executor.getId(), (RunProfile)this.myConfiguration);
                if (runner == null || (perRunnerSettings = this.createCompositePerRunnerSettings(executor, runner)) == null) continue;
                this.myRunnersComponent.addExecutorComponent(executor, perRunnerSettings);
            }
            if (this.myRunnerEditors.size() > 0) {
                this.myCompound.addEditor(ExecutionBundle.message((String)"run.configuration.startup.connection.rab.title", (Object[])new Object[0]), (SettingsEditor)new CompositeSettingsEditor<RunnerAndConfigurationSettings>(this.getFactory()){

                    public CompositeSettingsBuilder<RunnerAndConfigurationSettings> getBuilder() {
                        return new CompositeSettingsBuilder<RunnerAndConfigurationSettings>(){

                            public Collection<SettingsEditor<RunnerAndConfigurationSettings>> getEditors() {
                                return ConfigurationSettingsEditor.this.myRunnerEditors;
                            }

                            public JComponent createCompoundEditor() {
                                return ConfigurationSettingsEditor.this.myRunnersComponent.getComponent();
                            }
                        };
                    }
                });
            }
        }
    }

    private JComponent createCompositePerRunnerSettings(Executor executor, final ProgramRunner runner) {
        SettingsEditor runnerEditor;
        SettingsEditor configEditor = this.myConfiguration.getRunnerSettingsEditor(runner);
        try {
            runnerEditor = runner.getSettingsEditor(executor, this.myConfiguration);
        }
        catch (AbstractMethodError error) {
            runnerEditor = null;
        }
        if (configEditor == null && runnerEditor == null) {
            return null;
        }
        SettingsEditorWrapper wrappedConfigEditor = null;
        SettingsEditorWrapper wrappedRunEditor = null;
        if (configEditor != null) {
            wrappedConfigEditor = new SettingsEditorWrapper(configEditor, (Convertor)new Convertor<RunnerAndConfigurationSettings, ConfigurationPerRunnerSettings>(){

                public ConfigurationPerRunnerSettings convert(RunnerAndConfigurationSettings configurationSettings) {
                    return configurationSettings.getConfigurationSettings(runner);
                }
            });
            this.myRunnerEditors.add((SettingsEditor<RunnerAndConfigurationSettings>)wrappedConfigEditor);
            Disposer.register((Disposable)this, (Disposable)wrappedConfigEditor);
        }
        if (runnerEditor != null) {
            wrappedRunEditor = new SettingsEditorWrapper(runnerEditor, (Convertor)new Convertor<RunnerAndConfigurationSettings, RunnerSettings>(){

                public RunnerSettings convert(RunnerAndConfigurationSettings configurationSettings) {
                    return configurationSettings.getRunnerSettings(runner);
                }
            });
            this.myRunnerEditors.add((SettingsEditor<RunnerAndConfigurationSettings>)wrappedRunEditor);
            Disposer.register((Disposable)this, (Disposable)wrappedRunEditor);
        }
        if (wrappedRunEditor != null && wrappedConfigEditor != null) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)wrappedConfigEditor.getComponent(), "Center");
            JComponent wrappedRunEditorComponent = wrappedRunEditor.getComponent();
            wrappedRunEditorComponent.setBorder(IdeBorderFactory.createEmptyBorder((int)3, (int)0, (int)0, (int)0));
            panel.add((Component)wrappedRunEditorComponent, "South");
            return panel;
        }
        if (wrappedRunEditor != null) {
            return wrappedRunEditor.getComponent();
        }
        return wrappedConfigEditor.getComponent();
    }

    public ConfigurationSettingsEditor(RunnerAndConfigurationSettings settings) {
        super(settings.createFactory());
        this.myConfigurationEditor = settings.getConfiguration().getConfigurationEditor();
        Disposer.register((Disposable)this, this.myConfigurationEditor);
        this.myConfiguration = settings.getConfiguration();
    }

    public RunnerAndConfigurationSettings getSnapshot() throws ConfigurationException {
        RunnerAndConfigurationSettings settings = (RunnerAndConfigurationSettings)this.getFactory().create();
        settings.setName(this.myConfiguration.getName());
        if (this.myConfigurationEditor instanceof CheckableRunConfigurationEditor) {
            ((CheckableRunConfigurationEditor)this.myConfigurationEditor).checkEditorData((Object)settings.getConfiguration());
        } else {
            this.applyTo(settings);
        }
        return settings;
    }

    private class ConfigToSettingsWrapper
    extends SettingsEditor<RunnerAndConfigurationSettings> {
        private final SettingsEditor<RunConfiguration> myConfigEditor;

        public ConfigToSettingsWrapper(SettingsEditor<RunConfiguration> configEditor) {
            this.myConfigEditor = configEditor;
            if (configEditor instanceof RunConfigurationSettingsEditor) {
                ((RunConfigurationSettingsEditor)configEditor).setOwner((SettingsEditor<RunnerAndConfigurationSettings>)ConfigurationSettingsEditor.this);
            }
        }

        public void resetEditorFrom(RunnerAndConfigurationSettings configurationSettings) {
            this.myConfigEditor.resetFrom((Object)configurationSettings.getConfiguration());
        }

        public void applyEditorTo(RunnerAndConfigurationSettings configurationSettings) throws ConfigurationException {
            this.myConfigEditor.applyTo((Object)configurationSettings.getConfiguration());
        }

        @NotNull
        public JComponent createEditor() {
            JComponent jComponent = this.myConfigEditor.getComponent();
            if (jComponent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/ConfigurationSettingsEditor$ConfigToSettingsWrapper", "createEditor"));
            }
            return jComponent;
        }

        public void disposeEditor() {
            Disposer.dispose(this.myConfigEditor);
        }
    }

    private static class RunnersEditorComponent {
        @NonNls
        private static final String NO_RUNNER_COMPONENT = "<NO RUNNER LABEL>";
        private JList myRunnersList;
        private JPanel myRunnerPanel;
        private final CardLayout myLayout;
        private final DefaultListModel myListModel;
        private final JLabel myNoRunner;
        private JPanel myRunnersPanel;

        public RunnersEditorComponent() {
            this.$$$setupUI$$$();
            this.myLayout = new CardLayout();
            this.myListModel = new DefaultListModel();
            this.myNoRunner = new JLabel(ExecutionBundle.message((String)"run.configuration.norunner.selected.label", (Object[])new Object[0]));
            this.myRunnerPanel.setLayout(this.myLayout);
            this.myRunnerPanel.add((Component)this.myNoRunner, NO_RUNNER_COMPONENT);
            this.myRunnersList.setModel(this.myListModel);
            this.myRunnersList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    RunnersEditorComponent.this.updateRunnerComponent();
                }
            });
            this.updateRunnerComponent();
            this.myRunnersList.setCellRenderer(new ColoredListCellRenderer(){

                protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                    Executor executor = (Executor)value;
                    this.setIcon(executor.getIcon());
                    this.append(executor.getId(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            });
        }

        private void updateRunnerComponent() {
            Executor executor = (Executor)this.myRunnersList.getSelectedValue();
            this.myLayout.show(this.myRunnerPanel, executor != null ? executor.getId() : NO_RUNNER_COMPONENT);
            this.myRunnersPanel.revalidate();
        }

        public void addExecutorComponent(Executor executor, JComponent component) {
            this.myRunnerPanel.add((Component)component, executor.getId());
            this.myListModel.addElement(executor);
            ListScrollingUtil.ensureSelectionExists((JList)this.myRunnersList);
        }

        public JComponent getComponent() {
            return this.myRunnersPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JPanel jPanel;
            JPanel jPanel2;
            this.myRunnersPanel = jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JBScrollPane jBScrollPane = new JBScrollPane();
            jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(-1, 50), null));
            JBList jBList = new JBList();
            this.myRunnersList = jBList;
            jBList.setSelectionMode(0);
            jBScrollPane.setViewportView((Component)jBList);
            this.myRunnerPanel = jPanel = new JPanel();
            jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myRunnersPanel;
        }
    }
}

