/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.scopeChooser;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.util.scopeChooser.FlattenPackagesAction;
import com.intellij.ide.util.scopeChooser.ShowFilesAction;
import com.intellij.ide.util.scopeChooser.ShowModuleGroupsAction;
import com.intellij.ide.util.scopeChooser.ShowModulesAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependencyUISettings;
import com.intellij.packageDependencies.ui.FileTreeModelBuilder;
import com.intellij.packageDependencies.ui.Marker;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.packageDependencies.ui.PackageTreeExpansionMonitor;
import com.intellij.packageDependencies.ui.PanelProgressIndicator;
import com.intellij.packageDependencies.ui.PatternDialectProvider;
import com.intellij.packageDependencies.ui.RootNode;
import com.intellij.packageDependencies.ui.TreeExpansionMonitor;
import com.intellij.packageDependencies.ui.TreeModel;
import com.intellij.psi.search.scope.packageSet.ComplementPackageSet;
import com.intellij.psi.search.scope.packageSet.IntersectionPackageSet;
import com.intellij.psi.search.scope.packageSet.InvalidPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.psi.search.scope.packageSet.PackageSetFactory;
import com.intellij.psi.search.scope.packageSet.UnionPackageSet;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DarculaColors;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopeEditorPanel {
    private JPanel myButtonsPanel;
    private RawCommandLineEditor myPatternField;
    private JPanel myTreeToolbar;
    private final Tree myPackageTree;
    private JPanel myPanel;
    private JPanel myTreePanel;
    private JLabel myMatchingCountLabel;
    private JPanel myLegendPanel;
    private final Project myProject;
    private final TreeExpansionMonitor myTreeExpansionMonitor;
    private final Marker myTreeMarker;
    private PackageSet myCurrentScope;
    private boolean myIsInUpdate;
    private String myErrorMessage;
    private final Alarm myUpdateAlarm;
    private JLabel myCaretPositionLabel;
    private int myCaretPosition;
    private JPanel myMatchingCountPanel;
    private JPanel myPositionPanel;
    private JLabel myRecursivelyIncluded;
    private JLabel myPartiallyIncluded;
    private PanelProgressIndicator myCurrentProgress;
    private NamedScopesHolder myHolder;

    public ScopeEditorPanel(final @NotNull Project project, NamedScopesHolder holder) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/util/scopeChooser/ScopeEditorPanel", "<init>"));
        }
        this.myCurrentScope = null;
        this.myIsInUpdate = false;
        this.$$$setupUI$$$();
        this.myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD);
        this.myCaretPosition = 0;
        this.myProject = project;
        this.myHolder = holder;
        this.myPackageTree = new Tree((TreeNode)new RootNode(project));
        this.myButtonsPanel.add(this.createActionsPanel());
        this.myTreePanel.setLayout(new BorderLayout());
        this.myTreePanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myPackageTree), "Center");
        this.myTreeToolbar.setLayout(new BorderLayout());
        this.myTreeToolbar.add((Component)this.createTreeToolbar(), "West");
        this.myTreeExpansionMonitor = PackageTreeExpansionMonitor.install((JTree)this.myPackageTree, this.myProject);
        this.myTreeMarker = new Marker(){

            @Override
            public boolean isMarked(VirtualFile file) {
                return ScopeEditorPanel.this.myCurrentScope != null && (ScopeEditorPanel.this.myCurrentScope instanceof PackageSetBase ? ((PackageSetBase)ScopeEditorPanel.this.myCurrentScope).contains(file, project, ScopeEditorPanel.this.myHolder) : ScopeEditorPanel.this.myCurrentScope.contains(PackageSetBase.getPsiFile((VirtualFile)file, (Project)ScopeEditorPanel.this.myProject), ScopeEditorPanel.this.myHolder));
            }
        };
        this.myPatternField.setDialogCaption("Pattern");
        this.myPatternField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(DocumentEvent event) {
                ScopeEditorPanel.this.onTextChange();
            }
        });
        this.myPatternField.getTextField().addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                ScopeEditorPanel.this.myCaretPosition = e.getDot();
                ScopeEditorPanel.this.updateCaretPositionText();
            }
        });
        this.myPatternField.getTextField().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (ScopeEditorPanel.this.myErrorMessage != null) {
                    ScopeEditorPanel.this.myPositionPanel.setVisible(true);
                    ScopeEditorPanel.this.myPanel.revalidate();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                ScopeEditorPanel.this.myPositionPanel.setVisible(false);
                ScopeEditorPanel.this.myPanel.revalidate();
            }
        });
        this.initTree(this.myPackageTree);
        new UiNotifyConnector((Component)this.myPanel, new Activatable(){

            public void showNotify() {
            }

            public void hideNotify() {
                ScopeEditorPanel.this.cancelCurrentProgress();
            }
        });
        this.myPartiallyIncluded.setBackground(MyTreeCellRenderer.PARTIAL_INCLUDED);
        this.myRecursivelyIncluded.setBackground(MyTreeCellRenderer.WHOLE_INCLUDED);
    }

    private void updateCaretPositionText() {
        if (this.myErrorMessage != null) {
            this.myCaretPositionLabel.setText(IdeBundle.message((String)"label.scope.editor.caret.position", (Object[])new Object[]{this.myCaretPosition + 1}));
        } else {
            this.myCaretPositionLabel.setText("");
        }
        this.myPositionPanel.setVisible(this.myErrorMessage != null);
        this.myCaretPositionLabel.setVisible(this.myErrorMessage != null);
        this.myPanel.revalidate();
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    public JPanel getTreePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.myTreePanel, "Center");
        panel.add((Component)this.myLegendPanel, "South");
        return panel;
    }

    public JPanel getTreeToolbar() {
        return this.myTreeToolbar;
    }

    private void onTextChange() {
        if (!this.myIsInUpdate) {
            this.myUpdateAlarm.cancelAllRequests();
            this.cancelCurrentProgress();
            String text = this.myPatternField.getText();
            this.myCurrentScope = new InvalidPackageSet(text);
            try {
                if (!StringUtil.isEmpty((String)text)) {
                    this.myCurrentScope = PackageSetFactory.getInstance().compile(text);
                }
                this.myErrorMessage = null;
            }
            catch (Exception e) {
                this.myErrorMessage = e.getMessage();
                this.showErrorMessage();
            }
            this.rebuild(false);
        } else if (!ScopeEditorPanel.invalidScopeInside(this.myCurrentScope)) {
            this.myErrorMessage = null;
        }
    }

    private static boolean invalidScopeInside(PackageSet currentScope) {
        if (currentScope instanceof InvalidPackageSet) {
            return true;
        }
        if (currentScope instanceof UnionPackageSet) {
            if (ScopeEditorPanel.invalidScopeInside(((UnionPackageSet)currentScope).getFirstSet())) {
                return true;
            }
            if (ScopeEditorPanel.invalidScopeInside(((UnionPackageSet)currentScope).getSecondSet())) {
                return true;
            }
        }
        if (currentScope instanceof IntersectionPackageSet) {
            if (ScopeEditorPanel.invalidScopeInside(((IntersectionPackageSet)currentScope).getFirstSet())) {
                return true;
            }
            if (ScopeEditorPanel.invalidScopeInside(((IntersectionPackageSet)currentScope).getSecondSet())) {
                return true;
            }
        }
        if (currentScope instanceof ComplementPackageSet) {
            return ScopeEditorPanel.invalidScopeInside(((ComplementPackageSet)currentScope).getComplementarySet());
        }
        return false;
    }

    private void showErrorMessage() {
        this.myMatchingCountLabel.setText(StringUtil.capitalize((String)this.myErrorMessage));
        this.myMatchingCountLabel.setForeground((Color)JBColor.red);
        this.myMatchingCountLabel.setToolTipText(this.myErrorMessage);
    }

    private JComponent createActionsPanel() {
        final JButton include = new JButton(IdeBundle.message((String)"button.include", (Object[])new Object[0]));
        final JButton includeRec = new JButton(IdeBundle.message((String)"button.include.recursively", (Object[])new Object[0]));
        final JButton exclude = new JButton(IdeBundle.message((String)"button.exclude", (Object[])new Object[0]));
        final JButton excludeRec = new JButton(IdeBundle.message((String)"button.exclude.recursively", (Object[])new Object[0]));
        this.myPackageTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                boolean recursiveEnabled = ScopeEditorPanel.isButtonEnabled(true, e.getPaths(), e);
                includeRec.setEnabled(recursiveEnabled);
                excludeRec.setEnabled(recursiveEnabled);
                boolean nonRecursiveEnabled = ScopeEditorPanel.isButtonEnabled(false, e.getPaths(), e);
                include.setEnabled(nonRecursiveEnabled);
                exclude.setEnabled(nonRecursiveEnabled);
            }
        });
        JPanel buttonsPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        buttonsPanel.add(include);
        buttonsPanel.add(includeRec);
        buttonsPanel.add(exclude);
        buttonsPanel.add(excludeRec);
        include.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScopeEditorPanel.this.includeSelected(false);
            }
        });
        includeRec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScopeEditorPanel.this.includeSelected(true);
            }
        });
        exclude.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScopeEditorPanel.this.excludeSelected(false);
            }
        });
        excludeRec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScopeEditorPanel.this.excludeSelected(true);
            }
        });
        return buttonsPanel;
    }

    static boolean isButtonEnabled(boolean rec, TreePath[] paths, TreeSelectionEvent e) {
        if (paths != null) {
            for (TreePath path : paths) {
                if (!e.isAddedPath(path)) continue;
                PackageDependenciesNode node = (PackageDependenciesNode)path.getLastPathComponent();
                if (PatternDialectProvider.getInstance(DependencyUISettings.getInstance().SCOPE_TYPE).createPackageSet(node, rec) == null) continue;
                return true;
            }
        }
        return false;
    }

    boolean isButtonEnabled(boolean rec) {
        TreePath[] paths = this.myPackageTree.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                PackageDependenciesNode node = (PackageDependenciesNode)path.getLastPathComponent();
                if (PatternDialectProvider.getInstance(DependencyUISettings.getInstance().SCOPE_TYPE).createPackageSet(node, rec) == null) continue;
                return true;
            }
        }
        return false;
    }

    private void excludeSelected(boolean recurse) {
        ArrayList<PackageSet> selected = this.getSelectedSets(recurse);
        if (selected == null || selected.isEmpty()) {
            return;
        }
        for (PackageSet set : selected) {
            if (this.myCurrentScope == null) {
                this.myCurrentScope = new ComplementPackageSet(set);
                continue;
            }
            if (this.myCurrentScope instanceof InvalidPackageSet) {
                this.myCurrentScope = StringUtil.isEmpty((String)this.myCurrentScope.getText()) ? new ComplementPackageSet(set) : new IntersectionPackageSet(this.myCurrentScope, (PackageSet)new ComplementPackageSet(set));
                continue;
            }
            boolean[] append = new boolean[]{true};
            PackageSet simplifiedScope = ScopeEditorPanel.processComplementaryScope(this.myCurrentScope, set, false, append);
            if (!append[0]) {
                this.myCurrentScope = simplifiedScope;
                continue;
            }
            this.myCurrentScope = simplifiedScope != null ? new IntersectionPackageSet(simplifiedScope, (PackageSet)new ComplementPackageSet(set)) : new ComplementPackageSet(set);
        }
        this.rebuild(true);
    }

    private void includeSelected(boolean recurse) {
        ArrayList<PackageSet> selected = this.getSelectedSets(recurse);
        if (selected == null || selected.isEmpty()) {
            return;
        }
        for (PackageSet set : selected) {
            if (this.myCurrentScope == null) {
                this.myCurrentScope = set;
                continue;
            }
            if (this.myCurrentScope instanceof InvalidPackageSet) {
                this.myCurrentScope = StringUtil.isEmpty((String)this.myCurrentScope.getText()) ? set : new UnionPackageSet(this.myCurrentScope, set);
                continue;
            }
            boolean[] append = new boolean[]{true};
            PackageSet simplifiedScope = ScopeEditorPanel.processComplementaryScope(this.myCurrentScope, set, true, append);
            if (!append[0]) {
                this.myCurrentScope = simplifiedScope;
                continue;
            }
            this.myCurrentScope = simplifiedScope != null ? new UnionPackageSet(simplifiedScope, set) : set;
        }
        this.rebuild(true);
    }

    @Nullable
    static PackageSet processComplementaryScope(@NotNull PackageSet current, PackageSet added, boolean checkComplementSet, boolean[] append) {
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/ide/util/scopeChooser/ScopeEditorPanel", "processComplementaryScope"));
        }
        String text = added.getText();
        if (current instanceof ComplementPackageSet && Comparing.strEqual((String)((ComplementPackageSet)current).getComplementarySet().getText(), (String)text)) {
            if (checkComplementSet) {
                append[0] = false;
            }
            return null;
        }
        if (Comparing.strEqual((String)current.getText(), (String)text)) {
            if (!checkComplementSet) {
                append[0] = false;
            }
            return null;
        }
        if (current instanceof UnionPackageSet) {
            PackageSet left = ScopeEditorPanel.processComplementaryScope(((UnionPackageSet)current).getFirstSet(), added, checkComplementSet, append);
            PackageSet right = ScopeEditorPanel.processComplementaryScope(((UnionPackageSet)current).getSecondSet(), added, checkComplementSet, append);
            if (left == null) {
                return right;
            }
            if (right == null) {
                return left;
            }
            return new UnionPackageSet(left, right);
        }
        if (current instanceof IntersectionPackageSet) {
            PackageSet left = ScopeEditorPanel.processComplementaryScope(((IntersectionPackageSet)current).getFirstSet(), added, checkComplementSet, append);
            PackageSet right = ScopeEditorPanel.processComplementaryScope(((IntersectionPackageSet)current).getSecondSet(), added, checkComplementSet, append);
            if (left == null) {
                return right;
            }
            if (right == null) {
                return left;
            }
            return new IntersectionPackageSet(left, right);
        }
        return current;
    }

    @Nullable
    private ArrayList<PackageSet> getSelectedSets(boolean recursively) {
        int[] rows = this.myPackageTree.getSelectionRows();
        if (rows == null) {
            return null;
        }
        ArrayList<PackageSet> result = new ArrayList<PackageSet>();
        for (int row : rows) {
            PackageDependenciesNode node = (PackageDependenciesNode)this.myPackageTree.getPathForRow(row).getLastPathComponent();
            PackageSet set = PatternDialectProvider.getInstance(DependencyUISettings.getInstance().SCOPE_TYPE).createPackageSet(node, recursively);
            if (set == null) continue;
            result.add(set);
        }
        return result;
    }

    private JComponent createTreeToolbar() {
        PatternDialectProvider[] dialectProviders;
        DefaultActionGroup group = new DefaultActionGroup();
        Runnable update = new Runnable(){

            @Override
            public void run() {
                ScopeEditorPanel.this.rebuild(true);
            }
        };
        if (ProjectViewDirectoryHelper.getInstance(this.myProject).supportsFlattenPackages()) {
            group.add((AnAction)new FlattenPackagesAction(update));
        }
        for (PatternDialectProvider provider : dialectProviders = (PatternDialectProvider[])Extensions.getExtensions(PatternDialectProvider.EP_NAME)) {
            for (AnAction action : provider.createActions(this.myProject, update)) {
                group.add(action);
            }
        }
        group.add((AnAction)new ShowFilesAction(update));
        Module[] modules = ModuleManager.getInstance((Project)this.myProject).getModules();
        if (modules.length > 1) {
            group.add((AnAction)new ShowModulesAction(update));
            group.add((AnAction)new ShowModuleGroupsAction(update));
        }
        group.add((AnAction)new FilterLegalsAction(update));
        if (dialectProviders.length > 1) {
            group.add((AnAction)new ChooseScopeTypeAction(update));
        }
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true);
        return toolbar.getComponent();
    }

    private void rebuild(final boolean updateText, final @Nullable Runnable runnable, final boolean requestFocus, int delayMillis) {
        this.myUpdateAlarm.cancelAllRequests();
        Runnable request = new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        if (updateText) {
                            final String text = ScopeEditorPanel.this.myCurrentScope != null ? ScopeEditorPanel.this.myCurrentScope.getText() : null;
                            SwingUtilities.invokeLater(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    try {
                                        ScopeEditorPanel.this.myIsInUpdate = true;
                                        ScopeEditorPanel.this.myPatternField.setText(text);
                                    }
                                    finally {
                                        ScopeEditorPanel.this.myIsInUpdate = false;
                                    }
                                }
                            });
                        }
                        try {
                            if (!ScopeEditorPanel.this.myProject.isDisposed()) {
                                ScopeEditorPanel.this.updateTreeModel(requestFocus);
                            }
                        }
                        catch (ProcessCanceledException e) {
                            return;
                        }
                        if (runnable != null) {
                            runnable.run();
                        }
                    }
                });
            }
        };
        this.myUpdateAlarm.addRequest(request, delayMillis);
    }

    private void rebuild(boolean updateText) {
        this.rebuild(updateText, null, true, 300);
    }

    public void setHolder(NamedScopesHolder holder) {
        this.myHolder = holder;
    }

    private void initTree(Tree tree) {
        tree.setCellRenderer((TreeCellRenderer)((Object)new MyTreeCellRenderer()));
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.setLineStyleAngled();
        TreeUtil.installActions((JTree)tree);
        SmartExpander.installOn((JTree)tree);
        new TreeSpeedSearch((JTree)tree);
        tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                ((PackageDependenciesNode)event.getPath().getLastPathComponent()).sortChildren();
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }
        });
        PopupHandler.installUnknownPopupHandler((JComponent)tree, (ActionGroup)this.createTreePopupActions(), (ActionManager)ActionManager.getInstance());
    }

    private ActionGroup createTreePopupActions() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add(new AnAction(IdeBundle.message((String)"button.include", (Object[])new Object[0])){

            public void actionPerformed(AnActionEvent e) {
                ScopeEditorPanel.this.includeSelected(false);
            }
        });
        actionGroup.add(new AnAction(IdeBundle.message((String)"button.include.recursively", (Object[])new Object[0])){

            public void actionPerformed(AnActionEvent e) {
                ScopeEditorPanel.this.includeSelected(true);
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(ScopeEditorPanel.this.isButtonEnabled(true));
            }
        });
        actionGroup.add(new AnAction(IdeBundle.message((String)"button.exclude", (Object[])new Object[0])){

            public void actionPerformed(AnActionEvent e) {
                ScopeEditorPanel.this.excludeSelected(false);
            }
        });
        actionGroup.add(new AnAction(IdeBundle.message((String)"button.exclude.recursively", (Object[])new Object[0])){

            public void actionPerformed(AnActionEvent e) {
                ScopeEditorPanel.this.excludeSelected(true);
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(ScopeEditorPanel.this.isButtonEnabled(true));
            }
        });
        return actionGroup;
    }

    private void updateTreeModel(final boolean requestFocus) throws ProcessCanceledException {
        PanelProgressIndicator progress = this.createProgressIndicator(requestFocus);
        progress.setBordersVisible(false);
        this.myCurrentProgress = progress;
        Runnable updateModel = new Runnable(){

            @Override
            public void run() {
                final ProcessCanceledException[] ex = new ProcessCanceledException[1];
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (ScopeEditorPanel.this.myProject.isDisposed()) {
                            return;
                        }
                        try {
                            ScopeEditorPanel.this.myTreeExpansionMonitor.freeze();
                            final TreeModel model = PatternDialectProvider.getInstance(DependencyUISettings.getInstance().SCOPE_TYPE).createTreeModel(ScopeEditorPanel.this.myProject, ScopeEditorPanel.this.myTreeMarker);
                            ((PackageDependenciesNode)model.getRoot()).sortChildren();
                            if (ScopeEditorPanel.this.myErrorMessage == null) {
                                ScopeEditorPanel.this.myMatchingCountLabel.setText(IdeBundle.message((String)"label.scope.contains.files", (Object[])new Object[]{model.getMarkedFileCount(), model.getTotalFileCount()}));
                                ScopeEditorPanel.this.myMatchingCountLabel.setForeground(new JLabel().getForeground());
                            } else {
                                ScopeEditorPanel.this.showErrorMessage();
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ScopeEditorPanel.this.myPackageTree.setModel((javax.swing.tree.TreeModel)model);
                                    ScopeEditorPanel.this.myTreeExpansionMonitor.restore();
                                }
                            });
                        }
                        catch (ProcessCanceledException e) {
                            ex[0] = e;
                        }
                        finally {
                            ScopeEditorPanel.this.myCurrentProgress = null;
                            ScopeEditorPanel.this.setToComponent(ScopeEditorPanel.this.myMatchingCountLabel, requestFocus);
                        }
                    }
                });
                if (ex[0] != null) {
                    throw ex[0];
                }
            }
        };
        ProgressManager.getInstance().runProcess(updateModel, (ProgressIndicator)progress);
    }

    private PanelProgressIndicator createProgressIndicator(boolean requestFocus) {
        return new MyPanelProgressIndicator(requestFocus);
    }

    public void cancelCurrentProgress() {
        if (this.myCurrentProgress != null) {
            this.myCurrentProgress.cancel();
        }
    }

    public void apply() throws ConfigurationException {
    }

    public PackageSet getCurrentScope() {
        return this.myCurrentScope;
    }

    public String getPatternText() {
        return this.myPatternField.getText();
    }

    public void reset(PackageSet packageSet, @Nullable Runnable runnable) {
        this.myCurrentScope = packageSet;
        this.myPatternField.setText(this.myCurrentScope == null ? "" : this.myCurrentScope.getText());
        this.rebuild(false, runnable, false, 0);
    }

    private void setToComponent(JComponent cmp, boolean requestFocus) {
        this.myMatchingCountPanel.removeAll();
        this.myMatchingCountPanel.add((Component)cmp, "Center");
        this.myMatchingCountPanel.revalidate();
        this.myMatchingCountPanel.repaint();
        if (requestFocus) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScopeEditorPanel.this.myPatternField.getTextField().requestFocusInWindow();
                }
            });
        }
    }

    public void restoreCanceledProgress() {
        if (this.myIsInUpdate) {
            this.rebuild(false);
        }
    }

    public void clearCaches() {
        FileTreeModelBuilder.clearCaches(this.myProject);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel;
        RawCommandLineEditor rawCommandLineEditor;
        JLabel jLabel3;
        JPanel jPanel2;
        JLabel jLabel4;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        JPanel jPanel6;
        JPanel jPanel7;
        this.myPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTreePanel = jPanel6 = new JPanel();
        jPanel7.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 3, new Dimension(-1, 150), null, null));
        this.myButtonsPanel = jPanel5 = new JPanel();
        jPanel7.add((Component)jPanel5, new GridConstraints(1, 1, 1, 1, 0, 3, 0, 3, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel8, new GridConstraints(0, 0, 1, 2, 0, 3, 1, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel9, new GridConstraints(1, 0, 1, 2, 0, 3, 1, 3, null, null, null));
        this.myTreeToolbar = jPanel4 = new JPanel();
        jPanel9.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 1, 0, null, null, null));
        this.myMatchingCountPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel9.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myMatchingCountLabel = jLabel4 = new JLabel();
        jLabel4.setHorizontalTextPosition(4);
        jLabel4.setText("");
        jLabel4.setHorizontalAlignment(4);
        jPanel3.add((Component)jLabel4, "Center");
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("messages/IdeBundle").getString("label.scope.pattern"));
        jPanel8.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPositionPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel2).setVisible(false);
        jPanel8.add((Component)jPanel2, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCaretPositionLabel = jLabel3 = new JLabel();
        ((Component)jLabel3).setVisible(false);
        jLabel3.setText("");
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPatternField = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel8.add((Component)rawCommandLineEditor, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myLegendPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 5, 0, 0), -1, -1, false, false));
        jPanel10.setOpaque(true);
        jPanel.add((Component)jPanel10, new GridConstraints(0, 1, 1, 1, 0, 3, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("messages/IdeBundle").getString("scope.editor.legend.recursively.included.label"));
        jPanel10.add((Component)jLabel6, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("messages/IdeBundle").getString("scope.editor.legend.partly.included.label"));
        jPanel10.add((Component)jLabel7, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRecursivelyIncluded = jLabel2 = new JLabel();
        jLabel2.setOpaque(true);
        ((Component)jLabel2).setBackground(new Color(-16724992));
        jLabel2.setText("");
        jLabel2.setIconTextGap(0);
        jPanel10.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, new Dimension(10, 10), new Dimension(10, 10), new Dimension(10, 10)));
        this.myPartiallyIncluded = jLabel = new JLabel();
        jLabel.setOpaque(true);
        ((Component)jLabel).setBackground(new Color(-16750900));
        jLabel.setText("");
        jLabel.setIconTextGap(0);
        jPanel10.add((Component)jLabel, new GridConstraints(0, 2, 1, 1, 4, 0, 0, 0, new Dimension(10, 10), new Dimension(10, 10), new Dimension(10, 10)));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    protected class MyPanelProgressIndicator
    extends PanelProgressIndicator {
        private final boolean myRequestFocus;

        public MyPanelProgressIndicator(final boolean requestFocus) {
            super(new Consumer<JComponent>(){

                public void consume(JComponent component) {
                    ScopeEditorPanel.this.setToComponent(component, requestFocus);
                }
            });
            this.myRequestFocus = requestFocus;
        }

        @Override
        public void stop() {
            super.stop();
            ScopeEditorPanel.this.setToComponent(ScopeEditorPanel.this.myMatchingCountLabel, this.myRequestFocus);
        }

        @Override
        public String getText() {
            return null;
        }

        @Override
        public String getText2() {
            return null;
        }
    }

    private final class FilterLegalsAction
    extends ToggleAction {
        private final Runnable myUpdate;

        public FilterLegalsAction(Runnable update) {
            super(IdeBundle.message((String)"action.show.included.only", (Object[])new Object[0]), IdeBundle.message((String)"action.description.show.included.only", (Object[])new Object[0]), AllIcons.General.Filter);
            this.myUpdate = update;
        }

        public boolean isSelected(AnActionEvent event) {
            return DependencyUISettings.getInstance().UI_FILTER_LEGALS;
        }

        public void setSelected(AnActionEvent event, boolean flag) {
            DependencyUISettings.getInstance().UI_FILTER_LEGALS = flag;
            UIUtil.setEnabled((Component)ScopeEditorPanel.this.myLegendPanel, (!flag ? 1 : 0) != 0, (boolean)true);
            this.myUpdate.run();
        }
    }

    private final class ChooseScopeTypeAction
    extends ComboBoxAction {
        private final Runnable myUpdate;

        public ChooseScopeTypeAction(Runnable update) {
            this.myUpdate = update;
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button) {
            DefaultActionGroup group = new DefaultActionGroup();
            for (final PatternDialectProvider provider : (PatternDialectProvider[])Extensions.getExtensions(PatternDialectProvider.EP_NAME)) {
                group.add(new AnAction(provider.getDisplayName()){

                    public void actionPerformed(AnActionEvent e) {
                        DependencyUISettings.getInstance().SCOPE_TYPE = provider.getShortName();
                        ChooseScopeTypeAction.this.myUpdate.run();
                    }
                });
            }
            DefaultActionGroup defaultActionGroup = group;
            if (defaultActionGroup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/scopeChooser/ScopeEditorPanel$ChooseScopeTypeAction", "createPopupActionGroup"));
            }
            return defaultActionGroup;
        }

        public void update(AnActionEvent e) {
            super.update(e);
            PatternDialectProvider provider = PatternDialectProvider.getInstance(DependencyUISettings.getInstance().SCOPE_TYPE);
            e.getPresentation().setText(provider.getDisplayName());
            e.getPresentation().setIcon(provider.getIcon());
        }
    }

    private static class MyTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private static final Color WHOLE_INCLUDED = new JBColor(new Color(10, 119, 0), new Color(10863196));
        private static final Color PARTIAL_INCLUDED = new JBColor(new Color(0, 50, 160), DarculaColors.BLUE);

        private MyTreeCellRenderer() {
        }

        public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof PackageDependenciesNode) {
                PackageDependenciesNode node = (PackageDependenciesNode)value;
                this.setIcon(node.getIcon());
                this.setForeground(selected && hasFocus ? UIUtil.getTreeSelectionForeground() : UIUtil.getTreeForeground());
                if (!(selected && hasFocus || !node.hasMarked() || DependencyUISettings.getInstance().UI_FILTER_LEGALS)) {
                    this.setForeground(node.hasUnmarked() ? PARTIAL_INCLUDED : WHOLE_INCLUDED);
                }
                this.append(node.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                String locationString = node.getComment();
                if (!StringUtil.isEmpty((String)locationString)) {
                    this.append(" (" + locationString + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            }
        }
    }
}

