/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarFinder;

import com.intellij.codeInsight.AttachSourcesProvider;
import com.intellij.jarFinder.MavenCentralSourceSearcher;
import com.intellij.jarFinder.SonatypeSourceSearcher;
import com.intellij.jarFinder.SourceSearchException;
import com.intellij.jarFinder.SourceSearcher;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.PathUIUtils;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.net.NetUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InternetAttachSourceProvider
implements AttachSourcesProvider {
    private static final Logger LOG = Logger.getInstance(InternetAttachSourceProvider.class);
    private static final Pattern ARTIFACT_IDENTIFIER = Pattern.compile("[A-Za-z0-9\\.\\-_]+");

    @Nullable
    protected static VirtualFile getJarByPsiFile(PsiFile psiFile) {
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile jar = JarFileSystem.getInstance().getVirtualFileForJar(psiFile.getVirtualFile());
        if (jar == null || !jar.getName().endsWith(".jar")) {
            return null;
        }
        return jar;
    }

    @NotNull
    public Collection<AttachSourcesProvider.AttachSourcesAction> getActions(List<LibraryOrderEntry> orderEntries, final PsiFile psiFile) {
        VirtualFile jar = InternetAttachSourceProvider.getJarByPsiFile(psiFile);
        if (jar == null) {
            List<AttachSourcesProvider.AttachSourcesAction> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarFinder/InternetAttachSourceProvider", "getActions"));
            }
            return list;
        }
        final String jarName = jar.getNameWithoutExtension();
        int index = jarName.lastIndexOf(45);
        if (index == -1) {
            List<AttachSourcesProvider.AttachSourcesAction> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarFinder/InternetAttachSourceProvider", "getActions"));
            }
            return list;
        }
        final String version = jarName.substring(index + 1);
        final String artifactId = jarName.substring(0, index);
        if (!ARTIFACT_IDENTIFIER.matcher(version).matches() || !ARTIFACT_IDENTIFIER.matcher(artifactId).matches()) {
            List<AttachSourcesProvider.AttachSourcesAction> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarFinder/InternetAttachSourceProvider", "getActions"));
            }
            return list;
        }
        final HashSet libraries = new HashSet();
        for (LibraryOrderEntry orderEntry : orderEntries) {
            ContainerUtil.addIfNotNull(libraries, (Object)orderEntry.getLibrary());
        }
        if (libraries.isEmpty()) {
            List<AttachSourcesProvider.AttachSourcesAction> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarFinder/InternetAttachSourceProvider", "getActions"));
            }
            return list;
        }
        final String sourceFileName = jarName + "-sources.jar";
        for (Library library : libraries) {
            for (VirtualFile file : library.getFiles(OrderRootType.SOURCES)) {
                if (!file.getPath().contains(sourceFileName) || !InternetAttachSourceProvider.isRootInExistingFile(file)) continue;
                List<AttachSourcesProvider.AttachSourcesAction> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarFinder/InternetAttachSourceProvider", "getActions"));
                }
                return list;
            }
        }
        final File libSourceDir = InternetAttachSourceProvider.getLibrarySourceDir();
        final File sourceFile = new File(libSourceDir, sourceFileName);
        if (sourceFile.exists()) {
            Set<1> set = Collections.singleton(new AttachSourcesProvider.LightAttachSourcesAction(){

                public String getName() {
                    return "Attach downloaded source";
                }

                public String getBusyText() {
                    return this.getName();
                }

                public ActionCallback perform(List<LibraryOrderEntry> orderEntriesContainingFile) {
                    InternetAttachSourceProvider.attachSourceJar(sourceFile, libraries);
                    return new ActionCallback.Done();
                }
            });
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarFinder/InternetAttachSourceProvider", "getActions"));
            }
            return set;
        }
        Set<2> set = Collections.singleton(new AttachSourcesProvider.LightAttachSourcesAction(){

            public String getName() {
                return "Download...";
            }

            public String getBusyText() {
                return "Searching...";
            }

            public ActionCallback perform(List<LibraryOrderEntry> orderEntriesContainingFile) {
                Task.Modal task = new Task.Modal(psiFile.getProject(), "Searching source...", true){

                    public void run(final @NotNull ProgressIndicator indicator) {
                        SourceSearcher[] searchers;
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/jarFinder/InternetAttachSourceProvider$2$1", "run"));
                        }
                        String artifactUrl = null;
                        for (SourceSearcher searcher : searchers = new SourceSearcher[]{new MavenCentralSourceSearcher(), new SonatypeSourceSearcher()}) {
                            try {
                                artifactUrl = searcher.findSourceJar(indicator, artifactId, version);
                            }
                            catch (SourceSearchException e) {
                                LOG.warn((Throwable)e);
                                this.showMessage("Downloading failed", e.getMessage(), NotificationType.ERROR);
                                continue;
                            }
                            if (artifactUrl != null) break;
                        }
                        if (artifactUrl == null) {
                            this.showMessage("Sources not found", "Sources for '" + jarName + ".jar' not found", NotificationType.WARNING);
                            return;
                        }
                        if (!libSourceDir.isDirectory() && !libSourceDir.mkdirs()) {
                            this.showMessage("Downloading failed", "Failed to create directory to store sources: " + libSourceDir, NotificationType.ERROR);
                            return;
                        }
                        try {
                            File tmpDownload = (File)HttpRequests.request(artifactUrl).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<File>(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public File process(@NotNull HttpRequests.Request request) throws IOException {
                                    if (request == null) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/jarFinder/InternetAttachSourceProvider$2$1$1", "process"));
                                    }
                                    File tmpDownload = FileUtil.createTempFile((File)libSourceDir, (String)"download.", (String)".tmp", (boolean)false, (boolean)false);
                                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tmpDownload));
                                    try {
                                        NetUtils.copyStreamContent((ProgressIndicator)indicator, (InputStream)request.getInputStream(), (OutputStream)out, (int)request.getConnection().getContentLength());
                                    }
                                    finally {
                                        ((OutputStream)out).close();
                                    }
                                    return tmpDownload;
                                }
                            });
                            if (!sourceFile.exists() && !tmpDownload.renameTo(sourceFile)) {
                                LOG.warn("Failed to rename file " + tmpDownload + " to " + sourceFileName);
                            }
                        }
                        catch (IOException e) {
                            LOG.warn((Throwable)e);
                            this.showMessage("Downloading failed", "Connection problem. See log for more details.", NotificationType.ERROR);
                        }
                    }

                    public void onSuccess() {
                        InternetAttachSourceProvider.attachSourceJar(sourceFile, libraries);
                    }

                    private void showMessage(String title, String message, NotificationType notificationType) {
                        new Notification("Source searcher", title, message, notificationType).notify(this.getProject());
                    }
                };
                task.queue();
                return new ActionCallback.Done();
            }
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarFinder/InternetAttachSourceProvider", "getActions"));
        }
        return set;
    }

    private static boolean isRootInExistingFile(VirtualFile root) {
        VirtualFile jar;
        return !(root.getFileSystem() instanceof JarFileSystem) || (jar = JarFileSystem.getInstance().getVirtualFileForJar(root)) != null && VfsUtilCore.virtualToIoFile((VirtualFile)jar).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void attachSourceJar(@NotNull File sourceJar, @NotNull Collection<Library> libraries) {
        if (sourceJar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceJar", "com/intellij/jarFinder/InternetAttachSourceProvider", "attachSourceJar"));
        }
        if (libraries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraries", "com/intellij/jarFinder/InternetAttachSourceProvider", "attachSourceJar"));
        }
        AccessToken accessToken = WriteAction.start();
        try {
            VirtualFile srcFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(sourceJar);
            if (srcFile == null) {
                return;
            }
            VirtualFile jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(srcFile);
            if (jarRoot == null) {
                return;
            }
            VirtualFile[] roots = PathUIUtils.scanAndSelectDetectedJavaSourceRoots(null, new VirtualFile[]{jarRoot});
            if (roots.length == 0) {
                roots = new VirtualFile[]{jarRoot};
            }
            for (Library library : libraries) {
                Library.ModifiableModel model = library.getModifiableModel();
                List<VirtualFile> alreadyExistingFiles = Arrays.asList(model.getFiles(OrderRootType.SOURCES));
                for (VirtualFile root : roots) {
                    if (alreadyExistingFiles.contains(root)) continue;
                    model.addRoot(root, OrderRootType.SOURCES);
                }
                model.commit();
            }
        }
        finally {
            accessToken.finish();
        }
    }

    public static File getLibrarySourceDir() {
        String path = System.getProperty("idea.library.source.dir");
        if (path != null) {
            return new File(path);
        }
        return new File(SystemProperties.getUserHome(), ".ideaLibSources");
    }
}

