/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.external;

import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.external.DiffManagerImpl;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.BooleanProperty;
import com.intellij.util.config.StringProperty;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffOptionsForm
implements SearchableConfigurable,
Configurable.NoScroll {
    private JComponent myPanel;
    private JCheckBox myEnableFolders;
    private JCheckBox myEnableFiles;
    private TextFieldWithBrowseButton myFoldersTool;
    private TextFieldWithBrowseButton myFilesTool;
    private TextFieldWithBrowseButton myMergeTool;
    private JCheckBox myEnableMerge;
    private JTextField myMergeParameters;
    private final ToolPath[] myTools = new ToolPath[3];

    public DiffOptionsForm() {
        this.$$$setupUI$$$();
        this.myTools[0] = new ToolPath(this.myEnableFolders, this.myFoldersTool, null, DiffManagerImpl.FOLDERS_TOOL, DiffManagerImpl.ENABLE_FOLDERS, null);
        this.myTools[1] = new ToolPath(this.myEnableFiles, this.myFilesTool, null, DiffManagerImpl.FILES_TOOL, DiffManagerImpl.ENABLE_FILES, null);
        this.myTools[2] = new ToolPath(this.myEnableMerge, this.myMergeTool, this.myMergeParameters, DiffManagerImpl.MERGE_TOOL, DiffManagerImpl.ENABLE_MERGE, DiffManagerImpl.MERGE_TOOL_PARAMETERS);
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        for (ToolPath tool : this.myTools) {
            if (!tool.isModifier()) continue;
            return true;
        }
        return false;
    }

    public void apply() {
        for (ToolPath tool : this.myTools) {
            tool.apply();
        }
    }

    public void reset() {
        for (ToolPath tool : this.myTools) {
            tool.reset();
        }
    }

    public void disposeUIResources() {
    }

    @Nls
    public String getDisplayName() {
        return "External Diff Tools";
    }

    public String getHelpTopic() {
        return "diff";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/external/DiffOptionsForm", "getId"));
        }
        return string;
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JTextField jTextField;
        TextFieldWithBrowseButton textFieldWithBrowseButton3;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel = new JPanel();
        this.myPanel = jPanel;
        jPanel.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myEnableFolders = jCheckBox3 = new JCheckBox();
        jCheckBox3.setMargin(new Insets(4, 2, 0, 2));
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/DiffBundle").getString("diff.options.use.external.tool.for.directories.checkbox"));
        jPanel.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myEnableFiles = jCheckBox2 = new JCheckBox();
        jCheckBox2.setMargin(new Insets(4, 2, 0, 2));
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/DiffBundle").getString("diff.options.use.external.tool.for.files.checkbox"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(8, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myEnableMerge = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/DiffBundle").getString("diff.options.use.external.merge.tool.for.files.checkbox"));
        jPanel.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("<html>Different merge tools have different parameters. It's important to specify all necessary parameters in proper order<br>\n<b>%1</b> - left (Local changes)<br>\n<b>%2</b> - base (Current version without local changes)<br>\n<b>%3</b> - right (Server content)<br>\n<b>%4</b> - output path</html>");
        jPanel.add((Component)jLabel, new GridConstraints(7, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myMergeTool = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton3.setText("");
        jPanel.add((Component)textFieldWithBrowseButton3, new GridConstraints(5, 1, 1, 1, 8, 1, 7, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Path to executable:");
        jPanel.add((Component)jLabel2, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Parameters:");
        jPanel.add((Component)jLabel3, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMergeParameters = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(6, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myFilesTool = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton2.setText("");
        jPanel.add((Component)textFieldWithBrowseButton2, new GridConstraints(3, 1, 1, 1, 8, 1, 7, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Path to executable:");
        jPanel.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFoldersTool = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setText("");
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 8, 1, 7, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Path to executable:");
        jPanel.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class ToolPath {
        private final JCheckBox myCheckBox;
        private final TextFieldWithBrowseButton myTextField;
        private final StringProperty myPathProperty;
        private final BooleanProperty myEnabledProperty;
        @Nullable
        private final JTextField myParameters;
        @Nullable
        private final StringProperty myParametersProperty;

        public ToolPath(JCheckBox checkBox, TextFieldWithBrowseButton textField, @Nullable JTextField parameters, StringProperty pathProperty, BooleanProperty enabledProperty, @Nullable StringProperty parametersProperty) {
            this.myCheckBox = checkBox;
            this.myTextField = textField;
            this.myPathProperty = pathProperty;
            this.myEnabledProperty = enabledProperty;
            this.myParameters = parameters;
            this.myParametersProperty = parametersProperty;
            ButtonModel model = this.myCheckBox.getModel();
            model.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ToolPath.this.updateEnabledEffect();
                }
            });
            this.myTextField.addBrowseFolderListener(DiffBundle.message((String)"select.external.diff.program.dialog.title", (Object[])new Object[0]), null, null, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor(), TextComponentAccessor.TEXT_FIELD_SELECTED_TEXT);
        }

        private void updateEnabledEffect() {
            UIUtil.setEnabled((Component)this.myTextField, (boolean)this.isEnabled(), (boolean)true);
            if (this.myParameters != null) {
                UIUtil.setEnabled((Component)this.myParameters, (boolean)this.isEnabled(), (boolean)true);
            }
        }

        public boolean isModifier() {
            AbstractProperty.AbstractPropertyContainer properties = ToolPath.getProperties();
            return !this.myTextField.getText().equals(this.myPathProperty.get(properties)) || this.isEnabled() != this.myEnabledProperty.value(properties) || this.myParametersProperty != null && this.myParameters != null && !this.myParameters.getText().equals(this.myParametersProperty.get(properties));
        }

        private boolean isEnabled() {
            return this.myCheckBox.getModel().isSelected();
        }

        private static AbstractProperty.AbstractPropertyContainer getProperties() {
            return DiffManagerImpl.getInstanceEx().getProperties();
        }

        public void apply() {
            this.myPathProperty.set(ToolPath.getProperties(), (Object)this.myTextField.getText());
            this.myEnabledProperty.primSet(ToolPath.getProperties(), this.isEnabled());
            if (this.myParameters != null && this.myParametersProperty != null) {
                this.myParametersProperty.set(ToolPath.getProperties(), (Object)this.myParameters.getText());
            }
        }

        public void reset() {
            this.myTextField.setText((String)this.myPathProperty.get(ToolPath.getProperties()));
            this.myCheckBox.getModel().setSelected(this.myEnabledProperty.value(ToolPath.getProperties()));
            if (this.myParameters != null && this.myParametersProperty != null) {
                this.myParameters.setText((String)this.myParametersProperty.get(ToolPath.getProperties()));
            }
            this.updateEnabledEffect();
        }
    }
}

