/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.SettingsSavingComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.internal.InternalExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ConcurrentHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalProjectsDataStorage
implements SettingsSavingComponent {
    private static final Logger LOG = Logger.getInstance(ExternalProjectsDataStorage.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<Pair<ProjectSystemId, String>, InternalExternalProjectInfo> myExternalRootProjects;

    public static ExternalProjectsDataStorage getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsDataStorage", "getInstance"));
        }
        return (ExternalProjectsDataStorage)ServiceManager.getService((Project)project, ExternalProjectsDataStorage.class);
    }

    public ExternalProjectsDataStorage(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsDataStorage", "<init>"));
        }
        this.myExternalRootProjects = new ConcurrentHashMap();
        this.myProject = project;
    }

    public void load() {
    }

    public void save() {
    }

    void add(@NotNull ExternalProjectInfo externalProjectInfo) {
        if (externalProjectInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjectInfo", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsDataStorage", "add"));
        }
        ProjectSystemId projectSystemId = externalProjectInfo.getProjectSystemId();
        String projectPath = externalProjectInfo.getExternalProjectPath();
        DataNode<ProjectData> externalProjectStructure = externalProjectInfo.getExternalProjectStructure();
        long lastSuccessfulImportTimestamp = externalProjectInfo.getLastSuccessfulImportTimestamp();
        long lastImportTimestamp = externalProjectInfo.getLastImportTimestamp();
        Pair key = Pair.create((Object)projectSystemId, (Object)projectPath);
        InternalExternalProjectInfo old = this.myExternalRootProjects.get(key);
        if (old != null) {
            lastImportTimestamp = externalProjectInfo.getLastImportTimestamp();
            if (lastSuccessfulImportTimestamp == -1L) {
                lastSuccessfulImportTimestamp = old.getLastSuccessfulImportTimestamp();
            }
            if (externalProjectInfo.getExternalProjectStructure() == null) {
                externalProjectStructure = old.getExternalProjectStructure();
            }
        }
        InternalExternalProjectInfo merged = new InternalExternalProjectInfo(projectSystemId, projectPath, externalProjectStructure);
        merged.setLastImportTimestamp(lastImportTimestamp);
        merged.setLastSuccessfulImportTimestamp(lastSuccessfulImportTimestamp);
        this.myExternalRootProjects.put((Pair<ProjectSystemId, String>)key, merged);
    }

    @Nullable
    ExternalProjectInfo get(@NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath) {
        if (projectSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSystemId", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsDataStorage", "get"));
        }
        if (externalProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjectPath", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsDataStorage", "get"));
        }
        return this.myExternalRootProjects.get(Pair.create((Object)projectSystemId, (Object)externalProjectPath));
    }
}

