/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.settings;

import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemSettingsControl;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.PaintAwarePanel;
import com.intellij.ui.components.JBCheckBox;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractExternalProjectSettingsControl<S extends ExternalProjectSettings>
implements ExternalSystemSettingsControl<S> {
    @NotNull
    private S myInitialSettings;
    private JBCheckBox myUseAutoImportBox;
    private JBCheckBox myCreateEmptyContentRootDirectoriesBox;
    private boolean myHideUseAutoImportBox;

    protected AbstractExternalProjectSettingsControl(@NotNull S initialSettings) {
        if (initialSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialSettings", "com/intellij/openapi/externalSystem/service/settings/AbstractExternalProjectSettingsControl", "<init>"));
        }
        this.myInitialSettings = initialSettings;
    }

    @NotNull
    public S getInitialSettings() {
        S s = this.myInitialSettings;
        if (s == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/settings/AbstractExternalProjectSettingsControl", "getInitialSettings"));
        }
        return s;
    }

    public void hideUseAutoImportBox() {
        this.myHideUseAutoImportBox = true;
    }

    @Override
    public void fillUi(@NotNull PaintAwarePanel canvas, int indentLevel) {
        if (canvas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "canvas", "com/intellij/openapi/externalSystem/service/settings/AbstractExternalProjectSettingsControl", "fillUi"));
        }
        this.myUseAutoImportBox = new JBCheckBox(ExternalSystemBundle.message((String)"settings.label.use.auto.import", (Object[])new Object[0]));
        this.myUseAutoImportBox.setVisible(!this.myHideUseAutoImportBox);
        canvas.add((Component)this.myUseAutoImportBox, ExternalSystemUiUtil.getFillLineConstraints(indentLevel));
        this.myCreateEmptyContentRootDirectoriesBox = new JBCheckBox(ExternalSystemBundle.message((String)"settings.label.create.empty.content.root.directories", (Object[])new Object[0]));
        canvas.add((Component)this.myCreateEmptyContentRootDirectoriesBox, ExternalSystemUiUtil.getFillLineConstraints(indentLevel));
        this.fillExtraControls(canvas, indentLevel);
    }

    protected abstract void fillExtraControls(@NotNull PaintAwarePanel var1, int var2);

    @Override
    public boolean isModified() {
        return this.myUseAutoImportBox.isSelected() != this.getInitialSettings().isUseAutoImport() || this.myCreateEmptyContentRootDirectoriesBox.isSelected() != this.getInitialSettings().isCreateEmptyContentRootDirectories() || this.isExtraSettingModified();
    }

    protected abstract boolean isExtraSettingModified();

    @Override
    public void reset() {
        this.reset(false);
    }

    public void reset(boolean isDefaultModuleCreation) {
        this.myUseAutoImportBox.setSelected(this.getInitialSettings().isUseAutoImport());
        this.myCreateEmptyContentRootDirectoriesBox.setSelected(this.getInitialSettings().isCreateEmptyContentRootDirectories());
        this.resetExtraSettings(isDefaultModuleCreation);
    }

    protected abstract void resetExtraSettings(boolean var1);

    @Override
    public void apply(@NotNull S settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/externalSystem/service/settings/AbstractExternalProjectSettingsControl", "apply"));
        }
        settings.setUseAutoImport(this.myUseAutoImportBox.isSelected());
        settings.setCreateEmptyContentRootDirectories(this.myCreateEmptyContentRootDirectoriesBox.isSelected());
        if (this.myInitialSettings.getExternalProjectPath() != null) {
            settings.setExternalProjectPath(this.myInitialSettings.getExternalProjectPath());
        }
        this.applyExtraSettings(settings);
    }

    protected abstract void applyExtraSettings(@NotNull S var1);

    @Override
    public void disposeUIResources() {
        ExternalSystemUiUtil.disposeUi(this);
    }

    @Override
    public void showUi(boolean show) {
        ExternalSystemUiUtil.showUi(this, show);
    }

    public void updateInitialSettings() {
        this.myInitialSettings.setUseAutoImport(this.myUseAutoImportBox.isSelected());
        this.myInitialSettings.setCreateEmptyContentRootDirectories(this.myCreateEmptyContentRootDirectoriesBox.isSelected());
        this.updateInitialExtraSettings();
    }

    protected void updateInitialExtraSettings() {
    }
}

