/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.keymap.impl.ui.ActionsTreeUtil;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionsTree {
    private static final Icon EMPTY_ICON = EmptyIcon.ICON_18;
    private static final Icon OPEN_ICON = new DefaultTreeCellRenderer().getOpenIcon();
    private static final Icon CLOSE_ICON = AllIcons.Nodes.Folder;
    private final JTree myTree;
    private DefaultMutableTreeNode myRoot;
    private final JScrollPane myComponent;
    private Keymap myKeymap;
    private Group myMainGroup = new Group("", null, null);
    private boolean myShowBoundActions = Registry.is((String)"keymap.show.alias.actions");
    @NonNls
    private static final String ROOT = "ROOT";
    private String myFilter = null;

    public ActionsTree() {
        this.myRoot = new DefaultMutableTreeNode(ROOT);
        this.myTree = new Tree(new MyModel(this.myRoot)){

            public void paint(Graphics g) {
                super.paint(g);
                Rectangle visibleRect = this.getVisibleRect();
                Rectangle clip = g.getClipBounds();
                for (int row = 0; row < this.getRowCount(); ++row) {
                    Object node;
                    Rectangle rowBounds = this.getRowBounds(row);
                    rowBounds.x = 0;
                    rowBounds.width = Integer.MAX_VALUE;
                    if (!rowBounds.intersects(clip) || !((node = this.getPathForRow(row).getLastPathComponent()) instanceof DefaultMutableTreeNode)) continue;
                    Object data = ((DefaultMutableTreeNode)node).getUserObject();
                    Rectangle fullRowRect = new Rectangle(visibleRect.x, rowBounds.y, visibleRect.width, rowBounds.height);
                    ActionsTree.this.paintRowData(this, data, fullRowRect, (Graphics2D)g);
                }
            }
        };
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.putClientProperty("mac.ui.striped", Boolean.TRUE);
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new KeymapsRenderer()));
        this.myTree.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                String description = this.getDescription(e);
                if (description != null) {
                    ActionMenu.showDescriptionInStatusBar(true, ActionsTree.this.myTree, description);
                } else {
                    ActionMenu.showDescriptionInStatusBar(false, ActionsTree.this.myTree, null);
                }
            }

            @Nullable
            private String getDescription(@NotNull MouseEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/ActionsTree$2", "getDescription"));
                }
                TreePath path = ActionsTree.this.myTree.getPathForLocation(e.getX(), e.getY());
                if (path == null) {
                    return null;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (node == null) {
                    return null;
                }
                Object userObject = node.getUserObject();
                if (!(userObject instanceof String)) {
                    return null;
                }
                String actionId = (String)userObject;
                AnAction action = ActionManager.getInstance().getActionOrStub(actionId);
                if (action == null) {
                    return null;
                }
                return action.getTemplatePresentation().getDescription();
            }
        });
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myComponent = ScrollPaneFactory.createScrollPane((Component)this.myTree, (int)22, (int)31);
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public void addTreeSelectionListener(TreeSelectionListener l) {
        this.myTree.getSelectionModel().addTreeSelectionListener(l);
    }

    @Nullable
    private Object getSelectedObject() {
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        return ((DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject();
    }

    @Nullable
    public String getSelectedActionId() {
        Object userObject = this.getSelectedObject();
        if (userObject instanceof String) {
            return (String)userObject;
        }
        if (userObject instanceof QuickList) {
            return ((QuickList)userObject).getActionId();
        }
        return null;
    }

    @Nullable
    public QuickList getSelectedQuickList() {
        Object userObject = this.getSelectedObject();
        if (!(userObject instanceof QuickList)) {
            return null;
        }
        return (QuickList)userObject;
    }

    public void reset(Keymap keymap, QuickList[] allQuickLists) {
        this.reset(keymap, allQuickLists, this.myFilter, null);
    }

    public Group getMainGroup() {
        return this.myMainGroup;
    }

    public JTree getTree() {
        return this.myTree;
    }

    public void filter(String filter, QuickList[] currentQuickListIds) {
        this.myFilter = filter;
        this.reset(this.myKeymap, currentQuickListIds, filter, null);
    }

    private void reset(Keymap keymap, QuickList[] allQuickLists, String filter, @Nullable KeyboardShortcut shortcut) {
        this.myKeymap = keymap;
        PathsKeeper pathsKeeper = new PathsKeeper();
        pathsKeeper.storePaths();
        this.myRoot.removeAllChildren();
        ActionManager actionManager = ActionManager.getInstance();
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.myComponent));
        Group mainGroup = ActionsTreeUtil.createMainGroup(project, this.myKeymap, allQuickLists, filter, true, ActionsTreeUtil.isActionFiltered(actionManager, this.myKeymap, shortcut, filter, true));
        if ((filter != null && filter.length() > 0 || shortcut != null) && mainGroup.initIds().isEmpty()) {
            mainGroup = ActionsTreeUtil.createMainGroup(project, this.myKeymap, allQuickLists, filter, false, ActionsTreeUtil.isActionFiltered(actionManager, this.myKeymap, shortcut, filter, false));
        }
        this.myRoot = ActionsTreeUtil.createNode(mainGroup);
        this.myMainGroup = mainGroup;
        MyModel model = (MyModel)this.myTree.getModel();
        model.setRoot(this.myRoot);
        model.nodeStructureChanged(this.myRoot);
        pathsKeeper.restorePaths();
    }

    public void filterTree(KeyboardShortcut keyboardShortcut, QuickList[] currentQuickListIds) {
        this.reset(this.myKeymap, currentQuickListIds, this.myFilter, keyboardShortcut);
    }

    private static boolean isActionChanged(String actionId, Keymap oldKeymap, Keymap newKeymap) {
        Object[] newShortcuts;
        if (!newKeymap.canModify()) {
            return false;
        }
        Object[] oldShortcuts = oldKeymap.getShortcuts(actionId);
        return !Comparing.equal((Object[])oldShortcuts, (Object[])(newShortcuts = newKeymap.getShortcuts(actionId)));
    }

    private static boolean isGroupChanged(Group group, Keymap oldKeymap, Keymap newKeymap) {
        if (!newKeymap.canModify()) {
            return false;
        }
        ArrayList<Object> children = group.getChildren();
        for (Object child : children) {
            String actionId;
            if (!(child instanceof Group ? ActionsTree.isGroupChanged((Group)child, oldKeymap, newKeymap) : (child instanceof String ? ActionsTree.isActionChanged(actionId = (String)child, oldKeymap, newKeymap) : child instanceof QuickList && ActionsTree.isActionChanged(actionId = ((QuickList)child).getActionId(), oldKeymap, newKeymap)))) continue;
            return true;
        }
        return false;
    }

    public void selectAction(String actionId) {
        JTree tree = this.myTree;
        String path = this.myMainGroup.getActionQualifiedPath(actionId);
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode node = this.getNodeForPath(path);
        if (node == null) {
            return;
        }
        TreeUtil.selectInTree((DefaultMutableTreeNode)node, (boolean)true, (JTree)tree);
    }

    @Nullable
    private DefaultMutableTreeNode getNodeForPath(String path) {
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)this.myTree.getModel().getRoot()).preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!Comparing.equal((String)this.getPath(node), (String)path)) continue;
            return node;
        }
        return null;
    }

    private ArrayList<DefaultMutableTreeNode> getNodesByPaths(ArrayList<String> paths) {
        ArrayList<DefaultMutableTreeNode> result = new ArrayList<DefaultMutableTreeNode>();
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)this.myTree.getModel().getRoot()).preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
            String path = this.getPath(node);
            if (!paths.contains(path)) continue;
            result.add(node);
        }
        return result;
    }

    @Nullable
    private String getPath(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof String) {
            Object object;
            String actionId = (String)userObject;
            TreeNode parent = node.getParent();
            if (parent instanceof DefaultMutableTreeNode && (object = ((DefaultMutableTreeNode)parent).getUserObject()) instanceof Group) {
                return ((Group)object).getActionQualifiedPath(actionId);
            }
            return this.myMainGroup.getActionQualifiedPath(actionId);
        }
        if (userObject instanceof Group) {
            return ((Group)userObject).getQualifiedPath();
        }
        if (userObject instanceof QuickList) {
            return ((QuickList)userObject).getDisplayName();
        }
        return null;
    }

    public static Icon getEvenIcon(Icon icon) {
        LayeredIcon layeredIcon = new LayeredIcon(2);
        layeredIcon.setIcon(EMPTY_ICON, 0);
        if (icon != null && icon.getIconHeight() <= EMPTY_ICON.getIconHeight() && icon.getIconWidth() <= EMPTY_ICON.getIconWidth()) {
            layeredIcon.setIcon(icon, 1, (-icon.getIconWidth() + EMPTY_ICON.getIconWidth()) / 2, (EMPTY_ICON.getIconHeight() - icon.getIconHeight()) / 2);
        }
        return layeredIcon;
    }

    private void paintRowData(Tree tree, Object data, Rectangle bounds, Graphics2D g) {
        Color c2;
        Color c1;
        int fontHeight;
        Shortcut[] shortcuts = null;
        Set abbreviations = null;
        if (data instanceof String) {
            String actionId = (String)data;
            shortcuts = this.myKeymap.getShortcuts(actionId);
            abbreviations = AbbreviationManager.getInstance().getAbbreviations(actionId);
        } else if (data instanceof QuickList) {
            shortcuts = this.myKeymap.getShortcuts(((QuickList)data).getActionId());
        }
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
        int totalWidth = 0;
        FontMetrics metrics = tree.getFontMetrics(tree.getFont());
        if (shortcuts != null && shortcuts.length > 0) {
            for (Shortcut shortcut : shortcuts) {
                totalWidth += metrics.stringWidth(KeymapUtil.getShortcutText((Shortcut)shortcut));
                totalWidth += 10;
            }
            int x = bounds.x + bounds.width - (totalWidth -= 5);
            fontHeight = (int)metrics.getMaxCharBounds(g).getHeight();
            c1 = new Color(234, 200, 162);
            c2 = new Color(208, 200, 66);
            g.translate(0, bounds.y - 1);
            for (Shortcut shortcut : shortcuts) {
                int width = metrics.stringWidth(KeymapUtil.getShortcutText((Shortcut)shortcut));
                UIUtil.drawSearchMatch((Graphics2D)g, (int)x, (int)(x + width), (int)bounds.height, (Color)c1, (Color)c2);
                g.setColor((Color)Gray._50);
                g.drawString(KeymapUtil.getShortcutText((Shortcut)shortcut), x, fontHeight);
                x += width;
                x += 10;
            }
            g.translate(0, -bounds.y + 1);
        }
        if (Registry.is((String)"actionSystem.enableAbbreviations") && abbreviations != null && abbreviations.size() > 0) {
            for (String abbreviation : abbreviations) {
                totalWidth += metrics.stringWidth(abbreviation);
                totalWidth += 10;
            }
            int x = bounds.x + bounds.width - (totalWidth -= 5);
            fontHeight = (int)metrics.getMaxCharBounds(g).getHeight();
            c1 = new Color(206, 234, 176);
            c2 = new Color(126, 208, 82);
            g.translate(0, bounds.y - 1);
            for (String abbreviation : abbreviations) {
                int width = metrics.stringWidth(abbreviation);
                UIUtil.drawSearchMatch((Graphics2D)g, (int)x, (int)(x + width), (int)bounds.height, (Color)c1, (Color)c2);
                g.setColor((Color)Gray._50);
                g.drawString(abbreviation, x, fontHeight);
                x += width;
                x += 10;
            }
            g.translate(0, -bounds.y + 1);
        }
        config.restore();
    }

    private class KeymapsRenderer
    extends ColoredTreeCellRenderer {
        private KeymapsRenderer() {
        }

        public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            boolean showIcons = UISettings.getInstance().SHOW_ICONS_IN_MENUS;
            Keymap originalKeymap = ActionsTree.this.myKeymap != null ? ActionsTree.this.myKeymap.getParent() : null;
            Icon icon = null;
            boolean bound = false;
            this.setToolTipText(null);
            if (value instanceof DefaultMutableTreeNode) {
                Color foreground;
                boolean changed;
                String text;
                Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                if (userObject instanceof Group) {
                    Group group = (Group)userObject;
                    text = group.getName();
                    changed = originalKeymap != null && ActionsTree.isGroupChanged(group, originalKeymap, ActionsTree.this.myKeymap);
                    icon = group.getIcon();
                    if (icon == null) {
                        icon = CLOSE_ICON;
                    }
                } else if (userObject instanceof String) {
                    String actionId = (String)userObject;
                    bound = ActionsTree.this.myShowBoundActions && ((KeymapImpl)ActionsTree.this.myKeymap).isActionBound(actionId);
                    AnAction action = ActionManager.getInstance().getActionOrStub(actionId);
                    if (action != null) {
                        Icon actionIcon;
                        text = action.getTemplatePresentation().getText();
                        if (text == null || text.length() == 0) {
                            text = actionId;
                        }
                        if ((actionIcon = action.getTemplatePresentation().getIcon()) != null) {
                            icon = actionIcon;
                        }
                        this.setToolTipText(action.getTemplatePresentation().getDescription());
                    } else {
                        text = actionId;
                    }
                    changed = originalKeymap != null && ActionsTree.isActionChanged(actionId, originalKeymap, ActionsTree.this.myKeymap);
                } else if (userObject instanceof QuickList) {
                    QuickList list = (QuickList)userObject;
                    icon = AllIcons.Actions.QuickList;
                    text = list.getDisplayName();
                    changed = originalKeymap != null && ActionsTree.isActionChanged(list.getActionId(), originalKeymap, ActionsTree.this.myKeymap);
                } else if (userObject instanceof Separator) {
                    changed = false;
                    text = "-------------";
                } else {
                    throw new IllegalArgumentException("unknown userObject: " + userObject);
                }
                if (showIcons) {
                    this.setIcon(ActionsTree.getEvenIcon(icon));
                }
                if (selected) {
                    foreground = UIUtil.getTreeSelectionForeground();
                } else {
                    foreground = changed ? PlatformColors.BLUE : UIUtil.getTreeForeground();
                    if (bound) {
                        foreground = JBColor.MAGENTA;
                    }
                }
                SearchUtil.appendFragments(ActionsTree.this.myFilter, text, 0, foreground, selected ? UIUtil.getTreeSelectionBackground() : UIUtil.getTreeTextBackground(), (SimpleColoredComponent)this);
            }
        }
    }

    private class PathsKeeper {
        private ArrayList<String> myPathsToExpand;
        private ArrayList<String> mySelectionPaths;

        private PathsKeeper() {
        }

        public void storePaths() {
            this.myPathsToExpand = new ArrayList();
            this.mySelectionPaths = new ArrayList();
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)ActionsTree.this.myTree.getModel().getRoot();
            TreePath path = new TreePath(root.getPath());
            if (ActionsTree.this.myTree.isPathSelected(path)) {
                this.addPathToList(root, this.mySelectionPaths);
            }
            if (ActionsTree.this.myTree.isExpanded(path) || root.getChildCount() == 0) {
                this.addPathToList(root, this.myPathsToExpand);
                this._storePaths(root);
            }
        }

        private void addPathToList(DefaultMutableTreeNode root, ArrayList<String> list) {
            String path = ActionsTree.this.getPath(root);
            if (!StringUtil.isEmpty((String)path)) {
                list.add(path);
            }
        }

        private void _storePaths(DefaultMutableTreeNode root) {
            ArrayList<TreeNode> childNodes = this.childrenToArray(root);
            for (TreeNode childNode1 : childNodes) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)childNode1;
                TreePath path = new TreePath(childNode.getPath());
                if (ActionsTree.this.myTree.isPathSelected(path)) {
                    this.addPathToList(childNode, this.mySelectionPaths);
                }
                if (!ActionsTree.this.myTree.isExpanded(path) && childNode.getChildCount() != 0 || childNode.isLeaf()) continue;
                this.addPathToList(childNode, this.myPathsToExpand);
                this._storePaths(childNode);
            }
        }

        public void restorePaths() {
            ArrayList nodesToExpand = ActionsTree.this.getNodesByPaths(this.myPathsToExpand);
            for (DefaultMutableTreeNode node : nodesToExpand) {
                ActionsTree.this.myTree.expandPath(new TreePath(node.getPath()));
            }
            if (ActionsTree.this.myTree.getSelectionModel().getSelectionCount() == 0) {
                ArrayList nodesToSelect = ActionsTree.this.getNodesByPaths(this.mySelectionPaths);
                if (!nodesToSelect.isEmpty()) {
                    for (DefaultMutableTreeNode node : nodesToSelect) {
                        TreeUtil.selectInTree((DefaultMutableTreeNode)node, (boolean)false, (JTree)ActionsTree.this.myTree);
                    }
                } else {
                    ActionsTree.this.myTree.setSelectionRow(0);
                }
            }
        }

        private ArrayList<TreeNode> childrenToArray(DefaultMutableTreeNode node) {
            ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
            for (int i = 0; i < node.getChildCount(); ++i) {
                arrayList.add(node.getChildAt(i));
            }
            return arrayList;
        }
    }

    private class MyModel
    extends DefaultTreeModel
    implements TreeTableModel {
        protected MyModel(DefaultMutableTreeNode root) {
            super(root);
        }

        public void setTree(JTree tree) {
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return KeyMapBundle.message((String)"action.column.name", (Object[])new Object[0]);
                }
                case 1: {
                    return KeyMapBundle.message((String)"shortcuts.column.name", (Object[])new Object[0]);
                }
            }
            return "";
        }

        public Object getValueAt(Object value, int column) {
            if (!(value instanceof DefaultMutableTreeNode)) {
                return "???";
            }
            if (column == 0) {
                return value;
            }
            if (column == 1) {
                Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                if (userObject instanceof QuickList) {
                    userObject = ((QuickList)userObject).getActionId();
                }
                if (userObject instanceof String) {
                    Shortcut[] shortcuts = ActionsTree.this.myKeymap.getShortcuts((String)userObject);
                    return KeymapUtil.getShortcutsText((Shortcut[])shortcuts);
                }
                return "";
            }
            return "???";
        }

        @Override
        public Object getChild(Object parent, int index) {
            return ((TreeNode)parent).getChildAt(index);
        }

        @Override
        public int getChildCount(Object parent) {
            return ((TreeNode)parent).getChildCount();
        }

        public Class getColumnClass(int column) {
            if (column == 0) {
                return TreeTableModel.class;
            }
            return Object.class;
        }

        public boolean isCellEditable(Object node, int column) {
            return column == 0;
        }

        public void setValueAt(Object aValue, Object node, int column) {
        }
    }
}

