/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TooManyUsagesStatus {
    private static final Key<TooManyUsagesStatus> KEY = Key.create((String)"TooManyUsagesStatus");
    private static final NullStatus NULL_STATUS = new NullStatus();
    private final AtomicReference<Status> tooManyUsagesStatus = new AtomicReference<Status>(Status.FEW_USAGES);
    private final CountDownLatch waitWhileUserClick = new CountDownLatch(1);

    @NotNull
    public static TooManyUsagesStatus getFrom(@Nullable ProgressIndicator indicator) {
        TooManyUsagesStatus data = indicator instanceof UserDataHolder ? (TooManyUsagesStatus)((UserDataHolder)indicator).getUserData(KEY) : null;
        TooManyUsagesStatus tooManyUsagesStatus = data == null ? NULL_STATUS : data;
        if (tooManyUsagesStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/TooManyUsagesStatus", "getFrom"));
        }
        return tooManyUsagesStatus;
    }

    public static TooManyUsagesStatus createFor(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/util/TooManyUsagesStatus", "createFor"));
        }
        TooManyUsagesStatus data = null;
        if (indicator instanceof UserDataHolder) {
            data = new TooManyUsagesStatus();
            ((UserDataHolder)indicator).putUserData(KEY, (Object)data);
        }
        return data;
    }

    public boolean switchTooManyUsagesStatus() {
        return this.tooManyUsagesStatus.get() == Status.FEW_USAGES && this.tooManyUsagesStatus.compareAndSet(Status.FEW_USAGES, Status.WARNING_DIALOG_SHOWN);
    }

    public void userResponded() {
        this.waitWhileUserClick.countDown();
        this.tooManyUsagesStatus.set(Status.USER_RESPONDED);
    }

    public void pauseProcessingIfTooManyUsages() {
        if (this.tooManyUsagesStatus.get() == Status.WARNING_DIALOG_SHOWN) {
            try {
                this.waitWhileUserClick.await(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static class NullStatus
    extends TooManyUsagesStatus {
        private NullStatus() {
        }

        @Override
        public boolean switchTooManyUsagesStatus() {
            return false;
        }

        @Override
        public void userResponded() {
        }

        @Override
        public void pauseProcessingIfTooManyUsages() {
        }
    }

    public static enum Status {
        FEW_USAGES,
        WARNING_DIALOG_SHOWN,
        USER_RESPONDED;

    }
}

