/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class VirtualFileHolder
implements FileHolder {
    private final Set<VirtualFile> myFiles = new HashSet<VirtualFile>();
    private final Project myProject;
    private final FileHolder.HolderType myType;
    private int myNumDirs;

    public VirtualFileHolder(Project project, FileHolder.HolderType type) {
        this.myProject = project;
        this.myType = type;
    }

    @Override
    public FileHolder.HolderType getType() {
        return this.myType;
    }

    @Override
    public void notifyVcsStarted(AbstractVcs vcs) {
    }

    @Override
    public void cleanAll() {
        this.myFiles.clear();
        this.myNumDirs = 0;
    }

    static int cleanScope(final Project project, final Collection<VirtualFile> files, final VcsModifiableDirtyScope scope) {
        return (Integer)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Integer>(){

            public Integer compute() {
                int result;
                block7: {
                    block6: {
                        result = 0;
                        if (project.isDisposed() || files.isEmpty()) {
                            return 0;
                        }
                        if (scope.getRecursivelyDirtyDirectories().size() != 0) break block6;
                        Set dirtyFiles = scope.getDirtyFiles();
                        boolean cleanDroppedFiles = false;
                        for (FilePath dirtyFile : dirtyFiles) {
                            VirtualFile f = dirtyFile.getVirtualFile();
                            if (f != null) {
                                if (!files.remove(f) || !f.isDirectory()) continue;
                                ++result;
                                continue;
                            }
                            cleanDroppedFiles = true;
                        }
                        if (!cleanDroppedFiles) break block7;
                        Iterator iterator = files.iterator();
                        while (iterator.hasNext()) {
                            VirtualFile file = (VirtualFile)iterator.next();
                            if (!VirtualFileHolder.fileDropped(file)) continue;
                            iterator.remove();
                            scope.addDirtyFile((FilePath)new FilePathImpl(file));
                            if (!file.isDirectory()) continue;
                            ++result;
                        }
                        break block7;
                    }
                    Iterator iterator = files.iterator();
                    while (iterator.hasNext()) {
                        VirtualFile file = (VirtualFile)iterator.next();
                        boolean fileDropped = VirtualFileHolder.fileDropped(file);
                        if (fileDropped) {
                            scope.addDirtyFile((FilePath)new FilePathImpl(file));
                        }
                        if (!fileDropped && !scope.belongsTo((FilePath)new FilePathImpl(file))) continue;
                        iterator.remove();
                        if (!file.isDirectory()) continue;
                        ++result;
                    }
                }
                return result;
            }
        });
    }

    @Override
    public void cleanAndAdjustScope(VcsModifiableDirtyScope scope) {
        this.myNumDirs -= VirtualFileHolder.cleanScope(this.myProject, this.myFiles, scope);
    }

    private static boolean fileDropped(VirtualFile file) {
        return !file.isValid();
    }

    public void addFile(VirtualFile file) {
        if (this.myFiles.add(file) && file.isDirectory()) {
            ++this.myNumDirs;
        }
    }

    public void removeFile(VirtualFile file) {
        if (this.myFiles.remove(file) && file.isDirectory()) {
            --this.myNumDirs;
        }
    }

    public List<VirtualFile> getFiles() {
        return new ArrayList<VirtualFile>(this.myFiles);
    }

    @Override
    public VirtualFileHolder copy() {
        VirtualFileHolder copyHolder = new VirtualFileHolder(this.myProject, this.myType);
        copyHolder.myFiles.addAll(this.myFiles);
        copyHolder.myNumDirs = this.myNumDirs;
        return copyHolder;
    }

    public boolean containsFile(VirtualFile file) {
        return this.myFiles.contains(file);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirtualFileHolder that = (VirtualFileHolder)o;
        return ((Object)this.myFiles).equals(that.myFiles);
    }

    public int hashCode() {
        return ((Object)this.myFiles).hashCode();
    }

    public int getSize() {
        return this.myFiles.size();
    }

    public int getNumDirs() {
        assert (this.myNumDirs >= 0);
        return this.myNumDirs;
    }
}

