/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.http;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteContentProvider;
import com.intellij.openapi.vfs.impl.http.RemoteFileUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.Url;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.net.ssl.CertificateManager;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.Responses;

public class DefaultRemoteContentProvider
extends RemoteContentProvider {
    private static final Logger LOG = Logger.getInstance(DefaultRemoteContentProvider.class);

    @Override
    public boolean canProvideContent(@NotNull Url url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/impl/http/DefaultRemoteContentProvider", "canProvideContent"));
        }
        return true;
    }

    @Override
    public void saveContent(final @NotNull Url url, final @NotNull File file, final @NotNull RemoteContentProvider.DownloadingCallback callback) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/impl/http/DefaultRemoteContentProvider", "saveContent"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/http/DefaultRemoteContentProvider", "saveContent"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/openapi/vfs/impl/http/DefaultRemoteContentProvider", "saveContent"));
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                DefaultRemoteContentProvider.downloadContent(url, file, callback);
            }
        });
    }

    private static void downloadContent(final @NotNull Url url, final File file, final RemoteContentProvider.DownloadingCallback callback) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/impl/http/DefaultRemoteContentProvider", "downloadContent"));
        }
        LOG.debug("Downloading started: " + url);
        final String presentableUrl = StringUtil.trimMiddle((String)url.trimParameters().toDecodedForm(), (int)40);
        callback.setProgressText(VfsBundle.message((String)"download.progress.connecting", (Object[])new Object[]{presentableUrl}), true);
        try {
            HttpRequests.request((String)url.toExternalForm()).connectTimeout(60000).readTimeout(60000).userAgent(Responses.getServerHeaderValue()).hostNameVerifier(CertificateManager.HOSTNAME_VERIFIER).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object process(@NotNull HttpRequests.Request request) throws IOException {
                    FileType fileTypeByFileName;
                    if (request == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/openapi/vfs/impl/http/DefaultRemoteContentProvider$2", "process"));
                    }
                    HttpURLConnection connection = (HttpURLConnection)request.getConnection();
                    int responseCode = connection.getResponseCode();
                    if (responseCode != 200) {
                        throw new IOException(IdeBundle.message((String)"error.connection.failed.with.http.code.N", (Object[])new Object[]{responseCode}));
                    }
                    int size = connection.getContentLength();
                    BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));
                    try {
                        int count;
                        callback.setProgressText(VfsBundle.message((String)"download.progress.downloading", (Object[])new Object[]{presentableUrl}), size == -1);
                        if (size != -1) {
                            callback.setProgressFraction(0.0);
                        }
                        byte[] buf = new byte[4096];
                        int total = 0;
                        while ((count = request.getInputStream().read(buf)) > 0) {
                            if (callback.isCancelled()) {
                                Object var9_10 = null;
                                return var9_10;
                            }
                            total += count;
                            if (size > 0) {
                                callback.setProgressFraction((double)total / (double)size);
                            }
                            ((OutputStream)output).write(buf, 0, count);
                        }
                    }
                    finally {
                        ((OutputStream)output).close();
                    }
                    FileType fileType = RemoteFileUtil.getFileType(connection.getContentType());
                    if (fileType == FileTypes.PLAIN_TEXT && (fileTypeByFileName = FileTypeRegistry.getInstance().getFileTypeByFileName(PathUtilRt.getFileName((String)url.getPath()))) != FileTypes.UNKNOWN) {
                        fileType = fileTypeByFileName;
                    }
                    LOG.debug("Downloading finished, " + size + " bytes downloaded");
                    callback.finished(fileType);
                    return null;
                }
            });
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            callback.errorOccurred(VfsBundle.message((String)"cannot.load.remote.file", (Object[])new Object[]{url, e.getMessage()}), false);
        }
    }

    @Override
    public boolean isUpToDate(@NotNull Url url, @NotNull VirtualFile local) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/impl/http/DefaultRemoteContentProvider", "isUpToDate"));
        }
        if (local == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "local", "com/intellij/openapi/vfs/impl/http/DefaultRemoteContentProvider", "isUpToDate"));
        }
        return false;
    }
}

