/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.javadoc;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDClassComment;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDComment;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDMethodComment;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDParser;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommentFormatter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.codeStyle.javadoc.CommentFormatter");
    private final CodeStyleSettings mySettings;
    private final JDParser myParser;
    private final Project myProject;

    public CommentFormatter(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/source/codeStyle/javadoc/CommentFormatter", "<init>"));
        }
        this.mySettings = CodeStyleSettingsManager.getSettings((Project)project);
        this.myParser = new JDParser(this.mySettings, LanguageLevelProjectExtension.getInstance((Project)project).getLanguageLevel());
        this.myProject = project;
    }

    public CodeStyleSettings getSettings() {
        return this.mySettings;
    }

    public JDParser getParser() {
        return this.myParser;
    }

    public void processComment(@Nullable ASTNode element) {
        if (!this.getSettings().ENABLE_JAVADOC_FORMATTING) {
            return;
        }
        PsiElement psiElement = SourceTreeToPsiMap.treeElementToPsi(element);
        this.processElementComment(psiElement);
    }

    private void processElementComment(@Nullable PsiElement psiElement) {
        if (psiElement instanceof PsiClass) {
            String newCommentText = this.formatClassComment((PsiClass)psiElement);
            this.replaceDocComment(newCommentText, (PsiDocCommentOwner)psiElement);
        } else if (psiElement instanceof PsiMethod) {
            String newCommentText = this.formatMethodComment((PsiMethod)psiElement);
            this.replaceDocComment(newCommentText, (PsiDocCommentOwner)psiElement);
        } else if (psiElement instanceof PsiField) {
            String newCommentText = this.formatFieldComment((PsiField)psiElement);
            this.replaceDocComment(newCommentText, (PsiDocCommentOwner)psiElement);
        } else if (psiElement instanceof PsiDocComment) {
            this.processElementComment(psiElement.getParent());
        }
    }

    private void replaceDocComment(@Nullable String newCommentText, @NotNull PsiDocCommentOwner psiDocCommentOwner) {
        if (psiDocCommentOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiDocCommentOwner", "com/intellij/psi/impl/source/codeStyle/javadoc/CommentFormatter", "replaceDocComment"));
        }
        PsiDocComment oldComment = psiDocCommentOwner.getDocComment();
        if (newCommentText != null) {
            newCommentText = CommentFormatter.stripSpaces(newCommentText);
        }
        if (newCommentText == null || oldComment == null || newCommentText.equals(oldComment.getText())) {
            return;
        }
        try {
            PsiComment newComment = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory().createCommentFromText(newCommentText, null);
            ASTNode oldNode = oldComment.getNode();
            ASTNode newNode = newComment.getNode();
            assert (oldNode != null && newNode != null);
            ASTNode parent = oldNode.getTreeParent();
            parent.replaceChild(oldNode, newNode);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static String stripSpaces(String text) {
        String[] lines = LineTokenizer.tokenize((char[])text.toCharArray(), (boolean)false);
        StringBuilder buf = new StringBuilder(text.length());
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                buf.append('\n');
            }
            buf.append(CommentFormatter.rTrim(lines[i]));
        }
        return buf.toString();
    }

    private static String rTrim(String text) {
        int idx;
        for (idx = text.length(); idx > 0 && Character.isWhitespace(text.charAt(idx - 1)); --idx) {
        }
        return text.substring(0, idx);
    }

    @Nullable
    private String formatClassComment(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/source/codeStyle/javadoc/CommentFormatter", "formatClassComment"));
        }
        String info = CommentFormatter.getOrigCommentInfo((PsiDocCommentOwner)psiClass);
        if (info == null) {
            return null;
        }
        JDComment comment = this.getParser().parse(info, new JDClassComment(this));
        return comment.generate(this.getIndent((PsiElement)psiClass));
    }

    @Nullable
    private String formatMethodComment(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/psi/impl/source/codeStyle/javadoc/CommentFormatter", "formatMethodComment"));
        }
        String info = CommentFormatter.getOrigCommentInfo((PsiDocCommentOwner)psiMethod);
        if (info == null) {
            return null;
        }
        JDComment comment = this.getParser().parse(info, new JDMethodComment(this));
        return comment.generate(this.getIndent((PsiElement)psiMethod));
    }

    @Nullable
    private String formatFieldComment(@NotNull PsiField psiField) {
        if (psiField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiField", "com/intellij/psi/impl/source/codeStyle/javadoc/CommentFormatter", "formatFieldComment"));
        }
        String info = CommentFormatter.getOrigCommentInfo((PsiDocCommentOwner)psiField);
        if (info == null) {
            return null;
        }
        JDComment comment = this.getParser().parse(info, new JDComment(this));
        return comment.generate(this.getIndent((PsiElement)psiField));
    }

    @Nullable
    private static String getOrigCommentInfo(PsiDocCommentOwner element) {
        StringBuilder sb = new StringBuilder();
        PsiElement e = element.getFirstChild();
        if (!(e instanceof PsiComment)) {
            return null;
        }
        boolean first = true;
        while (true) {
            if (e instanceof PsiDocComment) {
                PsiComment cm = (PsiComment)e;
                String text = cm.getText();
                if (text.startsWith("//")) {
                    if (!first) {
                        sb.append('\n');
                    }
                    sb.append(text.substring(2).trim());
                } else if (text.startsWith("/*")) {
                    text = text.charAt(2) == '*' ? text.substring(3, Math.max(3, text.length() - 2)) : text.substring(2, Math.max(2, text.length() - 2));
                    sb.append(text);
                }
            } else if (!(e instanceof PsiWhiteSpace) && !(e instanceof PsiComment)) break;
            first = false;
            e = e.getNextSibling();
        }
        return sb.toString();
    }

    private int getIndentSpecial(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/codeStyle/javadoc/CommentFormatter", "getIndentSpecial"));
        }
        assert (element instanceof PsiClass || element instanceof PsiField || element instanceof PsiMethod);
        int indentSize = this.mySettings.getIndentSize((FileType)JavaFileType.INSTANCE);
        boolean doNotIndentTopLevelClassMembers = this.mySettings.getCommonSettings((Language)JavaLanguage.INSTANCE).DO_NOT_INDENT_TOP_LEVEL_CLASS_MEMBERS;
        int indent = 0;
        PsiClass top = PsiUtil.getTopLevelClass((PsiElement)element);
        while (!(top == null || element.isEquivalentTo((PsiElement)top) || doNotIndentTopLevelClassMembers && element.getParent().isEquivalentTo((PsiElement)top))) {
            element = element.getParent();
            indent += indentSize;
        }
        return indent;
    }

    @NotNull
    private String getIndent(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/codeStyle/javadoc/CommentFormatter", "getIndent"));
        }
        String string = StringUtil.repeatSymbol((char)' ', (int)this.getIndentSpecial(element));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/javadoc/CommentFormatter", "getIndent"));
        }
        return string;
    }
}

