/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogStructureFilterImpl
implements VcsLogDetailsFilter,
VcsLogStructureFilter {
    @NotNull
    private final Collection<VirtualFile> myFiles;
    @NotNull
    private final MultiMap<VirtualFile, VirtualFile> myFilesByRoots;

    public VcsLogStructureFilterImpl(@NotNull Collection<VirtualFile> files, @NotNull Collection<VirtualFile> roots) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/vcs/log/data/VcsLogStructureFilterImpl", "<init>"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/data/VcsLogStructureFilterImpl", "<init>"));
        }
        this.myFiles = files;
        this.myFilesByRoots = VcsLogStructureFilterImpl.groupFilesByVcsRoots(files, roots);
    }

    @NotNull
    private static MultiMap<VirtualFile, VirtualFile> groupFilesByVcsRoots(@NotNull Collection<VirtualFile> files, @NotNull Collection<VirtualFile> roots) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/vcs/log/data/VcsLogStructureFilterImpl", "groupFilesByVcsRoots"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/data/VcsLogStructureFilterImpl", "groupFilesByVcsRoots"));
        }
        MultiMap grouped = MultiMap.create();
        for (VirtualFile file : files) {
            VirtualFile root = VcsLogStructureFilterImpl.findBestRoot(file, roots);
            if (root == null) continue;
            grouped.putValue((Object)root, (Object)file);
        }
        MultiMap multiMap = grouped;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogStructureFilterImpl", "groupFilesByVcsRoots"));
        }
        return multiMap;
    }

    @Nullable
    private static VirtualFile findBestRoot(@NotNull VirtualFile file, @NotNull Collection<VirtualFile> roots) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/vcs/log/data/VcsLogStructureFilterImpl", "findBestRoot"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/data/VcsLogStructureFilterImpl", "findBestRoot"));
        }
        VirtualFile candidate = null;
        for (VirtualFile root : roots) {
            if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false) || candidate != null && !VfsUtilCore.isAncestor((VirtualFile)candidate, (VirtualFile)root, (boolean)true)) continue;
            candidate = root;
        }
        return candidate;
    }

    public boolean matches(@NotNull VcsCommitMetadata details) {
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/vcs/log/data/VcsLogStructureFilterImpl", "matches"));
        }
        if (details instanceof VcsFullCommitDetails) {
            for (Change change : ((VcsFullCommitDetails)details).getChanges()) {
                ContentRevision before = change.getBeforeRevision();
                if (before != null && this.matches(before.getFile().getPath())) {
                    return true;
                }
                ContentRevision after = change.getAfterRevision();
                if (after == null || !this.matches(after.getFile().getPath())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean matches(final @NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/vcs/log/data/VcsLogStructureFilterImpl", "matches"));
        }
        return ContainerUtil.find(this.myFiles, (Condition)new Condition<VirtualFile>(){

            public boolean value(VirtualFile file) {
                return FileUtil.isAncestor((String)file.getPath(), (String)path, (boolean)false);
            }
        }) != null;
    }

    @NotNull
    public Collection<VirtualFile> getFiles(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/VcsLogStructureFilterImpl", "getFiles"));
        }
        Collection collection = this.myFilesByRoots.get((Object)root);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogStructureFilterImpl", "getFiles"));
        }
        return collection;
    }
}

