/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.graph.GraphColorManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GraphColorManagerImpl
implements GraphColorManager<Integer> {
    private static final Logger LOG = Logger.getInstance(GraphColorManagerImpl.class);
    static final int DEFAULT_COLOR = 0;
    @NotNull
    private final RefsModel myRefsModel;
    @NotNull
    private final NotNullFunction<Integer, Hash> myHashGetter;
    @NotNull
    private final Map<VirtualFile, VcsLogRefManager> myRefManagers;
    @NotNull
    private final LinkedHashMap<Integer, Integer> myErrorWasReported;

    public GraphColorManagerImpl(@NotNull RefsModel refsModel, @NotNull NotNullFunction<Integer, Hash> hashGetter, @NotNull Map<VirtualFile, VcsLogRefManager> refManagers) {
        if (refsModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refsModel", "com/intellij/vcs/log/graph/GraphColorManagerImpl", "<init>"));
        }
        if (hashGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashGetter", "com/intellij/vcs/log/graph/GraphColorManagerImpl", "<init>"));
        }
        if (refManagers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refManagers", "com/intellij/vcs/log/graph/GraphColorManagerImpl", "<init>"));
        }
        this.myErrorWasReported = new LinkedHashMap<Integer, Integer>(10){

            protected boolean removeEldestEntry(Map.Entry<Integer, Integer> eldest) {
                return this.size() > 100;
            }
        };
        this.myRefsModel = refsModel;
        this.myHashGetter = hashGetter;
        this.myRefManagers = refManagers;
    }

    public int getColorOfBranch(Integer headCommit) {
        Collection<VcsRef> refs = this.myRefsModel.refsToCommit(headCommit);
        if (this.isEmptyRefs(refs, headCommit)) {
            return 0;
        }
        VcsRef firstRef = Collections.min(refs, this.myRefManagers.get(this.getFirstRoot(refs)).getComparator());
        return firstRef.getName().hashCode();
    }

    @NotNull
    private VirtualFile getFirstRoot(@NotNull Collection<VcsRef> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/graph/GraphColorManagerImpl", "getFirstRoot"));
        }
        VirtualFile virtualFile = refs.iterator().next().getRoot();
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/GraphColorManagerImpl", "getFirstRoot"));
        }
        return virtualFile;
    }

    private boolean isEmptyRefs(@NotNull Collection<VcsRef> refs, int head) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/graph/GraphColorManagerImpl", "isEmptyRefs"));
        }
        if (refs.isEmpty()) {
            if (!this.myErrorWasReported.containsKey((Object)head)) {
                this.myErrorWasReported.put((Object)head, (Object)head);
                LOG.warn("No references found at head " + head + " which corresponds to hash " + this.myHashGetter.fun((Object)head));
            }
            return true;
        }
        return false;
    }

    public int getColorOfFragment(Integer headCommit, int magicIndex) {
        return magicIndex;
    }

    public int compareHeads(Integer head1, Integer head2) {
        VcsLogRefManager refManager2;
        if (head1.equals(head2)) {
            return 0;
        }
        Collection<VcsRef> refs1 = this.myRefsModel.refsToCommit(head1);
        Collection<VcsRef> refs2 = this.myRefsModel.refsToCommit(head2);
        boolean firstEmpty = this.isEmptyRefs(refs1, head1);
        boolean secondEmpty = this.isEmptyRefs(refs2, head2);
        if (firstEmpty && secondEmpty) {
            return 0;
        }
        if (firstEmpty) {
            return 1;
        }
        if (secondEmpty) {
            return -1;
        }
        VirtualFile root1 = this.getFirstRoot(refs1);
        VirtualFile root2 = this.getFirstRoot(refs2);
        VcsLogRefManager refManager1 = this.myRefManagers.get(root1);
        if (!refManager1.equals(refManager2 = this.myRefManagers.get(root2))) {
            return root1.getPresentableUrl().compareTo(root2.getPresentableUrl());
        }
        Comparator comparator = refManager1.getComparator();
        Iterator it1 = ContainerUtil.sorted(refs1, (Comparator)comparator).iterator();
        Iterator it2 = ContainerUtil.sorted(refs2, (Comparator)comparator).iterator();
        while (it1.hasNext() && it2.hasNext()) {
            VcsRef ref2;
            VcsRef ref1 = (VcsRef)it1.next();
            int compare = comparator.compare(ref1, ref2 = (VcsRef)it2.next());
            if (compare == 0) continue;
            return compare;
        }
        if (it1.hasNext()) {
            return -1;
        }
        if (it2.hasNext()) {
            return 1;
        }
        return 0;
    }
}

