/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.visible;

import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DottedEdges {
    @NotNull
    private final int[] sortedStartNodes;
    @NotNull
    private final int[] startEdgesPosition;
    @NotNull
    private final int[] endNodes;

    @NotNull
    public static DottedEdges newInstance(@NotNull MultiMap<Integer, Integer> delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/vcs/log/graph/impl/visible/DottedEdges", "newInstance"));
        }
        int[] nodesWithEdges = ArrayUtil.toIntArray((Collection)delegate.keySet());
        Arrays.sort(nodesWithEdges);
        int[] startIndexes = new int[nodesWithEdges.length + 1];
        int[] edges = new int[delegate.values().size()];
        int start = 0;
        for (int i = 0; i < startIndexes.length - 1; ++i) {
            startIndexes[i] = start;
            Iterator i$ = delegate.get((Object)nodesWithEdges[i]).iterator();
            while (i$.hasNext()) {
                int toNode;
                edges[start] = toNode = ((Integer)i$.next()).intValue();
                ++start;
            }
        }
        startIndexes[startIndexes.length - 1] = start;
        DottedEdges dottedEdges = new DottedEdges(nodesWithEdges, startIndexes, edges);
        if (dottedEdges == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/visible/DottedEdges", "newInstance"));
        }
        return dottedEdges;
    }

    public DottedEdges(@NotNull int[] sortedStartNodes, @NotNull int[] startEdgesPosition, @NotNull int[] endNodes) {
        if (sortedStartNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sortedStartNodes", "com/intellij/vcs/log/graph/impl/visible/DottedEdges", "<init>"));
        }
        if (startEdgesPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startEdgesPosition", "com/intellij/vcs/log/graph/impl/visible/DottedEdges", "<init>"));
        }
        if (endNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endNodes", "com/intellij/vcs/log/graph/impl/visible/DottedEdges", "<init>"));
        }
        this.sortedStartNodes = sortedStartNodes;
        this.startEdgesPosition = startEdgesPosition;
        this.endNodes = endNodes;
    }

    public List<Integer> getAdjacentNodes(int nodeIndex) {
        int smallIndex = Arrays.binarySearch(this.sortedStartNodes, nodeIndex);
        if (smallIndex < 0) {
            return Collections.emptyList();
        }
        SmartList result = new SmartList();
        for (int i = this.startEdgesPosition[smallIndex]; i < this.startEdgesPosition[smallIndex + 1]; ++i) {
            result.add(this.endNodes[i]);
        }
        return result;
    }
}

