/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.popup.util.DetailView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.ui.XBreakpointActionsPanel;
import com.intellij.xdebugger.impl.breakpoints.ui.XBreakpointPropertiesSubPanel;
import com.intellij.xdebugger.impl.breakpoints.ui.XMasterBreakpointPanel;
import com.intellij.xdebugger.impl.breakpoints.ui.XSuspendPolicyPanel;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionComboBox;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.Border;

public class XLightBreakpointPropertiesPanel<B extends XBreakpointBase<?, ?, ?>>
implements XSuspendPolicyPanel.Delegate {
    public static final String CONDITION_HISTORY_ID = "breakpointCondition";
    private boolean myShowMoreOptions;
    private JPanel myConditionExpressionPanel;
    private JPanel myConditionPanel;
    private JPanel myMainPanel;
    private Delegate myDelegate;
    private XSuspendPolicyPanel<B> mySuspendPolicyPanel;
    private XBreakpointActionsPanel<B> myActionsPanel;
    private XMasterBreakpointPanel<B> myMasterBreakpointPanel;
    private JPanel myCustomPropertiesPanelWrapper;
    private JPanel myCustomConditionsPanelWrapper;
    private JCheckBox myEnabledCheckbox;
    private JPanel myCustomRightPropertiesPanelWrapper;
    private JBCheckBox myConditionEnabledCheckbox;
    private JPanel myCustomTopPropertiesPanelWrapper;
    private JPanel myConditionEnabledPanel;
    private final List<XBreakpointCustomPropertiesPanel<B>> myCustomPanels;
    private List<XBreakpointPropertiesSubPanel<B>> mySubPanels;
    private XDebuggerExpressionComboBox myConditionComboBox;
    private B myBreakpoint;
    private final boolean myShowAllOptions;
    private static final String CONDITION_ENABLED_LABEL = "label";
    private static final String CONDITION_ENABLED_CHECKBOX = "checkbox";

    public boolean showMoreOptions() {
        return this.myShowMoreOptions;
    }

    @Override
    public void showMoreOptionsIfNeeded() {
        if (this.myShowMoreOptions && this.myDelegate != null) {
            this.myDelegate.showMoreOptions();
        }
    }

    public Delegate getDelegate() {
        return this.myDelegate;
    }

    public void setDelegate(Delegate delegate) {
        this.myDelegate = delegate;
    }

    public void setDetailView(DetailView detailView) {
        this.myMasterBreakpointPanel.setDetailView(detailView);
    }

    public XLightBreakpointPropertiesPanel(Project project, XBreakpointManager breakpointManager, B breakpoint, boolean showAllOptions) {
        XBreakpointCustomPropertiesPanel customRightConditionPanel;
        XBreakpointCustomPropertiesPanel customConditionPanel;
        this.$$$setupUI$$$();
        this.mySubPanels = new ArrayList<XBreakpointPropertiesSubPanel<B>>();
        this.myBreakpoint = breakpoint;
        this.myShowAllOptions = showAllOptions;
        XBreakpointType<B, ?> breakpointType = XBreakpointUtil.getType(breakpoint);
        this.mySuspendPolicyPanel.init(project, breakpointManager, breakpoint);
        this.mySuspendPolicyPanel.setDelegate(this);
        this.mySubPanels.add(this.mySuspendPolicyPanel);
        this.myMasterBreakpointPanel.init(project, breakpointManager, breakpoint);
        this.mySubPanels.add(this.myMasterBreakpointPanel);
        XDebuggerEditorsProvider debuggerEditorsProvider = breakpointType.getEditorsProvider(breakpoint, project);
        this.myActionsPanel.init(project, breakpointManager, breakpoint, debuggerEditorsProvider);
        this.mySubPanels.add(this.myActionsPanel);
        this.myCustomPanels = new ArrayList<XBreakpointCustomPropertiesPanel<B>>();
        if (debuggerEditorsProvider != null) {
            this.myConditionEnabledCheckbox = new JBCheckBox(XDebuggerBundle.message((String)"xbreakpoints.condition.checkbox", (Object[])new Object[0]));
            JBLabel conditionEnabledLabel = new JBLabel(XDebuggerBundle.message((String)"xbreakpoints.condition.checkbox", (Object[])new Object[0]));
            conditionEnabledLabel.setBorder((Border)UIUtil.getTextAlignBorder((JToggleButton)this.myConditionEnabledCheckbox));
            this.myConditionEnabledPanel.add((Component)this.myConditionEnabledCheckbox, CONDITION_ENABLED_CHECKBOX);
            this.myConditionEnabledPanel.add((Component)conditionEnabledLabel, CONDITION_ENABLED_LABEL);
            this.myConditionComboBox = new XDebuggerExpressionComboBox(project, debuggerEditorsProvider, CONDITION_HISTORY_ID, ((XBreakpointBase)this.myBreakpoint).getSourcePosition());
            JComponent conditionComponent = this.myConditionComboBox.getComponent();
            this.myConditionExpressionPanel.add((Component)conditionComponent, "Center");
            this.myConditionEnabledCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XLightBreakpointPropertiesPanel.this.onCheckboxChanged();
                }
            });
            DebuggerUIUtil.focusEditorOnCheck((JCheckBox)this.myConditionEnabledCheckbox, this.myConditionComboBox.getEditorComponent());
        } else {
            this.myConditionPanel.setVisible(false);
        }
        this.myShowMoreOptions = false;
        for (XBreakpointPropertiesSubPanel<B> panel : this.mySubPanels) {
            if (!panel.lightVariant(showAllOptions)) continue;
            this.myShowMoreOptions = true;
        }
        XBreakpointCustomPropertiesPanel customPropertiesPanel = breakpointType.createCustomPropertiesPanel();
        if (customPropertiesPanel != null) {
            this.myCustomPropertiesPanelWrapper.add((Component)customPropertiesPanel.getComponent(), "Center");
            this.myCustomPanels.add(customPropertiesPanel);
        }
        if ((customConditionPanel = breakpointType.createCustomConditionsPanel()) != null) {
            this.myCustomConditionsPanelWrapper.add((Component)customConditionPanel.getComponent(), "Center");
            this.myCustomPanels.add(customConditionPanel);
        }
        if ((customRightConditionPanel = breakpointType.createCustomRightPropertiesPanel(project)) != null && (showAllOptions || customRightConditionPanel.isVisibleOnPopup(breakpoint))) {
            this.myCustomRightPropertiesPanelWrapper.add((Component)customRightConditionPanel.getComponent(), "Center");
            this.myCustomPanels.add(customRightConditionPanel);
        } else {
            this.myCustomRightPropertiesPanelWrapper.getParent().remove(this.myCustomRightPropertiesPanelWrapper);
        }
        XBreakpointCustomPropertiesPanel customTopPropertiesPanel = breakpointType.createCustomTopPropertiesPanel(project);
        if (customTopPropertiesPanel != null) {
            this.myCustomTopPropertiesPanelWrapper.add((Component)customTopPropertiesPanel.getComponent(), "Center");
            this.myCustomPanels.add(customTopPropertiesPanel);
        }
        this.myMainPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent event) {
                JComponent compToFocus = XLightBreakpointPropertiesPanel.this.myConditionComboBox != null && XLightBreakpointPropertiesPanel.this.myConditionComboBox.getComboBox().isEnabled() ? XLightBreakpointPropertiesPanel.this.myConditionComboBox.getEditorComponent() : XLightBreakpointPropertiesPanel.this.myActionsPanel.getDefaultFocusComponent();
                if (compToFocus != null) {
                    IdeFocusManager.findInstance().requestFocus((Component)compToFocus, false);
                }
            }
        });
        this.myEnabledCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                XLightBreakpointPropertiesPanel.this.myBreakpoint.setEnabled(XLightBreakpointPropertiesPanel.this.myEnabledCheckbox.isSelected());
            }
        });
    }

    private void onCheckboxChanged() {
        if (this.myConditionComboBox != null) {
            this.myConditionComboBox.setEnabled(this.myConditionEnabledCheckbox.isSelected());
        }
    }

    public void saveProperties() {
        for (XBreakpointPropertiesSubPanel<B> xBreakpointPropertiesSubPanel : this.mySubPanels) {
            xBreakpointPropertiesSubPanel.saveProperties();
        }
        if (this.myConditionComboBox != null) {
            XExpression expression = this.myConditionComboBox.getExpression();
            XExpression xExpression = !XDebuggerUtilImpl.isEmptyExpression(expression) ? expression : null;
            ((XBreakpointBase)this.myBreakpoint).setConditionEnabled(xExpression == null || this.myConditionEnabledCheckbox.isSelected());
            ((XBreakpointBase)this.myBreakpoint).setConditionExpression(xExpression);
            this.myConditionComboBox.saveTextInHistory();
        }
        for (XBreakpointCustomPropertiesPanel xBreakpointCustomPropertiesPanel : this.myCustomPanels) {
            xBreakpointCustomPropertiesPanel.saveTo(this.myBreakpoint);
        }
        ((XBreakpointBase)this.myBreakpoint).setEnabled(this.myEnabledCheckbox.isSelected());
    }

    public void loadProperties() {
        for (XBreakpointPropertiesSubPanel<B> xBreakpointPropertiesSubPanel : this.mySubPanels) {
            xBreakpointPropertiesSubPanel.loadProperties();
        }
        if (this.myConditionComboBox != null) {
            XExpression condition = ((XBreakpointBase)this.myBreakpoint).getConditionExpressionInt();
            this.myConditionComboBox.setExpression(condition);
            boolean bl = !this.myShowAllOptions && condition == null;
            this.myConditionEnabledCheckbox.setSelected(bl || ((XBreakpointBase)this.myBreakpoint).isConditionEnabled() && condition != null);
            ((CardLayout)this.myConditionEnabledPanel.getLayout()).show(this.myConditionEnabledPanel, bl ? CONDITION_ENABLED_LABEL : CONDITION_ENABLED_CHECKBOX);
            this.onCheckboxChanged();
        }
        for (XBreakpointCustomPropertiesPanel xBreakpointCustomPropertiesPanel : this.myCustomPanels) {
            xBreakpointCustomPropertiesPanel.loadFrom(this.myBreakpoint);
        }
        this.myEnabledCheckbox.setSelected(((XBreakpointBase)this.myBreakpoint).isEnabled());
        this.myEnabledCheckbox.setText(XBreakpointUtil.getShortText(this.myBreakpoint) + " enabled");
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public void dispose() {
        this.myActionsPanel.dispose();
        for (XBreakpointCustomPropertiesPanel<B> panel : this.myCustomPanels) {
            panel.dispose();
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JCheckBox jCheckBox;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        JPanel jPanel6;
        JPanel jPanel7;
        JPanel jPanel8;
        this.myMainPanel = jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(11, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel8.add((Component)spacer, new GridConstraints(10, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myConditionPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel7, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myConditionExpressionPanel = jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel6, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, null, null, null, 1));
        this.myConditionEnabledPanel = jPanel5 = new JPanel();
        jPanel5.setLayout(new CardLayout(0, 0));
        jPanel7.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 1, 3, null, null, null));
        XSuspendPolicyPanel xSuspendPolicyPanel = new XSuspendPolicyPanel();
        this.mySuspendPolicyPanel = xSuspendPolicyPanel;
        JComponent jComponent = xSuspendPolicyPanel.$$$getRootComponent$$$();
        jPanel8.add((Component)jComponent, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        XBreakpointActionsPanel xBreakpointActionsPanel = new XBreakpointActionsPanel();
        this.myActionsPanel = xBreakpointActionsPanel;
        JComponent jComponent2 = xBreakpointActionsPanel.$$$getRootComponent$$$();
        jPanel8.add((Component)jComponent2, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        XMasterBreakpointPanel xMasterBreakpointPanel = new XMasterBreakpointPanel();
        this.myMasterBreakpointPanel = xMasterBreakpointPanel;
        JComponent jComponent3 = xMasterBreakpointPanel.$$$getRootComponent$$$();
        jPanel8.add((Component)jComponent3, new GridConstraints(6, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCustomPropertiesPanelWrapper = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel8.add((Component)jPanel4, new GridConstraints(8, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel8.add((Component)spacer2, new GridConstraints(9, 0, 1, 2, 0, 1, 6, 1, null, new Dimension(400, -1), null));
        this.myCustomConditionsPanelWrapper = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel3, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myEnabledCheckbox = jCheckBox = new JCheckBox();
        Font font = jCheckBox.getFont();
        jCheckBox.setFont(new Font(font.getName(), 1, font.getSize()));
        jCheckBox.setText("Enabled");
        jPanel8.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCustomRightPropertiesPanelWrapper = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        ((Component)jPanel2).setVisible(true);
        ((Component)jPanel2).setEnabled(true);
        jPanel8.add((Component)jPanel2, new GridConstraints(5, 1, 3, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel8.add((Component)spacer3, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myCustomTopPropertiesPanelWrapper = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel8.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    public static interface Delegate {
        public void showMoreOptions();
    }
}

