/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.initialization;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.NotNull;

public class OverridableMethodCallDuringObjectConstructionInspectionBase
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("overridable.method.call.in.constructor.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/initialization/OverridableMethodCallDuringObjectConstructionInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("overridable.method.call.in.constructor.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/initialization/OverridableMethodCallDuringObjectConstructionInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OverridableMethodCallInConstructorVisitor();
    }

    private static class OverridableMethodCallInConstructorVisitor
    extends BaseInspectionVisitor {
        private OverridableMethodCallInConstructorVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/initialization/OverridableMethodCallDuringObjectConstructionInspectionBase$OverridableMethodCallInConstructorVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(expression);
            if (!MethodCallUtils.isCallDuringObjectConstruction(expression)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                return;
            }
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class);
            if (containingClass == null || containingClass.hasModifierProperty("final")) {
                return;
            }
            PsiMethod calledMethod = expression.resolveMethod();
            if (calledMethod == null || !PsiUtil.canBeOverriden((PsiMethod)calledMethod)) {
                return;
            }
            PsiClass calledMethodClass = calledMethod.getContainingClass();
            if (calledMethodClass == null || !calledMethodClass.equals(containingClass)) {
                return;
            }
            this.registerMethodCallError(expression, expression);
        }
    }
}

