/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.types;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.NotNull;

public class ExpandOneLineLambda2CodeBlockIntention
extends Intention {
    private static final Logger LOG = Logger.getInstance((String)("#" + ExpandOneLineLambda2CodeBlockIntention.class.getName()));

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        LambdaExpressionPredicate lambdaExpressionPredicate = new LambdaExpressionPredicate();
        if (lambdaExpressionPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/types/ExpandOneLineLambda2CodeBlockIntention", "getElementPredicate"));
        }
        return lambdaExpressionPredicate;
    }

    @Override
    @NotNull
    public String getText() {
        if ("Expand lambda expression body to {...}" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/types/ExpandOneLineLambda2CodeBlockIntention", "getText"));
        }
        return "Expand lambda expression body to {...}";
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/types/ExpandOneLineLambda2CodeBlockIntention", "processIntention"));
        }
        PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLambdaExpression.class);
        LOG.assertTrue(lambdaExpression != null);
        PsiElement body = lambdaExpression.getBody();
        LOG.assertTrue(body instanceof PsiExpression);
        String blockText = "{";
        blockText = blockText + (PsiType.VOID.equals((Object)LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambdaExpression)) ? "" : "return ");
        blockText = blockText + body.getText() + ";}";
        String resultedLambdaText = lambdaExpression.getParameterList().getText() + "->" + blockText;
        PsiExpression expressionFromText = JavaPsiFacade.getElementFactory((Project)element.getProject()).createExpressionFromText(resultedLambdaText, (PsiElement)lambdaExpression);
        lambdaExpression.replace((PsiElement)expressionFromText);
    }

    private static class LambdaExpressionPredicate
    implements PsiElementPredicate {
        private LambdaExpressionPredicate() {
        }

        @Override
        public boolean satisfiedBy(PsiElement element) {
            PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLambdaExpression.class);
            if (lambdaExpression != null) {
                return lambdaExpression.getBody() instanceof PsiExpression;
            }
            return false;
        }
    }
}

