/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.branch;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgNameWithHashInfo;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgUtil;

public class HgBranchUtil {
    @NotNull
    public static Collection<String> getCommonBranches(@NotNull Collection<HgRepository> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/zmlx/hg4idea/branch/HgBranchUtil", "getCommonBranches"));
        }
        Collection<String> commonBranches = null;
        for (HgRepository repository : repositories) {
            Map<String, Set<Hash>> branchesWithHashes = repository.getBranches();
            Set<String> names = branchesWithHashes.keySet();
            if (commonBranches == null) {
                commonBranches = names;
                continue;
            }
            commonBranches = ContainerUtil.intersection(commonBranches, names);
        }
        if (commonBranches != null) {
            ArrayList<String> common = new ArrayList<String>(commonBranches);
            Collections.sort(common);
            ArrayList<String> arrayList = common;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/branch/HgBranchUtil", "getCommonBranches"));
            }
            return arrayList;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/branch/HgBranchUtil", "getCommonBranches"));
        }
        return list;
    }

    @NotNull
    public static Collection<String> getCommonBookmarks(@NotNull Collection<HgRepository> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/zmlx/hg4idea/branch/HgBranchUtil", "getCommonBookmarks"));
        }
        Collection<String> commonBookmarkNames = null;
        for (HgRepository repository : repositories) {
            Collection<HgNameWithHashInfo> bookmarksInfo = repository.getBookmarks();
            List<String> names = HgUtil.getNamesWithoutHashes(bookmarksInfo);
            if (commonBookmarkNames == null) {
                commonBookmarkNames = names;
                continue;
            }
            commonBookmarkNames = ContainerUtil.intersection(commonBookmarkNames, names);
        }
        if (commonBookmarkNames != null) {
            ArrayList<String> common = new ArrayList<String>(commonBookmarkNames);
            Collections.sort(common);
            ArrayList<String> arrayList = common;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/branch/HgBranchUtil", "getCommonBookmarks"));
            }
            return arrayList;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/branch/HgBranchUtil", "getCommonBookmarks"));
        }
        return list;
    }
}

