/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.inspections.internal.InternalInspection;

public class UnsafeReturnStatementVisitorInspection
extends InternalInspection {
    private static final String BASE_WALKING_VISITOR_NAME = JavaRecursiveElementWalkingVisitor.class.getName();
    private static final String BASE_VISITOR_NAME = JavaRecursiveElementVisitor.class.getName();
    private static final String EMPTY_LAMBDA = "public void visitLambdaExpression(PsiLambdaExpression expression) {}";
    private static final String EMPTY_CLASS = "public void visitClass(PsiClass aClass) {}";

    @Override
    @NotNull
    public PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/idea/devkit/inspections/internal/UnsafeReturnStatementVisitorInspection", "buildInternalVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitClass(PsiClass aClass) {
                super.visitClass(aClass);
                if ((InheritanceUtil.isInheritor((PsiClass)aClass, (boolean)true, (String)BASE_WALKING_VISITOR_NAME) || InheritanceUtil.isInheritor((PsiClass)aClass, (boolean)true, (String)BASE_VISITOR_NAME)) && UnsafeReturnStatementVisitorInspection.findVisitMethod(aClass, "visitReturnStatement", PsiReturnStatement.class.getName())) {
                    boolean skipLambdaFound = UnsafeReturnStatementVisitorInspection.findVisitMethod(aClass, "visitLambdaExpression", PsiLambdaExpression.class.getName());
                    boolean skipClassFound = UnsafeReturnStatementVisitorInspection.findVisitMethod(aClass, "visitClass", PsiClass.class.getName());
                    if (!skipClassFound || !skipLambdaFound) {
                        String[] methods;
                        String name;
                        if (!skipLambdaFound ^ !skipClassFound) {
                            if (!skipClassFound) {
                                name = "Insert visitLambdaExpression method";
                                methods = new String[]{UnsafeReturnStatementVisitorInspection.EMPTY_LAMBDA};
                            } else {
                                name = "Insert visitClass method";
                                methods = new String[]{UnsafeReturnStatementVisitorInspection.EMPTY_CLASS};
                            }
                        } else {
                            name = "Insert visitLambdaExpression/visitClass methods";
                            methods = new String[]{UnsafeReturnStatementVisitorInspection.EMPTY_LAMBDA, UnsafeReturnStatementVisitorInspection.EMPTY_CLASS};
                        }
                        holder.registerProblem((PsiElement)aClass, HighlightNamesUtil.getClassDeclarationTextRange((PsiClass)aClass).shiftRight(-aClass.getTextRange().getStartOffset()), "Recursive visitors which visit return statements most probably should specifically process anonymous/local classes as well as lambda expressions", new LocalQuickFix[]{new MySkipVisitFix(name, methods)});
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/internal/UnsafeReturnStatementVisitorInspection", "buildInternalVisitor"));
        }
        return javaElementVisitor;
    }

    private static boolean findVisitMethod(PsiClass aClass, String visitMethodName, String argumentType) {
        PsiMethod[] visitReturnStatements;
        for (PsiMethod method : visitReturnStatements = aClass.findMethodsByName(visitMethodName, false)) {
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (parameters.length != 1 || !parameters[0].getType().equalsToText(argumentType)) continue;
            return true;
        }
        return false;
    }

    private static class MySkipVisitFix
    implements LocalQuickFix {
        private final String myName;
        private final String[] myMethods;

        public MySkipVisitFix(String name, String[] methods) {
            this.myName = name;
            this.myMethods = methods;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/internal/UnsafeReturnStatementVisitorInspection$MySkipVisitFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Skip anonymous/local classes" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/internal/UnsafeReturnStatementVisitorInspection$MySkipVisitFix", "getFamilyName"));
            }
            return "Skip anonymous/local classes";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/devkit/inspections/internal/UnsafeReturnStatementVisitorInspection$MySkipVisitFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/idea/devkit/inspections/internal/UnsafeReturnStatementVisitorInspection$MySkipVisitFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiClass) {
                FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{element});
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                for (String method : this.myMethods) {
                    element.add((PsiElement)factory.createMethodFromText(method, element));
                }
            }
        }
    }
}

