/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import java.util.List;
import org.jetbrains.idea.maven.execution.MavenRunConfigurationType;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.utils.MavenDataKeys;
import org.jetbrains.idea.maven.utils.actions.MavenAction;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;

public class RunBuildAction
extends MavenAction {
    @Override
    protected boolean isAvailable(AnActionEvent e) {
        return super.isAvailable(e) && RunBuildAction.checkOrPerform(e.getDataContext(), false);
    }

    public void actionPerformed(AnActionEvent e) {
        RunBuildAction.checkOrPerform(e.getDataContext(), true);
    }

    private static boolean checkOrPerform(DataContext context, boolean perform) {
        List goals = (List)MavenDataKeys.MAVEN_GOALS.getData(context);
        if (goals == null || goals.isEmpty()) {
            return false;
        }
        MavenProject project = MavenActionUtil.getMavenProject(context);
        if (project == null) {
            return false;
        }
        if (!perform) {
            return true;
        }
        MavenExplicitProfiles explicitProfiles = MavenActionUtil.getProjectsManager(context).getExplicitProfiles();
        MavenRunnerParameters params = new MavenRunnerParameters(true, project.getDirectory(), goals, explicitProfiles.getEnabledProfiles(), explicitProfiles.getDisabledProfiles());
        MavenRunConfigurationType.runConfiguration(MavenActionUtil.getProject(context), params, null);
        return true;
    }
}

