/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index.creator;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.codehaus.plexus.component.annotations.Component;
import org.sonatype.nexus.index.ArtifactContext;
import org.sonatype.nexus.index.ArtifactInfo;
import org.sonatype.nexus.index.context.IndexCreator;
import org.sonatype.nexus.index.creator.AbstractIndexCreator;
import org.sonatype.nexus.index.creator.LegacyDocumentUpdater;

@Component(role=IndexCreator.class, hint="jarContent")
public class JarFileContentsIndexCreator
extends AbstractIndexCreator
implements LegacyDocumentUpdater {
    public void populateArtifactInfo(ArtifactContext artifactContext) throws IOException {
        ArtifactInfo ai = artifactContext.getArtifactInfo();
        File artifactFile = artifactContext.getArtifact();
        if (artifactFile != null && artifactFile.exists() && artifactFile.getName().endsWith(".jar")) {
            this.updateArtifactInfo(ai, artifactFile);
        }
    }

    public void updateDocument(ArtifactInfo ai, Document doc) {
        if (ai.classNames != null) {
            doc.add((Fieldable)new Field("c", ai.classNames, Field.Store.COMPRESS, Field.Index.TOKENIZED));
        }
    }

    public void updateLegacyDocument(ArtifactInfo ai, Document doc) {
        if (ai.classNames != null) {
            String classNames = ai.classNames;
            if (classNames.length() > 0 && classNames.charAt(0) == '/') {
                String[] lines = classNames.split("\\n");
                StringBuilder sb = new StringBuilder();
                for (String line : lines) {
                    sb.append(line.substring(1)).append('\n');
                }
                classNames = sb.toString();
            }
            doc.add((Fieldable)new Field("c", classNames, Field.Store.COMPRESS, Field.Index.TOKENIZED));
        }
    }

    public boolean updateArtifactInfo(Document doc, ArtifactInfo artifactInfo) {
        String names = doc.get("c");
        if (names != null) {
            if (names.length() == 0 || names.charAt(0) == '/') {
                artifactInfo.classNames = names;
            } else {
                String[] lines = names.split("\\n");
                StringBuilder sb = new StringBuilder();
                for (String line : lines) {
                    sb.append('/').append(line).append('\n');
                }
                artifactInfo.classNames = sb.toString();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateArtifactInfo(ArtifactInfo ai, File f) throws IOException {
        ZipFile jar = null;
        try {
            jar = new ZipFile(f);
            StringBuilder sb = new StringBuilder();
            Enumeration<? extends ZipEntry> en = jar.entries();
            while (en.hasMoreElements()) {
                ZipEntry e = en.nextElement();
                String name = e.getName();
                if (name.endsWith(".class")) {
                    int i = name.indexOf("$");
                    if (i != -1) continue;
                    if (name.charAt(0) != '/') {
                        sb.append('/');
                    }
                    sb.append(name.substring(0, name.length() - 6)).append('\n');
                    continue;
                }
                if (!"META-INF/archetype.xml".equals(name) && !"META-INF/maven/archetype.xml".equals(name) && !"META-INF/maven/archetype-metadata.xml".equals(name)) continue;
                ai.packaging = "maven-archetype";
            }
            ai.classNames = sb.toString();
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (Exception e) {
                    this.getLogger().error("Could not close jar file properly.", (Throwable)e);
                }
            }
        }
    }

    public String toString() {
        return "jarContent";
    }
}

